Imports System
Imports System.Configuration
Imports System.Data
Imports System.Data.Common
Imports System.Threading
Imports System.Web
Imports System.Collections.Generic
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports Microsoft.Practices.EnterpriseLibrary.Data
Namespace NetShopForge.Library.Address
    Public Class AddressController

        Public Function GetAddressList(ByVal UserName As String) As List(Of AddressInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Address_GetAddressList")
            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@UserName", DbType.String, UserName)


            Dim ddressList As New Generic.List(Of AddressInfo)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    ddressList.Add(FillAddressInfo(reader))
                End While
                Return ddressList
            End Using
        End Function

        Public Function GetAddress(ByVal AddressID As Integer) As AddressInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Address_GetAddress")
            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@AddressID", DbType.Int32, AddressID)


            Dim ddressList As New Generic.List(Of AddressInfo)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillAddressInfo(reader)
                End While
                Return Nothing
            End Using
        End Function

        Public Sub AddAddress(ByVal objAddress As AddressInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Address_AddAddress"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)


            Dim AddressID As Integer = NetShopForge.Common.GetKeys("AddressID")
            db.AddInParameter(dbCommand, "AddressID", DbType.Int32, AddressID)
            db.AddInParameter(dbCommand, "UserName", DbType.String, objAddress.UserName)
            db.AddInParameter(dbCommand, "FirstName", DbType.String, objAddress.FirstName)
            db.AddInParameter(dbCommand, "LastName", DbType.String, objAddress.LastName)
            db.AddInParameter(dbCommand, "Address1", DbType.String, objAddress.Address1)
            db.AddInParameter(dbCommand, "Address2", DbType.String, objAddress.Address2)
            db.AddInParameter(dbCommand, "Area", DbType.String, objAddress.Area)
            db.AddInParameter(dbCommand, "AreaID", DbType.String, objAddress.AreaID)
            db.AddInParameter(dbCommand, "City", DbType.String, objAddress.City)
            db.AddInParameter(dbCommand, "Province", DbType.String, objAddress.Province)
            db.AddInParameter(dbCommand, "Zip", DbType.String, objAddress.Zip)
            db.AddInParameter(dbCommand, "Country", DbType.String, objAddress.Country)
            db.AddInParameter(dbCommand, "Phone", DbType.String, objAddress.Phone)
            db.AddInParameter(dbCommand, "MobilePhone", DbType.String, objAddress.MobilePhone)
            db.AddInParameter(dbCommand, "IsDefault", DbType.Boolean, objAddress.IsDefault)
            db.ExecuteNonQuery(dbCommand)

            If objAddress.IsDefault Then
                SetDefaultAddress(AddressID, objAddress.UserName)
            End If

        End Sub

        Public Sub DeleteAddress(ByVal addressID As Integer)

            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Address_DeleteAddress"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)
            db.AddInParameter(dbCommand, "AddressID", DbType.Int32, addressID)

            db.ExecuteNonQuery(dbCommand)

        End Sub

        Public Sub SetDefaultAddress(ByVal addressID As Integer, ByVal userName As String)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Address_SetDefaultAddress"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)
            db.AddInParameter(dbCommand, "AddressID", DbType.Int32, addressID)
            db.AddInParameter(dbCommand, "UserName", DbType.String, userName)
            db.ExecuteNonQuery(dbCommand)

        End Sub

        Public Sub UpdateAddress(ByVal objAddress As AddressInfo)



            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Address_UpdateAddress"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "AddressID", DbType.Int32, CInt(objAddress.AddressID))
            '   db.AddInParameter(dbCommand, "UserName", DbType.String, objAddress.UserName)
            db.AddInParameter(dbCommand, "FirstName", DbType.String, objAddress.FirstName)
            db.AddInParameter(dbCommand, "LastName", DbType.String, objAddress.LastName)
            db.AddInParameter(dbCommand, "Address1", DbType.String, objAddress.Address1)
            db.AddInParameter(dbCommand, "Address2", DbType.String, objAddress.Address2)
            db.AddInParameter(dbCommand, "Area", DbType.String, objAddress.Area)
            db.AddInParameter(dbCommand, "AreaID", DbType.String, objAddress.AreaID)
            db.AddInParameter(dbCommand, "City", DbType.String, objAddress.City)
            db.AddInParameter(dbCommand, "Province", DbType.String, objAddress.Province)
            db.AddInParameter(dbCommand, "Zip", DbType.String, objAddress.Zip)
            db.AddInParameter(dbCommand, "Country", DbType.String, objAddress.Country)
            db.AddInParameter(dbCommand, "Phone", DbType.String, objAddress.Phone)
            db.AddInParameter(dbCommand, "MobilePhone", DbType.String, objAddress.MobilePhone)
            db.AddInParameter(dbCommand, "IsDefault", DbType.Boolean, objAddress.IsDefault)
            db.ExecuteNonQuery(dbCommand)

        End Sub
        Friend Function FillAddressInfo(ByVal reader As IDataReader) As AddressInfo

            Dim objAddressInfo As New AddressInfo
            objAddressInfo.AddressID = reader("AddressID").ToString
            objAddressInfo.UserName = reader("UserName").ToString
            objAddressInfo.Address1 = reader("Address1").ToString
            objAddressInfo.Address2 = reader("Address2").ToString
            objAddressInfo.AddressID = reader("AddressID").ToString
            objAddressInfo.Area = reader("Area").ToString
            objAddressInfo.AreaID = reader("AreaID").ToString
            objAddressInfo.City = reader("City").ToString
            objAddressInfo.Country = reader("Country").ToString
            objAddressInfo.FirstName = reader("FirstName").ToString
            objAddressInfo.LastName = reader("LastName").ToString
            objAddressInfo.MobilePhone = reader("MobilePhone").ToString
            objAddressInfo.Phone = reader("Phone").ToString
            objAddressInfo.Province = reader("Province").ToString
            objAddressInfo.Zip = reader("Zip").ToString
            objAddressInfo.IsDefault = reader("IsDefault").ToString

            Return objAddressInfo
        End Function

    End Class
End Namespace

