

Namespace NetShopForge.Library.Address

    <Serializable()> Public Class AddressInfo
        Private _AddressID As Integer
        Private _UserName As String
        Private _FirstName As String
        Private _LastName As String
        Private _Address1 As String
        Private _Address2 As String
        Private _City As String
        Private _Province As String
        Private _Zip As String
        Private _area As String
        Private _Country As String
        Private _Phone As String
        Private _MobilePhone As String
        Private _IsDefault As Boolean
        Private _regionID As Integer
        Private _areaID As String

        Public Sub New()
            _LastName = ""
            _Address2 = ""
            _areaID = ""
        End Sub

        Public ReadOnly Property FullAddress() As String
            Get
                Return Me.ToHtmlString()
            End Get
        End Property

        Public Property AddressID() As Integer
            Get
                Return _AddressID
            End Get
            Set(ByVal value As Integer)
                _AddressID = value
            End Set
        End Property
        Public Property UserName() As String
            Get
                Return _UserName
            End Get
            Set(ByVal value As String)
                _UserName = value
            End Set
        End Property

        Public Property FirstName() As String
            Get
                Return _FirstName
            End Get
            Set(ByVal value As String)
                _FirstName = value
            End Set
        End Property
        Public Property LastName() As String
            Get
                Return _LastName
            End Get
            Set(ByVal value As String)
                _LastName = value
            End Set
        End Property

        Public Property Address1() As String
            Get
                Return _Address1
            End Get
            Set(ByVal value As String)
                _Address1 = value
            End Set
        End Property
        Public Property Address2() As String
            Get
                Return _Address2
            End Get
            Set(ByVal value As String)
                _Address2 = value
            End Set
        End Property
        Public Property City() As String
            Get
                Return _City
            End Get
            Set(ByVal value As String)
                _City = value
            End Set
        End Property
        Public Property Province() As String
            Get
                Return _Province
            End Get
            Set(ByVal value As String)
                _Province = value
            End Set
        End Property

        Public Property Area() As String
            Get
                Return _area
            End Get
            Set(ByVal value As String)
                _area = value
            End Set
        End Property
        Public Property Zip() As String
            Get
                Return _Zip
            End Get
            Set(ByVal value As String)
                _Zip = value
            End Set
        End Property
        Public Property Country() As String
            Get
                Return _Country
            End Get
            Set(ByVal value As String)
                _Country = value
            End Set
        End Property
        Public Property Phone() As String
            Get
                Return _Phone
            End Get
            Set(ByVal value As String)
                _Phone = value
            End Set
        End Property
        Public Property MobilePhone() As String
            Get
                Return _MobilePhone
            End Get
            Set(ByVal value As String)
                _MobilePhone = value
            End Set
        End Property

        Public Property IsDefault() As Boolean
            Get
                Return _IsDefault
            End Get
            Set(ByVal value As Boolean)
                _IsDefault = value
            End Set
        End Property

        Public Property RegionID() As Integer
            Get
                Return _regionID
            End Get
            Set(ByVal value As Integer)
                _regionID = value
            End Set
        End Property

        Public Property AreaID() As String
            Get
                Return _areaID
            End Get
            Set(ByVal value As String)
                _areaID = value
            End Set
        End Property

        Public Overrides Function ToString() As String

            Dim sOut As String = FirstName & " " & LastName & Constants.vbCrLf & Address1 & Constants.vbCrLf
            If (Not String.IsNullOrEmpty(Address2)) Then
                sOut &= Address2 & Constants.vbCrLf
            End If
            sOut &= City & ", " & Province & "  " & Zip & " " & Country
            Return sOut
        End Function

        Public Function ToHtmlString() As String
            Dim sbOut As New System.Text.StringBuilder
            sbOut.Append("<table>")
            sbOut.Append(String.Format("<tr><td>:<b>{0} {1}</b></td></tr><tr><td>ַ:{2} </td></tr>", FirstName, LastName, Address1))
            If (Not String.IsNullOrEmpty(Address2)) Then
                sbOut.Append(String.Format("<tr><td>ַ2:{0}</td></tr>", Address2))
            End If
            sbOut.Append("<tr><td>:" & Zip & "</td></tr>")
            sbOut.Append(String.Format("<tr><td>:{0},{1},{2}</td></tr>", Province, City, Area))
            sbOut.Append("<tr><td>")
            If (Not String.IsNullOrEmpty(Phone)) Then
                sbOut.Append(String.Format("绰:{0}  ", Phone))
            End If
            If (Not String.IsNullOrEmpty(MobilePhone)) Then
                sbOut.Append(String.Format("ֻ:{0}", MobilePhone))
            End If
            sbOut.Append("</td></tr>")
            sbOut.Append("</table>")
            Return sbOut.ToString
        End Function
    End Class

End Namespace

