Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports System.Data.SqlClient
Imports System.Data.Common
Imports System.Data
Imports System.Collections.Generic
Imports System.Text
Imports NetShopForge.Common.Globals

Namespace NetShopForge.Library.Brand

    Public Class BrandController

        Public Function GetBrandList() As List(Of BrandInfo)
            Dim objMIList As New List(Of BrandInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Brand_GetBrandList")

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    objMIList.Add(FillBrandInfo(reader))
                End While
                Return objMIList
            End Using

        End Function
        Public Function GetBrand(ByVal BrandID As Integer) As BrandInfo
            Dim objMI As New List(Of BrandInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Brand_GetBrand")
            db.AddInParameter(dbCommand, "@BrandID", DbType.Int32, BrandID)

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillBrandInfo(reader)
                End While
                Return Nothing
            End Using

        End Function

        Public Function AddBrand(ByVal BrandInfo As BrandInfo) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Brand_AddBrand"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            Dim BrandID As Integer = GetKeys("BrandID")

            db.AddInParameter(dbCommand, "@BrandID", DbType.String, BrandID.ToString)
            db.AddInParameter(dbCommand, "@BrandName", DbType.String, BrandInfo.Brand)
            db.AddInParameter(dbCommand, "@Manufacturer", DbType.String, BrandInfo.Manufacturer)
            db.AddInParameter(dbCommand, "@Description", DbType.String, BrandInfo.Description)
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, BrandInfo.ItemOrder)
            db.AddInParameter(dbCommand, "@LogoPath", DbType.String, BrandInfo.LogoPath)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, BrandInfo.IsValid)
            db.AddInParameter(dbCommand, "@URL", DbType.String, BrandInfo.URL)
            db.ExecuteNonQuery(dbCommand)
            Return BrandID

        End Function

        Public Sub DeleteBrand(ByVal BrandID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Brand_DeleteBrand"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@BrandID", DbType.Int32, BrandID)
            db.ExecuteNonQuery(dbCommand)

        End Sub

        Public Sub UpdateBrandQuick(ByVal BrandID As Integer, ByVal itemOrder As Integer, ByVal isValid As Boolean)

            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Brand_UpdateBrandQuick"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@BrandID", DbType.Int32, BrandID)
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, itemOrder)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, isValid)

            db.ExecuteNonQuery(dbCommand)

        End Sub

        Public Sub UpdateBrand(ByVal BrandInfo As BrandInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Brand_UpdateBrand"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@BrandID", DbType.String, BrandInfo.BrandID)
            db.AddInParameter(dbCommand, "@BrandName", DbType.String, BrandInfo.Brand)
            db.AddInParameter(dbCommand, "@Manufacturer", DbType.String, BrandInfo.Manufacturer)
            db.AddInParameter(dbCommand, "@Description", DbType.String, BrandInfo.Description)
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, BrandInfo.ItemOrder)
            db.AddInParameter(dbCommand, "@LogoPath", DbType.String, BrandInfo.LogoPath)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, BrandInfo.IsValid)
            db.AddInParameter(dbCommand, "@URL", DbType.String, BrandInfo.URL)
            db.ExecuteNonQuery(dbCommand)
        End Sub


#Region "---Private Method---"

        Private Function FillBrandInfo(ByVal dr As IDataReader) As BrandInfo

            Dim objMI As New BrandInfo

            objMI.Brand = dr.Item("Brand")
            objMI.Description = dr.Item("Description")
            objMI.IsValid = dr.Item("IsValid")
            objMI.ItemOrder = dr.Item("ItemOrder")
            objMI.LogoPath = dr.Item("LogoPath")
            objMI.BrandID = dr.Item("BrandID")
            objMI.Manufacturer = dr.Item("Manufacturer")
            objMI.URL = dr.Item("URL")

            Return objMI

        End Function

#End Region


    End Class

End Namespace

