Imports Microsoft.VisualBasic
Imports System.Data
Imports System.Data.Common
Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports NetShopForge.Common.Globals


Imports System.Text


Namespace NetShopForge.Library.Category

    Public Class CategoryController

        Private Shared _Instance As CategoryController

#Region "Public Method"
        Public Function AddCategory(ByVal categoryInfo As CategoryInfo) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Category_AddCategory"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            Dim CategoryID As Integer = GetKeys("CategoryID")

            db.AddInParameter(dbCommand, "@CategoryID", DbType.String, CategoryID.ToString)
            db.AddInParameter(dbCommand, "@CategoryName", DbType.String, categoryInfo.CategoryName)
            db.AddInParameter(dbCommand, "@CategoryFatherID", DbType.Int32, categoryInfo.CategoryFatherID)
            db.AddInParameter(dbCommand, "@Description", DbType.String, categoryInfo.Description)
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, categoryInfo.ItemOrder)
            db.AddInParameter(dbCommand, "@ImagePath", DbType.String, categoryInfo.ImagePath)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, categoryInfo.IsValid)
            db.AddInParameter(dbCommand, "@MetaDescription", DbType.String, categoryInfo.MetaDescription)
            db.AddInParameter(dbCommand, "@MetaKeywords", DbType.String, categoryInfo.MetaKeywords)
            db.ExecuteNonQuery(dbCommand)
            Return CategoryID

        End Function
        Public Sub DeleteCategory(ByVal CategoryID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Category_DeleteCategory"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@CategoryID", DbType.String, CategoryID.ToString)
            db.ExecuteNonQuery(dbCommand)

        End Sub
        Public Sub UpdateCategoryQuick(ByVal categoryID As Integer, ByVal itemOrder As Integer, ByVal isValid As Boolean)

            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Category_UpdateCategoryQuick"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@CategoryID", DbType.String, categoryID.ToString)
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, itemOrder)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, isValid)

            db.ExecuteNonQuery(dbCommand)

        End Sub
        Public Sub UpdateCategory(ByVal categoryInfo As CategoryInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Category_UpdateCategory"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@CategoryID", DbType.String, categoryInfo.CategoryID)
            db.AddInParameter(dbCommand, "@CategoryName", DbType.String, categoryInfo.CategoryName)
            db.AddInParameter(dbCommand, "@CategoryFatherID", DbType.Int32, categoryInfo.CategoryFatherID)
            db.AddInParameter(dbCommand, "@Description", DbType.String, categoryInfo.Description)
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, categoryInfo.ItemOrder)
            db.AddInParameter(dbCommand, "@ImagePath", DbType.String, categoryInfo.ImagePath)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, categoryInfo.IsValid)
            db.AddInParameter(dbCommand, "@MetaDescription", DbType.String, categoryInfo.MetaDescription)
            db.AddInParameter(dbCommand, "@MetaKeywords", DbType.String, categoryInfo.MetaKeywords)
            db.ExecuteNonQuery(dbCommand)
        End Sub


        Public Function IsValidCategoryFatherID(ByVal fatherCategoryID As Integer, ByVal categoryID As Integer) As Boolean
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Category_GetCategory"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@CategoryID", DbType.String, categoryID)
            Using r As IDataReader = db.ExecuteReader(dbCommand)
                While r.Read
                    If CInt(r("CategoryID")) = fatherCategoryID Then Return False
                End While
            End Using
            Return True
        End Function
#End Region

#Region "Shared Method"
        Public Shared ReadOnly Property Instance() As CategoryController
            Get
                If IsNothing(_Instance) Then
                    _Instance = New CategoryController
                End If
                Return _Instance
            End Get
        End Property

        ''' <summary>
        ''' get all category store in dataset
        ''' </summary>
        ''' <returns>all category</returns>
        ''' <remarks></remarks>
        Public Shared Function GetCategoryList() As DataSet
            Return GetCategoryList(-2)
        End Function

        Public Shared Function GetCategoryList(ByVal categoryFatherID As Integer) As DataSet
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Category_GetCategoryList"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            ' Retrieve products from the specified category.
            db.AddInParameter(dbCommand, "CategoryFatherID", DbType.Int32, categoryFatherID)

            ' DataSet that will hold the returned results		
            Dim productsDataSet As DataSet = Nothing

            productsDataSet = db.ExecuteDataSet(dbCommand)

            ' Note: connection was closed by ExecuteDataSet method call 

            Return productsDataSet
        End Function

        Public Shared Function GetCategoryChildList(ByVal categoryID As Integer) As String
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Category_GetCategoryChildList")
            db.AddInParameter(dbCommand, "@categoryID", DbType.Int32, categoryID)
            Dim sb As New StringBuilder
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    sb.Append(String.Format(",{0}", reader.Item("CategoryID").ToString))
                End While
            End Using
            If sb.Length = 0 Then Return ""
            Return sb.ToString.Substring(1)

        End Function

        Public Shared Function GetCategoryDictionary() As Generic.Dictionary(Of Integer, String)
            Dim cDictionary As New Dictionary(Of Integer, String)
            GetCategoryDictionary(cDictionary, -1, "")
            Return cDictionary
        End Function

        Public Shared Function GetCategory(ByVal categoryID As Integer) As CategoryInfo

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Category_GetCategory")

            db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, categoryID)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillCategoryInfo(reader)
                End While
                Return Nothing
            End Using

        End Function
        Public Shared Function GetCategoryFullName(ByVal categoryID As Integer) As String
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Category_GetCategoryFatherList")
            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, categoryID)
            'Dim FeatureList As New List(Of ProductFeatureInfo)
            Dim s As New StringBuilder
            'Dim link As String = "&gt;<a href=CatDefault.aspx?CatID={0}><strong>{1}</strong></a>"
            Dim link As String = "> {0}"

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    s.Append(String.Format(link, reader.Item("CategoryName")))
                End While
            End Using
            Return s.ToString.Substring(1)
        End Function


        Public Shared Function GetCategoryMapPath(ByVal categoryID As Integer, ByVal renderCurrentNodeAsLink As Boolean) As String
            Dim s As New StringBuilder
            s.Append(" <a href=Categories.aspx?catID=-1></a>")
            If categoryID <> -1 Then
                Dim db As Database = DatabaseFactory.CreateDatabase
                Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Category_GetCategoryFatherList")
                ' Add paramters
                ' Input parameters can specify the input value
                db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, categoryID)

                'Dim link As String = "&gt;<a href=CatDefault.aspx?CatID={0}><strong>{1}</strong></a>"
                Dim link As String = " <a href=Categories.aspx?catID={0}>{1}</a>"

                Using reader As IDataReader = db.ExecuteReader(dbCommand)
                    While reader.Read
                        Dim cID As String = reader.Item("CategoryID")
                        Dim cName As String = reader.Item("CategoryName")
                        If CInt(cID) = categoryID AndAlso Not renderCurrentNodeAsLink Then
                            s.Append("&nbsp" & cName)
                        Else
                            s.Append(String.Format(link, cID, cName))
                        End If

                    End While
                End Using
            End If
            'Return s.ToString.Substring(4)
            Return s.ToString

        End Function


        Public Shared Function GetNProductbyCategory(ByVal categoryId As Integer) As Integer

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Category_GetNProductbyCategory")

            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, categoryId)
            Return CInt(db.ExecuteScalar(dbCommand))
        End Function

        Public Shared Function GetNSubCatbyCategory(ByVal categoryFatherID As Integer) As Integer
            Using dt As DataTable = GetSubCategoryTable(categoryFatherID)
                If Not IsNothing(dt) Then
                    Return dt.Rows.Count
                Else
                    Return 0
                End If
            End Using
        End Function

        Public Shared Function GetTreeTable() As DataTable

            Using dt As DataTable = System.Web.HttpContext.Current.Cache("CategoryTable")
                If IsNothing(dt) Then
                    Using t As DataTable = CategoryController.GetCategoryList().Tables(0)
                        System.Web.HttpContext.Current.Cache.Insert("CategoryTable", t)
                        Return t
                    End Using
                End If
                Return dt
            End Using

        End Function

        Public Shared Function GetCategoryName(ByVal categoryID As Integer) As String
            Using dt As DataTable = GetTreeTable()

                Dim foundRows() As DataRow
                foundRows = dt.Select(String.Format("[CategoryID]={0}", categoryID.ToString))
                If Not IsNothing(foundRows) Then
                    Return CStr(foundRows(0).Item("CategoryName"))
                Else
                    Return ""
                End If

            End Using

        End Function

        Public Shared Function GetCategoryFatherID(ByVal categoryID As Integer) As Integer
            If categoryID = -1 Then Return -1
            Using dt As DataTable = GetTreeTable()

                Dim foundRows() As DataRow
                foundRows = dt.Select(String.Format("[CategoryID]={0}", categoryID.ToString))
                If Not IsNothing(foundRows) Then
                    Return CInt(foundRows(0).Item("CategoryFatherID"))
                Else
                    Return ""
                End If

            End Using
        End Function

        Public Shared Function GetSubCategoryTable(ByVal categoryFatherID As Integer) As DataTable
            Using dt As DataTable = GetTreeTable()

                Dim foundRows() As DataRow
                foundRows = dt.Select(String.Format("[CategoryFatherID]={0}", categoryFatherID.ToString))

                Using dtt As DataTable = dt.Clone
                    For i As Integer = 0 To foundRows.Length - 1
                        dtt.ImportRow(foundRows(i))
                    Next
                    Return dtt
                End Using

            End Using
        End Function

#End Region

#Region "---Private Shared Method----"

        Private Shared Sub GetCategoryDictionary(ByRef cDictionary As Dictionary(Of Integer, String), ByVal categoryFatherID As Integer, ByVal categoryFatherName As String)
            Dim db As Database = DatabaseFactory.CreateDatabase()
            Dim sqlCommand As String = "nsf_Category_GetCategoryList"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)
            ' Retrieve products from the specified category.
            db.AddInParameter(dbCommand, "CategoryFatherID", DbType.Int32, categoryFatherID)
            ' DataSet that will hold the returned results		
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read

                    Dim categoryName As String = ""

                    If categoryFatherID <> -1 Then
                        categoryName = categoryName + "/" & reader.Item("CategoryName")
                    Else
                        categoryName = reader.Item("CategoryName")
                    End If

                    Dim categoryID As Integer = CInt(reader.Item("categoryID"))
                    cDictionary.Add(categoryID, categoryName)
                    GetCategoryDictionary(cDictionary, categoryID, categoryName)

                End While
            End Using

        End Sub

        Private Shared Function FillCategoryInfo(ByVal dr As IDataReader) As CategoryInfo

            Dim objCI As New CategoryInfo

            objCI.CategoryID = dr.Item("CategoryID")
            objCI.CategoryFatherID = dr.Item("CategoryFatherID")
            objCI.CategoryName = dr.Item("CategoryName")
            objCI.ImagePath = dr.Item("ImagePath")
            objCI.IsValid = CBool(dr.Item("IsValid"))
            objCI.ItemOrder = CInt(dr.Item("ItemOrder"))
            objCI.MetaDescription = dr.Item("MetaDescription")
            objCI.MetaKeywords = dr.Item("MetaKeywords")
            objCI.Description = dr.Item("Description")
            Return objCI

        End Function

#End Region


    End Class
End Namespace