Imports System.Data
Imports System.Web.UI.WebControls
Namespace NetShopForge.Library.Category
    Public Class CategoryTree

        Private Shared _Instance As CategoryTree
        Public Shared ReadOnly Property Instance() As CategoryTree
            Get
                If IsNothing(_Instance) Then
                    _Instance = New CategoryTree
                End If
                Return _Instance
            End Get
        End Property

        Private Sub BindData(ByRef listControl As System.Web.UI.WebControls.ListControl, ByVal dt As DataTable, ByVal categoryFatherID As String, ByVal categoryFatherName As String, ByVal IsOnlyTop As Boolean, ByVal PathSeparator As String)
            Using dv As DataView = New DataView(dt)
                dv.RowFilter = "CategoryFatherID = " & categoryFatherID.ToString()

                For Each drv As DataRowView In dv

                    Dim categoryName As String = categoryFatherName
                    Dim categoryID As String = drv("CategoryID").ToString()
                    If categoryFatherID <> -1 Then
                        categoryName = String.Format("{0}{1}{2}", categoryName, PathSeparator, drv.Item("CategoryName"))
                    Else
                        categoryName = drv.Item("CategoryName")
                    End If
                  
                    listControl.Items.Add(New ListItem(categoryName, CInt(categoryID)))
                    If Not IsOnlyTop Then
                        BindData(listControl, dt, categoryID, categoryName, False, PathSeparator)
                    End If
                Next
            End Using

        End Sub

        Public Sub SetCategoryList(ByRef listControl As System.Web.UI.WebControls.ListControl)
            SetCategoryList(listControl, "")
        End Sub
        Public Sub SetCategoryList(ByRef listControl As System.Web.UI.WebControls.ListControl, ByVal firstText As String)
            SetCategoryList(listControl, firstText, False)
        End Sub

        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="listControl"> and listControl from System.Web.UI.WebControls.ListControl</param>
        ''' <param name="firstText">the list's first caption ,value=-1 </param>
        ''' <param name="IsOnlyTop"></param>
        ''' <remarks></remarks>
        Public Sub SetCategoryList(ByRef listControl As System.Web.UI.WebControls.ListControl, ByVal firstText As String, ByVal IsOnlyTop As Boolean)
            Using t As DataTable = CategoryController.GetTreeTable

                BindData(listControl, t, -1, "", IsOnlyTop, " > ")
                If firstText.Length > 0 Then
                    listControl.Items.Insert(0, New ListItem(firstText, -1))
                End If
            End Using
        End Sub

    End Class
End Namespace

