Imports Microsoft.VisualBasic
Imports System.Data
Imports System.Data.Common
Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports NetShopForge.Common.Globals
Namespace NetShopForge.Library.Coupon

    Public Class CouponController



#Region "---Public Method----"

        Public Function AddCoupon(ByVal CouponInfo As CouponInfo) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Coupon_AddCoupon"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            Dim CouponID As Integer = GetKeys("CouponID")

            db.AddInParameter(dbCommand, "@CouponID", DbType.Int32, CouponID)
            db.AddInParameter(dbCommand, "@Amount", DbType.Decimal, CouponInfo.Amount)
            db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, CouponInfo.CategoryID)
            db.AddInParameter(dbCommand, "@Coupon", DbType.String, CouponInfo.Coupon)
            db.AddInParameter(dbCommand, "@CouponID", DbType.Int32, CouponInfo.CouponID)
            db.AddInParameter(dbCommand, "@CouponType", DbType.Int32, CouponInfo.CouponType)
            db.AddInParameter(dbCommand, "@Discount", DbType.Decimal, CouponInfo.Discount)
            db.AddInParameter(dbCommand, "@ExpireDate", DbType.Date, CouponInfo.ExpireDate)
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, CouponInfo.ProductID)
            db.AddInParameter(dbCommand, "@StartDate", DbType.Date, CouponInfo.StartDate)
            db.AddInParameter(dbCommand, "@Status", DbType.Int32, CouponInfo.Status)
            db.AddInParameter(dbCommand, "@Times", DbType.Int32, CouponInfo.Times)
            db.AddInParameter(dbCommand, "@TimesUsed", DbType.Int32, CouponInfo.TimesUsed)
            db.AddInParameter(dbCommand, "@WithSubCat", DbType.Boolean, CouponInfo.WithSubCat)
            db.ExecuteNonQuery(dbCommand)
            Return CouponID

        End Function

        Public Sub DeleteCoupon(ByVal CouponID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Coupon_DeleteCoupon"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@CouponID", DbType.Int32, CouponID.ToString)
            db.ExecuteNonQuery(dbCommand)

        End Sub

        Public Sub UpdateCoupon(ByVal CouponInfo As CouponInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Coupon_UpdateCoupon"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@CouponID", DbType.Int32, CouponInfo.CouponID)
            db.AddInParameter(dbCommand, "@CouponName", DbType.Int32, CouponInfo.Status)


            db.ExecuteNonQuery(dbCommand)
        End Sub

        Public Function GetCoupon(ByVal CouponID As Integer) As List(Of CouponInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Coupon_GetCouponList")

            Dim cList As New List(Of CouponInfo)

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    cList.Add(FillCouponInfo(reader))
                End While
                Return Nothing
            End Using

        End Function

#End Region

#Region "---Private Method----"

        Private Function FillCouponInfo(ByVal dr As IDataReader) As CouponInfo

            Dim objCoupon As New CouponInfo

            objCoupon.CouponID = dr.Item("CouponID")
            objCoupon.Amount = dr.Item("Amount")
            objCoupon.CategoryID = dr.Item("CategoryID")
            objCoupon.Coupon = dr.Item("Coupon")
            objCoupon.CouponID = dr.Item("CouponID")
            objCoupon.CouponType = dr.Item("CouponType")
            objCoupon.Discount = dr.Item("Discount")
            objCoupon.ExpireDate = dr.Item("ExpireDate")
            objCoupon.ProductID = dr.Item("CouponFaProductIDtherID")
            objCoupon.StartDate = dr.Item("StartDate")
            objCoupon.Status = dr.Item("Status")
            objCoupon.Times = dr.Item("Times")
            objCoupon.TimesUsed = dr.Item("TimesUsed")
            objCoupon.WithSubCat = dr.Item("WithSubCat")



            Return objCoupon

        End Function

#End Region

    End Class


End Namespace

