Imports System
Imports System.Configuration
Imports System.Data
Imports System.Data.Common
Imports System.Threading
Imports System.Web
Imports System.Collections.Generic
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports Microsoft.Practices.EnterpriseLibrary.Data


Namespace NetShopForge.Library.Currency


    Public Class CurrencyController
        Private Shared _Instance As CurrencyController
        Public Shared ReadOnly Property Instance() As CurrencyController
            Get
                If IsNothing(_Instance) Then
                    _Instance = New CurrencyController
                End If
                Return _Instance
            End Get
        End Property
        Public Function GetCurrencyList() As List(Of CurrencyInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Currency_GetCurrencyList")

            Dim listCurrency As New List(Of CurrencyInfo)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    listCurrency.Add(FillCurrencyInfo(reader))
                End While
                Return listCurrency
            End Using

        End Function

        Public Function GetCurrencyInfo(ByVal CurrencyID As Integer) As CurrencyInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbcommand As DbCommand = db.GetStoredProcCommand("nsf_Currency_GetCurrency")
            db.AddInParameter(dbcommand, "@CurrencyID", DbType.Int32, CurrencyID)
            Using reader As IDataReader = db.ExecuteReader(dbcommand)
                While reader.Read
                    Return FillCurrencyInfo(reader)
                End While
            End Using
            Return Nothing
        End Function

        Public Function AddCurrency(ByVal Currency As CurrencyInfo) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Currency_AddCurrency"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            Dim CurrencyID As Integer = NetShopForge.Common.GetKeys("CurrencyID")
            db.AddInParameter(dbCommand, "CurrencyID", DbType.Int32, CurrencyID)
            db.AddInParameter(dbCommand, "Description", DbType.String, Currency.Description)

            db.AddInParameter(dbCommand, "Code", DbType.String, Currency.Code)
   

            db.ExecuteNonQuery(dbCommand)
            Return CurrencyID
        End Function

        Public Sub UpdateCurrency(ByVal Currency As CurrencyInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim sqlCommand As String = "nsf_Currency_UpdateCurrency"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)
            db.AddInParameter(dbCommand, "CurrencyID", DbType.Int32, Currency.CurrencyID)
            db.AddInParameter(dbCommand, "Code", DbType.String, Currency.Code)
            db.AddInParameter(dbCommand, "Description", DbType.String, Currency.Description)
            db.ExecuteNonQuery(dbCommand)

        End Sub

        Public Sub DeleteCurrency(ByVal CurrencyID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim sqlCommand As String = "nsf_Currency_DeleteCurrency"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "CurrencyID", DbType.Int32, CurrencyID)
            db.ExecuteNonQuery(dbCommand)
        End Sub

        Friend Shared Function FillCurrencyInfo(ByVal reader As IDataReader) As CurrencyInfo

            Dim Currency As New CurrencyInfo
            Currency.CurrencyID = reader("CurrencyID")
            Currency.Code = reader("Code").ToString

            Currency.Description = reader("Description").ToString
            Return Currency
        End Function
    End Class
End Namespace
