
Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Data.Sql
Imports NetShopForge.Common.Utilities
Imports System.Data.SqlClient
Imports System.Data.Common
Imports System.Data

Namespace NetShopForge.Library.Feature
    Public Class FeatureController

#Region "---Public Method---"
#Region "---Feature Group---"

        Public Function GetFeatureGroupList() As List(Of FeatureGroupInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Feature_GetFeatureGroupList")

            Dim FeatureGroupList As New List(Of FeatureGroupInfo)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    FeatureGroupList.Add(FillFeatureGroupInfo(reader))
                End While
                Return FeatureGroupList
            End Using

        End Function

        Public Function GetFeatureGroup(ByVal featureGroupID As Integer) As FeatureGroupInfo

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Feature_GetFeatureGroup")

            db.AddInParameter(dbCommand, "@FeatureGroupID", DbType.Int32, featureGroupID)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillFeatureGroupInfo(reader)
                End While
                Return Nothing
            End Using

        End Function

        Public Function GetFeatureGroupName(ByVal featureGroupID As Integer) As String
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_GetProductFeatureGroup")

            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@FeatureGroupID", DbType.Int32, featureGroupID)


            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return reader.Item("FeatureGroupName")
                End While
                Return ""
            End Using

        End Function

        Public Function AddFeatureGroup(ByVal produtFeaturGroupInfo As FeatureGroupInfo) As Integer
            ' Create the Database object, using the default database service. The
            ' default database service is determined through configuration.

            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Feature_AddFeatureGroup"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            Dim ID As Integer = "" '"" 'GetKeys("FeatureGroupID", "")

            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@FeatureGroupID", DbType.Int32, ID)
            db.AddInParameter(dbCommand, "@FeatureGroupName", DbType.String, produtFeaturGroupInfo.FeatureGroupName.Replace("'", "''"))
            db.AddInParameter(dbCommand, "@Description", DbType.String, produtFeaturGroupInfo.Description.Replace("'", "''"))
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, produtFeaturGroupInfo.ItemOrder)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, produtFeaturGroupInfo.IsValid)

            db.ExecuteNonQuery(dbCommand)

            Return ID

        End Function

        Public Sub UpdataFeatureGroup(ByVal produtFeaturGroupInfo As FeatureGroupInfo, Optional ByVal IsQuick As Boolean = False)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Feature_UpdateFeatureGroup"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@FeatureGroupID", DbType.Int32, produtFeaturGroupInfo.FeatureGroupID)
            db.AddInParameter(dbCommand, "@FeatureGroupName", DbType.String, produtFeaturGroupInfo.FeatureGroupName.Replace("'", "''"))
            db.AddInParameter(dbCommand, "@Description", DbType.String, produtFeaturGroupInfo.Description.Replace("'", "''"))
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, produtFeaturGroupInfo.ItemOrder)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, produtFeaturGroupInfo.IsValid)

            db.AddInParameter(dbCommand, "@IsQuick", DbType.Boolean, IsQuick)
            ' Output parameters specify the size of the return data

            db.ExecuteNonQuery(dbCommand)

        End Sub

#End Region

#Region "---Feature Item---"

        Public Function GetFeatureItemList(ByVal featureGroupID As Integer) As List(Of FeatureItemInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Feature_GetFeatureItemList")
            db.AddInParameter(dbCommand, "@FeatureGroupID", DbType.Int32, featureGroupID)
            db.AddInParameter(dbCommand, "@IsCount", DbType.Boolean, False)

            Dim FeatureItemList As New List(Of FeatureItemInfo)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    FeatureItemList.Add(FillFeatureItemInfo(reader))
                End While
                Return FeatureItemList
            End Using



        End Function
        Public Function GetProductFeatureItemQuantity(ByVal featureGroupID As Integer) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Feature_GetFeatureItemList")
            db.AddInParameter(dbCommand, "@FeatureGroupID", DbType.Int32, featureGroupID)
            db.AddInParameter(dbCommand, "@IsCount", DbType.Boolean, True)

            Return CInt(db.ExecuteScalar(dbCommand))


        End Function
        Public Function GetProductFeatureItem(ByVal featureID As Integer) As FeatureItemInfo

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Feature_GetFeatureItem")

            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@FeatureID", DbType.Int32, featureID)


            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillFeatureItemInfo(reader)
                End While
                Return Nothing
            End Using

        End Function

        Public Function AddFeaturItem(ByVal featureItem As FeatureItemInfo) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Feature_AddFeatureItem")
            Dim ID As Integer = "" 'GetKeys("FeatureID", "")

            db.AddInParameter(dbCommand, "@FeatureID", DbType.Int32, ID)
            db.AddInParameter(dbCommand, "@FeatureGroupID", DbType.Int32, featureItem.FeatureGroupID)
            db.AddInParameter(dbCommand, "@FeatureName ", DbType.String, featureItem.FeatureName)
            db.AddInParameter(dbCommand, "@DataType", DbType.Int32, featureItem.DataType)
            db.AddInParameter(dbCommand, "@Description", DbType.String, featureItem.Description)
            db.AddInParameter(dbCommand, "@SelectType", DbType.Int32, featureItem.SelectType)
            db.AddInParameter(dbCommand, "@IsSearch", DbType.Boolean, featureItem.IsSearch)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, featureItem.IsValid)
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, featureItem.ItemOrder)


            db.ExecuteNonQuery(dbCommand)

            Return ID


        End Function
        Public Sub UpdataFeatureItem(ByVal featureItem As FeatureItemInfo, Optional ByVal IsQuick As Boolean = False)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Feature_UpdateFeatureItem"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@FeatureID", DbType.Int32, featureItem.FeatureID)
            db.AddInParameter(dbCommand, "@FeatureName", DbType.String, featureItem.FeatureName.Replace("'", "''"))
            db.AddInParameter(dbCommand, "@DataType", DbType.Int32, featureItem.DataType)
            db.AddInParameter(dbCommand, "@Description", DbType.String, featureItem.Description.Replace("'", "''"))
            db.AddInParameter(dbCommand, "@SelectType", DbType.Int32, featureItem.SelectType)
            db.AddInParameter(dbCommand, "@IsSearch", DbType.Boolean, featureItem.IsSearch)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, featureItem.IsValid)
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, featureItem.ItemOrder)
            db.AddInParameter(dbCommand, "@IsQuick", DbType.Boolean, IsQuick)
            ' Output parameters specify the size of the return data

            db.ExecuteNonQuery(dbCommand)

        End Sub

#End Region


#Region "---Feature Select---"

        Public Function GetProductSelectList(ByVal featureID As Integer) As List(Of FeatureSelectInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Feature_GetFeatureSelectList")

            db.AddInParameter(dbCommand, "@FeatureID", DbType.Int32, featureID)

            Dim FeatureSelectList As New List(Of FeatureSelectInfo)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    FeatureSelectList.Add(FillFeatureSelectInfo(reader))
                End While
                Return FeatureSelectList
            End Using


        End Function
        Public Sub AddProductFeaturSelect(ByVal featureID As Integer, ByVal featureValue As String, ByVal isValid As Boolean)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Feature_AddFeatureSelect")
            Dim ID As Integer = "" 'GetKeys("FeatureSelectID", "")

            db.AddInParameter(dbCommand, "@FeatureSelectID", DbType.Int32, ID)
            db.AddInParameter(dbCommand, "@FeatureID", DbType.Int32, featureID)
            db.AddInParameter(dbCommand, "@FeatureValue ", DbType.String, featureValue.Replace("'", "''"))
            db.AddInParameter(dbCommand, "@IsValid ", DbType.Boolean, isValid)

            db.ExecuteNonQuery(dbCommand)

        End Sub
        Public Sub UpdataProductFeatureSelect(ByVal featuerSelectID As Integer, ByVal featureValue As String, ByVal isValid As Boolean)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Feature_UpdateFeatureSelect"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@FeatureSelectID", DbType.Int32, featuerSelectID)
            db.AddInParameter(dbCommand, "@FeatureValue", DbType.String, featureValue.Replace("'", "''"))
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, isValid)

            db.ExecuteNonQuery(dbCommand)

        End Sub
#End Region

#End Region

#Region "---Private Method---"


        Private Function FillFeatureItemInfo(ByVal dr As IDataReader) As FeatureItemInfo

            Dim objPFI As New FeatureItemInfo

            objPFI.FeatureID = dr.Item("FeatureID")
            objPFI.FeatureGroupID = dr.Item("FeatureGroupID")
            objPFI.FeatureName = dr.Item("FeatureName")
            objPFI.DataType = dr.Item("DataType")
            objPFI.Description = dr.Item("Description")
            objPFI.SelectType = dr.Item("SelectType")
            objPFI.IsSearch = dr.Item("IsSearch")
            objPFI.IsValid = dr.Item("IsValid")
            objPFI.ItemOrder = dr.Item("ItemOrder")

            Return objPFI

        End Function

        Private Function FillFeatureGroupInfo(ByVal dr As IDataReader) As FeatureGroupInfo

            Dim objPFG As New FeatureGroupInfo

            objPFG.Description = dr.Item("Description")
            objPFG.FeatureGroupID = dr.Item("FeatureGroupID")
            objPFG.FeatureGroupName = dr.Item("FeatureGroupName")
            objPFG.IsValid = dr.Item("IsValid")
            objPFG.ItemOrder = dr.Item("ItemOrder")

            Return objPFG

        End Function


        Private Function FillFeatureSelectInfo(ByVal dr As IDataReader) As FeatureSelectInfo

            Dim objPSI As New FeatureSelectInfo

            objPSI.FeatureSelectID = dr.Item("FeatureSelectID")
            objPSI.FeatureID = dr.Item("FeatureID")
            objPSI.FeatureValue = dr.Item("FeatureValue")
            objPSI.IsValid = dr.Item("IsValid")

            Return objPSI

        End Function

#End Region


    End Class
End Namespace