
Imports System.Web

Namespace NetShopForge.Services.Mail

    Public Enum MailFormat
        Text
        Html
    End Enum

    Public Enum MailPriority
        Normal
        Low
        High
    End Enum


    Public Class Mail

        ''' -----------------------------------------------------------------------------
        ''' <summary>
        ''' <summary>Send a simple email.</summary>
        ''' </summary>
        ''' <param name="MailFrom"></param>
        ''' <param name="MailTo"></param>
        ''' <param name="Bcc"></param>
        ''' <param name="Subject"></param>
        ''' <param name="Body"></param>
        ''' <param name="Attachment"></param>
        ''' <param name="BodyType"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        ''' <history>
        '''     [cnurse]        09/29/2005  Moved to Mail class
        ''' </history>
        ''' -----------------------------------------------------------------------------
        Public Shared Function SendMail(ByVal MailFrom As String, ByVal MailTo As String, ByVal Bcc As String, ByVal Subject As String, ByVal Body As String, ByVal Attachment As String, ByVal BodyType As String) As String



            ' here we check if we want to format the email as html or plain text.
            Dim objBodyFormat As MailFormat
            If BodyType <> "" Then
                Select Case LCase(BodyType)
                    Case "html"
                        objBodyFormat = MailFormat.Html
                    Case "text"
                        objBodyFormat = MailFormat.Text
                End Select
            End If

            Return SendMail(MailFrom, MailTo, "", Bcc, MailPriority.Normal, _
                Subject, objBodyFormat, System.Text.Encoding.UTF8, Body, Attachment)

        End Function

        ''' -----------------------------------------------------------------------------
        ''' <summary>Send a simple email.</summary>
        ''' <param name="MailFrom"></param>
        ''' <param name="MailTo"></param>
        ''' <param name="Cc"></param>
        ''' <param name="Bcc"></param>
        ''' <param name="Priority"></param>
        ''' <param name="Subject"></param>
        ''' <param name="BodyFormat"></param>
        ''' <param name="BodyEncoding"></param>
        ''' <param name="Body"></param>
        ''' <param name="Attachment"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        ''' <history>
        ''' 	[Nik Kalyani]	10/15/2004	Replaced brackets in member names
        '''     [cnurse]        09/29/2005  Moved to Mail class
        ''' </history>
        ''' -----------------------------------------------------------------------------
        Public Shared Function SendMail(ByVal MailFrom As String, ByVal MailTo As String, _
            ByVal Cc As String, ByVal Bcc As String, ByVal Priority As MailPriority, _
            ByVal Subject As String, ByVal BodyFormat As MailFormat, _
            ByVal BodyEncoding As System.Text.Encoding, ByVal Body As String, _
            ByVal Attachment As String) As String

            Dim objMail As New System.Net.Mail.MailMessage(MailFrom, MailTo)
            If Cc <> "" Then
                objMail.CC.Add(Cc)
            End If
            If Bcc <> "" Then
                objMail.Bcc.Add(Bcc)
            End If
            objMail.Priority = CType(Priority, Net.Mail.MailPriority)
            objMail.IsBodyHtml = CBool(IIf(BodyFormat = MailFormat.Html, True, False))

            If Attachment <> "" Then
                objMail.Attachments.Add(New Net.Mail.Attachment(Attachment))
            End If

            ' message
            objMail.Subject = Subject
            objMail.BodyEncoding = BodyEncoding
            objMail.Body = Body

            ' external SMTP server
            Dim smtpClient As New Net.Mail.SmtpClient()

            Try
                smtpClient.Send(objMail)
                SendMail = ""
            Catch objException As Exception
                ' mail configuration problem
                SendMail = objException.Message
            End Try

        End Function


    End Class

End Namespace

