
Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports System.Data.SqlClient
Imports System.Data.Common
Imports System.Data
Imports System.Collections.Generic
Imports System.Text
Imports NetShopForge.Common.Globals

Namespace NetShopForge.Library.News

    Public Class NewsController

#Region "Private Member"
        Private Shared _Instance As NewsController
#End Region
#Region "Shared Method"
        Public Shared ReadOnly Property Instance() As NewsController
            Get
                If IsNothing(_Instance) Then
                    _Instance = New NewsController
                End If
                Return _Instance
            End Get
        End Property
#End Region


#Region "---Private Method---"
        Private Function FillNewsCategoryInfo(ByVal dr As IDataReader) As NewsCategoryInfo

            Dim objNC As New NewsCategoryInfo

            objNC.Name = dr.Item("Name")
            objNC.Description = dr.Item("Description")
            objNC.IsSiteNews = CBool(dr.Item("IsSiteNews"))
            objNC.IsSubscription = CBool(dr.Item("IsSubscription"))
            objNC.NewsCategoryID = dr.Item("NewsCategoryID")
            objNC.IsValid = dr.Item("IsValid")

            Return objNC

        End Function

        Private Function FillNewsInfo(ByVal dr As IDataReader) As NewsInfo

            Dim objNewsInfo As New NewsInfo

            objNewsInfo.Body = dr.Item("Body")
            objNewsInfo.NewsID = dr.Item("NewsID")
            objNewsInfo.NewsCategoryID = dr.Item("NewsCategoryID")
            objNewsInfo.Subject = dr.Item("Subject")
            objNewsInfo.IsSiteNews = CBool(dr.Item("IsSiteNews"))
            objNewsInfo.UpdateDT = CDate(dr.Item("UpdateDT"))
            objNewsInfo.IsValid = CBool(dr.Item("IsValid"))

            Return objNewsInfo

        End Function


#End Region



#Region "---Public Method---"

        Public Function GetNewsCategoryList() As List(Of NewsCategoryInfo)

            Dim objNCI As New List(Of NewsCategoryInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_News_GetNewsCategoryList")
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    objNCI.Add(FillNewsCategoryInfo(reader))
                End While
                Return objNCI
            End Using

        End Function


        Public Function GetNewsCategory(ByVal NewsCategoryID As Integer) As NewsCategoryInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_News_GetNewsCategory")
            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@NewsCategoryID", DbType.Int32, NewsCategoryID)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillNewsCategoryInfo(reader)
                End While
                Return Nothing
            End Using
        End Function

        Public Sub AddNews(ByVal newsinfo As NewsInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_News_AddNews"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            Dim newID As Integer = GetKeys("NewsID")

            db.AddInParameter(dbCommand, "@NewsID", DbType.Int32, newID)
            db.AddInParameter(dbCommand, "@NewsCategoryID", DbType.Int32, newsinfo.NewsCategoryID)
            db.AddInParameter(dbCommand, "@Subject", DbType.String, newsinfo.Subject)
            db.AddInParameter(dbCommand, "@Body", DbType.String, newsinfo.Body)
            db.AddInParameter(dbCommand, "@IsSiteNews", DbType.Boolean, newsinfo.IsSiteNews)

            db.ExecuteNonQuery(dbCommand)

        End Sub
        Public Sub AddNewsCategory(ByVal newCategoryInfo As NewsCategoryInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_News_AddNewsCategory"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            Dim NewsCategoryID As Integer = GetKeys("NewsCategoryID")

            db.AddInParameter(dbCommand, "@NewsCategoryID", DbType.Int32, NewsCategoryID)
            db.AddInParameter(dbCommand, "@Name", DbType.String, newCategoryInfo.Name)
            db.AddInParameter(dbCommand, "@Description", DbType.String, newCategoryInfo.Description)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, newCategoryInfo.IsValid)
            db.AddInParameter(dbCommand, "@IsSubscription", DbType.Boolean, newCategoryInfo.IsSubscription)
            db.AddInParameter(dbCommand, "@IsSiteNews", DbType.Boolean, newCategoryInfo.IsSiteNews)
            db.ExecuteNonQuery(dbCommand)
        End Sub
        Public Sub UpdateNews(ByVal newsinfo As NewsInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_News_UpdateNews"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@NewsID", DbType.Int32, newsinfo.NewsID)
            db.AddInParameter(dbCommand, "@NewsCategoryID", DbType.Int32, newsinfo.NewsCategoryID)
            db.AddInParameter(dbCommand, "@Subject", DbType.String, newsinfo.Subject)
            db.AddInParameter(dbCommand, "@Body", DbType.String, newsinfo.Body)
            db.AddInParameter(dbCommand, "@IsSiteNews", DbType.Boolean, newsinfo.IsSiteNews)
            db.ExecuteNonQuery(dbCommand)
        End Sub


        Public Sub UpdateNewsCategory(ByVal newCategoryInfo As NewsCategoryInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_News_UpdateNewsCategory"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@NewsCategoryID", DbType.Int32, newCategoryInfo.NewsCategoryID)
            db.AddInParameter(dbCommand, "@Name", DbType.String, newCategoryInfo.Name)
            db.AddInParameter(dbCommand, "@Description", DbType.String, newCategoryInfo.Description)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, newCategoryInfo.IsValid)
            db.AddInParameter(dbCommand, "@IsSubscription", DbType.Boolean, newCategoryInfo.IsSubscription)
            db.AddInParameter(dbCommand, "@IsSiteNews", DbType.Boolean, newCategoryInfo.IsSiteNews)
            db.ExecuteNonQuery(dbCommand)
        End Sub
        Public Sub UpdateNewsQuick(ByVal newsID As Integer, ByVal isValid As Boolean, ByVal isSiteNews As Boolean)
            'Dim sqlb As New StringBuilder
            'sqlb.Append("UPDATE NewsCategory SET ")
            'sqlb.Append(String.Format("IsValid={0},", IIf(isValid, 1, 0)))
            'sqlb.Append(String.Format("IsSiteNews={0}", IIf(isSiteNews, 1, 0)))
            'sqlb.Append(String.Format(" WHERE NewsCategoryID={0}", newsCategoryID.ToString))
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_News_UpdateNewsQuick"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@newsID", DbType.Int32, newsID)
            db.AddInParameter(dbCommand, "@IsSiteNews", DbType.Int32, isSiteNews)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Int32, isValid)
            db.ExecuteNonQuery(dbCommand)

        End Sub
        Public Sub UpdateNewsCategoryQuick(ByVal newsCategoryID As Integer, ByVal isValid As Boolean, ByVal isSiteNews As Boolean)
            'Dim sqlb As New StringBuilder
            'sqlb.Append("UPDATE NewsCategory SET ")
            'sqlb.Append(String.Format("IsValid={0},", IIf(isValid, 1, 0)))
            'sqlb.Append(String.Format("IsSiteNews={0}", IIf(isSiteNews, 1, 0)))
            'sqlb.Append(String.Format(" WHERE NewsCategoryID={0}", newsCategoryID.ToString))
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_News_UpdateNewsCategoryQuick"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@newsCategoryID", DbType.Int32, newsCategoryID)
            db.AddInParameter(dbCommand, "@IsSiteNews", DbType.Int32, isSiteNews)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Int32, isValid)
            db.ExecuteNonQuery(dbCommand)

        End Sub
        Public Sub DeleteNews(ByVal newsID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_News_DeleteNews"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@NewsID", DbType.Int32, newsID)

            db.ExecuteNonQuery(dbCommand)
        End Sub
        Public Sub DeleteNewsCategory(ByVal newCategoryID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_News_DeleteNewsCategory"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@NewsCategoryID", DbType.Int32, newCategoryID)

            db.ExecuteNonQuery(dbCommand)
        End Sub
        Public Sub DeleteNewsSubscription(ByVal email As String)

        End Sub

        Public Function GetNewsSubscriptionList() As List(Of NewsSubscriptionInfo)
            Return Nothing
        End Function
        Public Function GetNewsList(ByVal NewsCategoryID As Integer) As List(Of NewsInfo)

            Dim objNewsList As New List(Of NewsInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase

            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_News_GetNewsList")
            db.AddInParameter(dbCommand, "@NewsCategoryID", DbType.Int32, NewsCategoryID)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    objNewsList.Add(FillNewsInfo(reader))
                End While
                Return objNewsList
            End Using

        End Function
        Public Function GetNews(ByVal NewsID As Integer) As NewsInfo

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_News_GetNews")
            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@NewsID", DbType.Int32, NewsID)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillNewsInfo(reader)
                End While
                Return Nothing
            End Using

        End Function
     


#End Region
    



    End Class

End Namespace