Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports System.Data.SqlClient
Imports System.Data.Common
Imports System.Data
Imports System.Collections.Generic
Imports System.Text
Imports System.Web
Imports System.Windows.Forms
Imports System.Security.Cryptography
Imports System.IO
Namespace NetShopForge.Library.Order
    Public Class OrderController


#Region "---Public Method---"

        Public Shared Function GetOrderList(ByVal pageSize As Integer, ByVal pageIndex As Integer, Optional ByVal sqlWhere As String = "", Optional ByVal isDesc As Boolean = True) As List(Of OrderInfo)
            Dim oList As New List(Of OrderInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Order_GetOrderListByPage")

            db.AddInParameter(dbCommand, "@pagesize", DbType.Int32, pageSize)
            db.AddInParameter(dbCommand, "@pageindex", DbType.Int32, pageIndex)
            db.AddInParameter(dbCommand, "@OrderType", DbType.Boolean, isDesc)
            If sqlWhere.Length > 0 Then db.AddInParameter(dbCommand, "@SqlWhere", DbType.String, sqlWhere)

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    oList.Add(FillOrderInfo(reader))
                End While
                Return oList
            End Using
            Return oList
        End Function
        Public Shared Function GetOrderNumberByPage(ByVal sqlWhere As String) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Order_GetOrderListByPage")

            db.AddInParameter(dbCommand, "@IsCount", DbType.Boolean, True)
            If sqlWhere.Length > 0 Then db.AddInParameter(dbCommand, "@SqlWhere", DbType.String, sqlWhere)

            Return CInt(db.ExecuteScalar(dbCommand))
        End Function
        Public Shared Function GetOrder(ByVal orderID As Integer) As OrderInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Order_GetOrder")
            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@orderID", DbType.String, orderID)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillOrderInfo(reader)
                End While
                Return Nothing
            End Using

        End Function
        Public Shared Function GetOrderDetailList(ByVal orderID As Integer) As List(Of OrderDetailInfo)
            Dim odList As New List(Of OrderDetailInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Order_GetOrderDetailList")

            db.AddInParameter(dbCommand, "@OrderID", DbType.Int32, orderID)

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    odList.Add(FillOrderDetailInfo(reader))
                End While
                Return odList
            End Using
            Return odList
        End Function
        Private Shared Function GetCurrentTimeOrder() As String
            Dim random As Random = New Random()

            Return Now.ToString("yyyyMMddHHmmss") & random.Next(0, 9999).ToString("####0000")
        End Function


        Public Shared Function GetNotProcessedOrder() As Integer
            Dim sqlWhere As String = String.Format("OrderStatus={0}", CInt(OrderStatus.NotProcessed))
            Return GetOrderNumberByPage(sqlWhere)
        End Function

        Public Shared Function CreateOrder(ByVal provisionOrder As OrderInfo, ByVal provisionOrderDeteails As List(Of OrderDetailInfo)) As Integer

            Dim orderID As Integer = AddOrder(provisionOrder)
            Dim oItem As OrderDetailInfo
            For Each oItem In provisionOrderDeteails
                AddOrderDetail(oItem, orderID)
            Next
            Return orderID
        End Function


        Public Shared Function GetOrderNoteList(ByVal orderID As Integer, ByVal Actions() As OrderAction) As List(Of OrderNoteInfo)
            Dim WhereCondition As String
            If Actions.Length = 0 Then
                WhereCondition = String.Format("OrderID={0} ", orderID.ToString)
            Else
                Dim a As OrderAction
                WhereCondition = String.Format("OrderID={0} ", orderID.ToString)
                Dim sTemp As String = ""
                For Each a In Actions
                    sTemp += String.Format(",{0}", CInt(a).ToString)
                Next
                sTemp = sTemp.Substring(1)
                WhereCondition += " AND OrderStatus IN (" & sTemp & ")"
            End If
            Return GetOrderNoteList(WhereCondition)
        End Function



        Private Shared Function GetOrderNoteList(ByVal WhereCondition As String) As List(Of OrderNoteInfo)
            Dim onList As New List(Of OrderNoteInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Order_GetOrderNoteList")

            db.AddInParameter(dbCommand, "@WhereCondition", DbType.String, WhereCondition)
            db.AddInParameter(dbCommand, "@OrderByExpression", DbType.String, "Date")

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    onList.Add(FillOrderNoteInfo(reader))
                End While
                Return onList
            End Using
            Return onList
        End Function



        Public Shared Sub DeleteOrder(ByVal orderID As Integer)


            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Order_DeleteOrder")

            db.AddInParameter(dbCommand, "@OrderID", DbType.Int32, orderID)

            db.ExecuteNonQuery(dbCommand)

        End Sub



#Region "Permission Sets"

        Public Shared Function GetOrderActionsForUser(ByVal status As OrderStatus) As List(Of OrderAction)

            Dim actions As New List(Of OrderAction)
            actions.Add(OrderAction.ViewDetail)
            actions.Add(OrderAction.B_Review)

            Select Case status
                Case OrderStatus.AwatingShipmentToCustomer
                    'actions.Add(OrderAction.B_Refund)
                Case OrderStatus.NotProcessed
                    actions.Add(OrderAction.B_Cancel)
                    actions.Add(OrderAction.B_Modify)
                    'actions.Add(OrderAction.B_Pay)
                Case OrderStatus.OrderCancelledPriorToShipping
                Case OrderStatus.OrderComplete
                Case OrderStatus.OrderRefunded
                Case OrderStatus.ReceivedAwaitingPayment
                    actions.Add(OrderAction.B_Cancel)
                    actions.Add(OrderAction.B_Pay)
                Case OrderStatus.ReceivedPaymentProcessingOrder
                    actions.Add(OrderAction.B_Cancel)
                    '   actions.Add(OrderAction.B_Refund)
                Case OrderStatus.ShippedToCustomer
                    actions.Add(OrderAction.B_Received)
            End Select

            Return actions

        End Function

        Public Shared Function GetOrderActionsForAdmin(ByVal status As OrderStatus) As List(Of OrderAction)
            Dim actions As New List(Of OrderAction)
            actions.Add(OrderAction.ViewDetail)
            '   actions.Add(OrderAction.S_Review)
            Select Case status
                Case OrderStatus.AwatingShipmentToCustomer
                    'actions.Add(OrderAction.S_Refund)
                    actions.Add(OrderAction.S_Cancel)
                    actions.Add(OrderAction.S_Shipped)
                Case OrderStatus.NotProcessed
                    actions.Add(OrderAction.S_Cancel)
                    actions.Add(OrderAction.S_Modify)
                    actions.Add(OrderAction.S_Received)
                Case OrderStatus.OrderCancelledPriorToShipping
                Case OrderStatus.OrderComplete
                Case OrderStatus.OrderRefunded
                Case OrderStatus.ReceivedAwaitingPayment
                    actions.Add(OrderAction.S_Cancel)
                    actions.Add(OrderAction.S_ReceivedPay)
                Case OrderStatus.ReceivedPaymentProcessingOrder
                    actions.Add(OrderAction.S_Cancel)
                    actions.Add(OrderAction.S_Shipped)
                    '   actions.Add(OrderAction.S_Refund)
                Case OrderStatus.ShippedToCustomer
                    actions.Add(OrderAction.S_Complete)
            End Select
            Return actions

        End Function

        Public Shared Function IsPay(ByVal status As Order.OrderStatus) As Boolean
            Dim pay As Boolean = True
            Select Case status
                Case OrderStatus.AwatingShipmentToCustomer
                Case OrderStatus.NotProcessed
                    pay = False
                Case OrderStatus.OrderCancelledPriorToShipping
                Case OrderStatus.OrderComplete
                Case OrderStatus.OrderRefunded
                Case OrderStatus.ReceivedAwaitingPayment
                    pay = False
                Case OrderStatus.ReceivedPaymentProcessingOrder
                Case OrderStatus.ShippedToCustomer
            End Select

            Return pay



        End Function
        Public Shared Function GetChineseOrderStatus(ByVal status As Order.OrderStatus) As String
            Dim s As String = ""
            Select Case status
                Case OrderStatus.AwatingShipmentToCustomer
                    s = "׼"
                Case OrderStatus.NotProcessed
                    s = "Ѵ,ȴȷ"
                Case OrderStatus.OrderCancelledPriorToShipping
                    s = "ȡ"
                Case OrderStatus.OrderComplete
                    s = ""
                Case OrderStatus.OrderRefunded
                    s = "˿"
                Case OrderStatus.ReceivedPaymentProcessingOrder
                    s = "յ,"
                Case OrderStatus.ReceivedAwaitingPayment
                    s = "ȷ,ȴ"
                Case OrderStatus.ShippedToCustomer
                    s = "ѷ"
                Case OrderStatus.NoReceived
                    s = "ûͨ"

            End Select
            Return s
        End Function

        Public Shared Function GetChineseOrderAction(ByVal action As OrderAction) As String
            Dim a As String = ""
            Select Case action
                Case OrderAction.B_Pay
                    a = ""
                Case OrderAction.B_Received
                    a = "ջ"
                Case OrderAction.B_Refund
                    a = "˿"
                Case OrderAction.B_Cancel, OrderAction.S_Cancel
                    a = "ȡ"
                Case OrderAction.B_Modify, OrderAction.S_Modify
                    a = "޸"
                Case OrderAction.S_Review
                    a = "Ա"
                Case OrderAction.B_Review
                    a = "˿"
                Case OrderAction.S_Received
                    a = "ȷ"
                Case OrderAction.S_ReceivedPay
                    a = ""
                Case OrderAction.S_Refund
                    a = "˿"
                Case OrderAction.S_Shipped
                    a = ""
                Case OrderAction.ViewDetail
                    a = "鿴"
                Case OrderAction.S_Complete
                    a = "鵵"
            End Select
            Return a
        End Function
#End Region


#End Region

#Region "---Private Method---"


        Private Shared Function FillOrderInfo(ByVal dr As IDataReader) As OrderInfo

            Dim objOrder As New OrderInfo
            objOrder.BillingArea = dr.Item("BillingArea")
            objOrder.BillingAddress = dr.Item("BillingAddress")
            objOrder.BillingCity = dr.Item("BillingCity")
            objOrder.BillingCounTry = dr.Item("BillingCountry")
            objOrder.BillingName = dr.Item("BillingName")
            objOrder.BillingPhone = dr.Item("BillingPhone")
            objOrder.BillingPostalCode = dr.Item("BillingPostalCode")
            objOrder.BillingState = dr.Item("BillingState")
            objOrder.CouponFee = dr.Item("CouponFee")
            objOrder.CustomerNote = dr.Item("CustomerNote")
            objOrder.DiscountFee = dr.Item("DiscountFee")
            objOrder.InvoiceTitle = dr.Item("InvoiceTitle")
            objOrder.IsCancel = dr.Item("IsCancel")
            objOrder.NeedInvoice = dr.Item("NeedInvoice")
            objOrder.OrderDate = dr.Item("OrderDate")
            objOrder.OrderID = dr.Item("OrderID")
            objOrder.OrderNumber = dr.Item("OrderNumber")
            objOrder.PaymentMethodID = dr.Item("PaymentMethodID")
            objOrder.ProductSubtotalFee = dr.Item("ProductSubtotalFee")
            If Not IsDBNull(dr.Item("SendDate")) Then
                objOrder.SendDate = dr.Item("SendDate")
            End If

            objOrder.ShipAddress = dr.Item("ShipAddress")
            objOrder.ShipAddress2 = dr.Item("ShipAddress2")
            objOrder.ShipArea = dr.Item("ShipArea")
            objOrder.ShipAreaID = dr.Item("ShipAreaID")
            objOrder.ShipCity = dr.Item("ShipCity")
            objOrder.ShipCountry = dr.Item("ShipCounTry")
            objOrder.ShipName = dr.Item("ShipName")
            objOrder.ShippingFee = dr.Item("ShippingFee")
            objOrder.ShippingMethodID = dr.Item("ShippingMethodID")
            objOrder.ShipState = dr.Item("ShipState")
            objOrder.ShipPhone = dr.Item("ShipPhone")
            objOrder.OrderStatus = CInt(dr.Item("OrderStatus"))
            'objOrder.PayStatus = CInt(dr.Item("PayStatus"))
            objOrder.TotalFee = dr.Item("TotalFee")
            objOrder.UserName = dr.Item("UserName")
            '    objOrder.UserID = dr.Item("UserID")

            Return objOrder

        End Function
        Private Shared Function FillOrderDetailInfo(ByVal dr As IDataReader) As OrderDetailInfo

            Dim objOrderDetail As New OrderDetailInfo

            objOrderDetail.Discount = dr.Item("Discount")
            objOrderDetail.OrderDetailID = dr.Item("OrderDetailID")
            objOrderDetail.OrderID = dr.Item("OrderID")
            objOrderDetail.ProductID = dr.Item("ProductID")
            objOrderDetail.ProductOptions = dr.Item("ProductOptions")
            objOrderDetail.Quantity = dr.Item("Quantity")
            objOrderDetail.UnitCost = dr.Item("UnitCost")
            objOrderDetail.ProductName = dr.Item("ProductName")

            Return objOrderDetail

        End Function

        Private Shared Function FillOrderNoteInfo(ByVal dr As IDataReader) As OrderNoteInfo

            Dim objOrderNote As New OrderNoteInfo

            objOrderNote.Action = CInt(dr.Item("Action"))
            objOrderNote.Note = dr.Item("Note")
            objOrderNote.NoteDate = CDate(dr.Item("Date"))
            objOrderNote.NoteID = dr.Item("NoteID")
            objOrderNote.OrderID = dr.Item("OrderID")
            objOrderNote.OrderStatus = CInt(dr.Item("OrderStatus"))


            Return objOrderNote

        End Function





        Private Shared Function AddOrder(ByVal O As OrderInfo) As Integer

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Order_AddOrder")
            O.OrderID = Common.GetKeys("OrderID")
            O.OrderNumber = GetCurrentTimeOrder()
            db.AddInParameter(dbCommand, "@OrderID", DbType.Int32, O.OrderID)
            db.AddInParameter(dbCommand, "@OrderNumber", DbType.String, O.OrderNumber)
            db.AddInParameter(dbCommand, "@UserName", DbType.String, O.UserName)
            db.AddInParameter(dbCommand, "@ProductSubtotalFee", DbType.Decimal, O.ProductSubtotalFee)
            db.AddInParameter(dbCommand, "@DiscountFee", DbType.Decimal, O.DiscountFee)
            db.AddInParameter(dbCommand, "@CouponFee", DbType.Decimal, O.CouponFee)
            db.AddInParameter(dbCommand, "@ShippingFee", DbType.Decimal, O.ShippingFee)
            db.AddInParameter(dbCommand, "@TotalFee", DbType.Decimal, O.TotalFee)
            db.AddInParameter(dbCommand, "@OrderStatus", DbType.Int32, O.OrderStatus)
            db.AddInParameter(dbCommand, "@NeedInvoice", DbType.Boolean, O.NeedInvoice)
            db.AddInParameter(dbCommand, "@InvoiceTitle", DbType.String, O.InvoiceTitle)
            db.AddInParameter(dbCommand, "@ShippingMethodID", DbType.Int32, O.ShippingMethodID)
            db.AddInParameter(dbCommand, "@PaymentMethodID", DbType.Int32, O.PaymentMethodID)
            db.AddInParameter(dbCommand, "@OrderDate", DbType.DateTime, O.OrderDate)
            db.AddInParameter(dbCommand, "@SendDate", DbType.DateTime, O.SendDate)
            db.AddInParameter(dbCommand, "@CustomerNote", DbType.String, O.CustomerNote)
            db.AddInParameter(dbCommand, "@ShipName", DbType.String, O.ShipName)
            db.AddInParameter(dbCommand, "@ShipAddress", DbType.String, O.ShipAddress)
            db.AddInParameter(dbCommand, "@ShipAddress2", DbType.String, O.ShipAddress2)
            db.AddInParameter(dbCommand, "@ShipAreaID", DbType.String, O.ShipAreaID)
            db.AddInParameter(dbCommand, "@ShipArea", DbType.String, O.ShipArea)
            db.AddInParameter(dbCommand, "@ShipCity", DbType.String, O.ShipCity)
            db.AddInParameter(dbCommand, "@ShipState", DbType.String, O.ShipState)
            db.AddInParameter(dbCommand, "@ShipPostalCode", DbType.String, O.ShipPostalCode)
            db.AddInParameter(dbCommand, "@ShipCountry", DbType.String, O.ShipCountry)
            db.AddInParameter(dbCommand, "@ShipPhone", DbType.String, O.ShipPhone)
            db.AddInParameter(dbCommand, "@BillingName", DbType.String, O.BillingName)
            db.AddInParameter(dbCommand, "@BillingCountry", DbType.String, O.BillingCounTry)
            db.AddInParameter(dbCommand, "@BillingState", DbType.String, O.BillingState)
            db.AddInParameter(dbCommand, "@BillingCity", DbType.String, O.BillingCity)
            db.AddInParameter(dbCommand, "@BillingArea", DbType.String, O.BillingArea)
            db.AddInParameter(dbCommand, "@BillingAddress", DbType.String, O.BillingAddress)
            db.AddInParameter(dbCommand, "@BillingPostalCode", DbType.String, O.BillingPostalCode)
            db.AddInParameter(dbCommand, "@BillingPhone", DbType.String, O.BillingPhone)
            db.AddInParameter(dbCommand, "@IsCancel", DbType.Boolean, O.IsCancel)

            db.ExecuteNonQuery(dbCommand)
            Return O.OrderID
        End Function
        Private Shared Sub AddOrderDetail(ByVal oItem As OrderDetailInfo, ByVal orederID As Integer)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Order_AddOrderDetail")
            oItem.OrderDetailID = Common.GetKeys("OrderDetailID")
            oItem.OrderID = orederID
            db.AddInParameter(dbCommand, "@OrderDetailID", DbType.Int32, oItem.OrderDetailID)
            db.AddInParameter(dbCommand, "@OrderID", DbType.String, oItem.OrderID)
            db.AddInParameter(dbCommand, "@ProductID", DbType.String, oItem.ProductID)
            db.AddInParameter(dbCommand, "@Quantity", DbType.Decimal, oItem.Quantity)
            db.AddInParameter(dbCommand, "@UnitCost", DbType.Decimal, oItem.UnitCost)
            db.AddInParameter(dbCommand, "@Discount", DbType.Decimal, oItem.Discount)
            db.AddInParameter(dbCommand, "@ProductOptions", DbType.String, oItem.ProductOptions)
            db.ExecuteNonQuery(dbCommand)
        End Sub

        Public Shared Sub AddOrderNote(ByVal note As OrderNoteInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Order_AddOrderNote")
            note.NoteID = Common.GetKeys("OrderNoteID")
            db.AddInParameter(dbCommand, "@NoteID", DbType.Int32, note.NoteID)
            db.AddInParameter(dbCommand, "@OrderID", DbType.Int32, note.OrderID)
            db.AddInParameter(dbCommand, "@Note", DbType.String, note.Note)
            db.AddInParameter(dbCommand, "@OrderStatus", DbType.Int32, CInt(note.OrderStatus))
            db.AddInParameter(dbCommand, "@Date", DbType.Date, note.NoteDate)
            db.AddInParameter(dbCommand, "@Action", DbType.Int32, CInt(note.Action))
            db.ExecuteNonQuery(dbCommand)
        End Sub

        Public Shared Sub UpdateOrderStatus(ByVal orderID As Integer, ByVal orderStatus As OrderStatus)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Order_UpdateOrderStatus")

            db.AddInParameter(dbCommand, "@OrderID", DbType.Int32, orderID)
            db.AddInParameter(dbCommand, "@OrderStatus", DbType.Int32, CInt(orderStatus))

            db.ExecuteNonQuery(dbCommand)

        End Sub





#End Region

    End Class

End Namespace


