Imports System.Text
Imports System.Collections
Imports NetShopForge.Common
Imports System.Data
Imports System.Data.Common
Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Common


Namespace NetShopForge.Library.Payment
    Public Class PaymentController

#Region "Private Member"
        Private Shared _Instance As PaymentController
#End Region
#Region "Shared Method"
        Public Shared ReadOnly Property Instance() As PaymentController
            Get
                If IsNothing(_Instance) Then
                    _Instance = New PaymentController
                End If
                Return _Instance
            End Get
        End Property
#End Region

        Public Function GetPaymentMethodList() As List(Of PaymentMethodInfo)
            '[nsf_Payment_GetPaymentMethodList]
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Payment_GetPaymentMethodList")

            Dim payList As New List(Of PaymentMethodInfo)

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    payList.Add(FillPaymentMethodInfo(reader))
                End While
                Return payList
            End Using
        End Function

        Public Function AddPaymentMethod(ByVal payMethod As PaymentMethodInfo) As Integer

            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Payment_AddPaymentMethod"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            Dim PaymentMethodID As Integer = GetKeys("PaymentMethodID")
            db.AddInParameter(dbCommand, "@PaymentMethodID", DbType.Int32, PaymentMethodID)
            db.AddInParameter(dbCommand, "@PaymentGateway", DbType.Int32, payMethod.PaymentGateway)
            db.AddInParameter(dbCommand, "@paymentMethodName", DbType.String, payMethod.PaymentMethodName)
            db.AddInParameter(dbCommand, "@MerchantID", DbType.String, payMethod.MerchantID)
            db.AddInParameter(dbCommand, "@MerchantKey", DbType.String, payMethod.MerchantKey)
            db.AddInParameter(dbCommand, "@Currency", DbType.String, payMethod.Currency)
            db.AddInParameter(dbCommand, "@Button", DbType.Int32, payMethod.Button)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, payMethod.IsValid)
            db.AddInParameter(dbCommand, "@Description", DbType.String, payMethod.Description)
            db.AddInParameter(dbCommand, "@Expressions", DbType.String, payMethod.Expressions)
            db.ExecuteNonQuery(dbCommand)
            Return PaymentMethodID
        End Function

        Public Sub UpdatePaymentMethod(ByVal payMethod As PaymentMethodInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Payment_UpdatePaymentMethod"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@PaymentMethodID", DbType.Int32, payMethod.PaymentMethodID)
            db.AddInParameter(dbCommand, "@PaymentGateway", DbType.Int32, payMethod.PaymentGateway)
            db.AddInParameter(dbCommand, "@paymentMethodName", DbType.String, payMethod.PaymentMethodName)
            db.AddInParameter(dbCommand, "@MerchantID", DbType.String, payMethod.MerchantID)
            db.AddInParameter(dbCommand, "@MerchantKey", DbType.String, payMethod.MerchantKey)
            db.AddInParameter(dbCommand, "@Currency", DbType.String, payMethod.Currency)
            db.AddInParameter(dbCommand, "@Button", DbType.Int32, payMethod.Button)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, payMethod.IsValid)
            db.AddInParameter(dbCommand, "@Description", DbType.String, payMethod.Description)
            db.AddInParameter(dbCommand, "@Expressions", DbType.String, payMethod.Expressions)
            db.ExecuteNonQuery(dbCommand)
        End Sub
        Public Sub UpdatePaymentMethodQuick(ByVal paymentMethodID As Integer, ByVal isValid As Boolean, ByVal itemOrder As Integer)
            Dim sqlb As New StringBuilder
            sqlb.Append("UPDATE nsf_PaymentMethod SET ")
            sqlb.Append(String.Format(" IsValid={0},", IIf(isValid, 1, 0)))
            sqlb.Append(String.Format(" ItemOrder={0} ", itemOrder.ToString))
            sqlb.Append(String.Format(" WHERE PaymentMethodID={0}", paymentMethodID.ToString))
            Dim db As Database = DatabaseFactory.CreateDatabase
            db.ExecuteNonQuery(CommandType.Text, sqlb.ToString)
        End Sub
        Public Sub DeletePaymentMethod(ByVal paymentMethodID As Integer)
            Dim sql As String = String.Format("DELETE nsf_PaymentMethod WHERE PaymentMethodID={0} ", paymentMethodID.ToString)
            Dim db As Database = DatabaseFactory.CreateDatabase
            db.ExecuteNonQuery(CommandType.Text, sql)
        End Sub

        Public Function GetPaymentMethodList(ByVal PaymentMethodCollection As String()) As List(Of PaymentMethodInfo)
            '[nsf_Payment_GetPaymentMethodList]
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Payment_GetPaymentMethodList")
            Dim sb As New StringBuilder
            Dim sPaymentMethodID As String
            For Each sPaymentMethodID In PaymentMethodCollection
                sb.Append(String.Format(",{0}", sPaymentMethodID))
            Next
            Dim sql As String = String.Format("PaymentMethodID IN ({0})", sb.ToString.Substring(1))
            db.AddInParameter(dbCommand, "@strWhere", DbType.String, sql)

            Dim payList As New List(Of PaymentMethodInfo)

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    payList.Add(FillPaymentMethodInfo(reader))
                End While
                Return payList
            End Using
        End Function
        Public Function GetPaymentMethodInfo(ByVal paymentMethodID As Integer) As PaymentMethodInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Payment_GetPaymentMethod")

            db.AddInParameter(dbCommand, "@PaymentMethodID", DbType.Int32, paymentMethodID)

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillPaymentMethodInfo(reader)
                End While
                Return Nothing
            End Using
        End Function
        Public Function GetPaymentMethodInfo(ByVal paymentGateway As PaymentGateway) As PaymentMethodInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Payment_GetPaymentMethod")

            db.AddInParameter(dbCommand, "@PaymentGateway", DbType.Int32, CInt(paymentGateway))

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillPaymentMethodInfo(reader)
                End While
                Return Nothing
            End Using
        End Function
        Public Function WriteSendString(ByVal gatewayURL As String, ByVal parameterValues As Generic.Dictionary(Of String, String)) As String
            Dim sb As New StringBuilder
            Dim parameter As String
            sb.Append(String.Format("<form name=""paymentpost"" method=""post"" action=""{0}"">", gatewayURL))
            If parameterValues.Count = 0 Then Return ""
            For Each parameter In parameterValues.Keys
                sb.Append(String.Format("<input id=""{0}"" name=""{0}"" type=""hidden""  value=""{1}"">", parameter, parameterValues.Item(parameter)))
            Next
            sb.Append("</form>")
            sb.Append("<script language=""JavaScript"">document.paymentpost.submit();</script>")
            Return sb.ToString

        End Function
        Public Function WriteSendString(ByVal URL As String) As String
            Return String.Format("<script language='javascript'>location='{0}'</script>", URL)
        End Function


#Region "---Private Method---"

        Private Function FillPaymentMethodInfo(ByVal dr As IDataReader) As PaymentMethodInfo

            Dim objpay As New PaymentMethodInfo

            objpay.Button = Utility.GetInt32(dr, "Button")
            objpay.Currency = Utility.GetString(dr, "Currency")
            objpay.Description = Utility.GetString(dr, "Description")
            objpay.Expressions = Utility.GetString(dr, "Expressions")

            objpay.IsValid = Utility.GetBoolean(dr, "IsValid")
            objpay.ItemOrder = Utility.GetInt32(dr, "ItemOrder")

            objpay.MerchantID = Utility.GetString(dr, "MerchantID")
            objpay.MerchantKey = Utility.GetString(dr, "MerchantKey")
            objpay.PaymentGateway = CType(Utility.GetInt32(dr, "PaymentGateway"), PaymentGateway)
            objpay.PaymentMethodID = Utility.GetInt32(dr, "PaymentMethodID")
            objpay.PaymentMethodName = Utility.GetString(dr, "PaymentMethodName")

            Return objpay

        End Function

#End Region
    End Class
End Namespace

