Imports NetShopForge.Library.Order

Namespace NetShopForge.Library.Payment

    Public Class PaymentService
        Implements IPayment


        Private _Payment As IPayment

#Region " Load Payment  "

        Private ReadOnly Property Instance(ByVal paymentMethodID As Integer) As IPayment
            Get
                LoadPayment(paymentMethodID)
                Return _Payment
            End Get
        End Property
        Private Sub LoadPayment(ByVal paymentGateway As PaymentGateway)
            Select Case paymentGateway
                Case Payment.PaymentGateway.gw99Bill
                    _Payment = New pm99Bil
                Case Library.Payment.PaymentGateway.gwAdvance
                    _Payment = New pmAdvance
                Case Payment.PaymentGateway.gwAliPay
                    _Payment = New pmAlipay
                Case Payment.PaymentGateway.gwChinaBank
                    _Payment = New pmChinaBank
                Case Payment.PaymentGateway.gwOffline
                Case Payment.PaymentGateway.gwPaypalCN
                    _Payment = New pmPaypalCN
            End Select
        End Sub
#End Region

#Region "Payment Service Method  "

        Public Function Recive(ByVal page As System.Web.UI.Page) As NetShopForge.Library.Order.OrderTransactionInfo Implements IPayment.Recive
            Dim gwPayment As PaymentGateway = CInt(page.Request("PayType"))
            Return Instance(gwPayment).Recive(page)
        End Function

        Public Function Send(ByVal orderID As Integer) As String Implements IPayment.Send
            Dim objPC As New PaymentController
            '  Dim objOC As New OrderController
            Dim order As OrderInfo = OrderController.GetOrder(orderID)
            'TODO:  Check is Valid Order
            ''''''''
            Dim pmInfo As PaymentMethodInfo = objPC.GetPaymentMethodInfo(CInt(order.PaymentMethodID))
            Return Instance(pmInfo.PaymentGateway).Send(orderID)
     
        End Function

#End Region




    End Class


End Namespace

