Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports System.Data.SqlClient
Imports System.Data.Common
Imports System.Data
Imports System.Collections.Generic
Imports System.Text
Imports System.Web
Namespace NetShopForge.Library.Product

    Public Class FeatureProductController

#Region "---Public Method---"

        Public Function GetFeatureProductList(ByVal categoryID As Integer) As List(Of FeatureProductInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetFeatureProducts")
            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, categoryID)
            Dim FeatureList As New List(Of FeatureProductInfo)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    FeatureList.Add(FillFeatureProductInfo(reader))
                End While
                Return FeatureList
            End Using
        End Function

        Public Sub AddFeatureProduct(ByVal featureProduct As FeatureProductInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_AddFeatureProducts")
            ' Add paramters
            ' Input parameters can specify the input value
            ' @ProductID int ,
            '@CategoryID int ,
            '@ItemOrder int ,
            '@IsValid bit
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, featureProduct.ProductID)
            db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, featureProduct.CategoryID)
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, featureProduct.ItemOrder)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, featureProduct.IsValid)

            db.ExecuteNonQuery(dbCommand)

        End Sub
        Public Sub DeleteFeatureProduct(ByVal ID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_DeleteFeatureProducts")
            ' Add paramters
            ' Input parameters can specify the input value
            ' @ProductID int ,
            '@CategoryID int ,
            '@ItemOrder int ,
            '@IsValid bit
            db.AddInParameter(dbCommand, "@ID", DbType.Int32, ID)

            db.ExecuteNonQuery(dbCommand)
        End Sub
        Public Sub UpdateFeatureProduct(ByVal ID As Int32, ByVal itemOrder As Integer, ByVal IsValid As Boolean)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_UpdateFeatureProducts")
            'Add paramters
            'Input parameters can specify the input value
            '@ID int,
            '@ItemOrder int ,
            '@IsValid bit
            db.AddInParameter(dbCommand, "@ID", DbType.Int32, ID)
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, itemOrder)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, IsValid)

            db.ExecuteNonQuery(dbCommand)

        End Sub

#End Region

#Region "---Private Method---"

        Private Function FillFeatureProductInfo(ByVal dr As IDataReader) As FeatureProductInfo

            Dim objFPI As New FeatureProductInfo

            objFPI.ProductID = CInt(dr.Item("ProductID"))
            objFPI.CategoryID = CInt(dr.Item("CategoryID"))
            objFPI.ID = CInt(dr.Item("ID"))
            objFPI.IsValid = CBool(dr.Item("IsValid"))
            objFPI.ItemOrder = CInt(dr.Item("ItemOrder"))
            objFPI.ProductName = dr.Item("ProductName")
            Return objFPI
        End Function
#End Region
    End Class

End Namespace
