
Imports System.Collections.Generic
Imports NetShopForge.Common

Namespace NetShopForge.Library.Product

    ''' <summary>
    ''' A collection of attributes. 
    ''' </summary>
    <Serializable()> _
    Public Class ProductAttributeCollection
        Implements System.Collections.ICollection

        Private items As System.Collections.ArrayList
        Public Sub New()
            items = New System.Collections.ArrayList()

        End Sub
        Public Sub Add(ByVal attributeInfo As ProductAttributeInfo)
            items.Add(attributeInfo)
        End Sub

        Public Sub RemoveAt(ByVal itemIndex As Integer)
            items.RemoveAt(itemIndex)
        End Sub

        Public Sub Remove(ByVal attributeInfo As ProductAttributeInfo)
            items.Remove(attributeInfo)
        End Sub


        Public Sub Insert(ByVal itemIndex As Integer, ByVal attributeInfo As ProductAttributeInfo)
            items.Insert(itemIndex, attributeInfo)
        End Sub

        Public Sub Sort()
            items.Sort()
        End Sub


        ''' <summary>
        ''' Indexer for this collection. Returns the CSK_Store_ProductAttribute object in the specified position.
        ''' </summary>
        Default Public ReadOnly Property Item(ByVal index As Integer) As ProductAttributeInfo
            Get
                Return CType(items(index), ProductAttributeInfo)
            End Get
        End Property

        Public Overrides Function ToString() As String
            Dim attSelections As String = ""
            For Each attributeInfo As ProductAttributeInfo In Me
                attSelections &= "<b>" & attributeInfo.Name & "</b>: " & attributeInfo.SelectionList & "<br>"
            Next attributeInfo
            Return attSelections

        End Function
        Public Function ToXML() As String
            Return Utility.ObjectToXML(GetType(ProductAttributeCollection), Me)
        End Function


        Public Sub CopyTo(ByVal array As System.Array, ByVal index As Integer) Implements System.Collections.ICollection.CopyTo
            items.CopyTo(array, index)
        End Sub

        Public ReadOnly Property Count() As Integer Implements System.Collections.ICollection.Count
            Get
                Return items.Count
            End Get
        End Property

        Public ReadOnly Property IsSynchronized() As Boolean Implements System.Collections.ICollection.IsSynchronized
            Get
                Return items.IsSynchronized
            End Get
        End Property

        Public ReadOnly Property SyncRoot() As Object Implements System.Collections.ICollection.SyncRoot
            Get
                Return items.SyncRoot
            End Get
        End Property

        Public Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
            Return items.GetEnumerator
        End Function
    End Class



End Namespace
