

Namespace NetShopForge.Library.Product

    ''' <summary>
    ''' A class that describes a product attribute, such as "Size"
    ''' </summary>
    <Serializable()> _
    Public Class ProductAttributeInfo
        Implements IComparable


        Private _name As String
        Private _description As String
        Private _selections As List(Of ProductAttributeSelection)
        Private _selectionType As ProductAttributeType
        Private _itemOrder As Integer

        Public Property Name() As String
            Get
                Return _name
            End Get
            Set(ByVal value As String)
                _name = value
            End Set
        End Property


        Public Property Description() As String
            Get
                Return _description
            End Get
            Set(ByVal value As String)
                _description = value
            End Set
        End Property

        Public Function GetPriceAdjustment(ByVal selection As String) As Decimal
            Dim dOut As Decimal = 0
            For Each sel As ProductAttributeSelection In Me._selections
                If sel.Value.ToLower().Equals(selection.ToLower()) Then
                    dOut = sel.PriceAdjustment
                    Exit For
                End If
            Next sel
            Return dOut
        End Function

        Public ReadOnly Property SelectionList() As String
            Get
                Dim sOut As String = ""
                If Not Me._selections Is Nothing Then
                    For Each sel As ProductAttributeSelection In Me._selections
                        sOut &= sel.Value & ", "
                    Next sel
                    If sOut.Length > 1 Then
                        sOut = sOut.Remove(sOut.Length - 2, 2)
                    End If
                End If
                Return sOut
            End Get
        End Property


        Public Property Selections() As List(Of ProductAttributeSelection)
            Get
                Return _selections
            End Get
            Set(ByVal value As List(Of ProductAttributeSelection))
                _selections = value
            End Set
        End Property


        Public Property SelectionType() As ProductAttributeType
            Get
                Return _selectionType
            End Get
            Set(ByVal value As ProductAttributeType)
                _selectionType = value
            End Set
        End Property

        Public Property ItemOrder() As Integer
            Get
                Return _itemOrder
            End Get
            Set(ByVal value As Integer)
                _itemOrder = value
            End Set
        End Property

        Public Function CompareTo(ByVal obj As Object) As Integer Implements System.IComparable.CompareTo
            If Not (TypeOf obj Is ProductAttributeInfo) Then
                Throw New InvalidCastException("Not a valid ProductAttributeInfo")
            End If
            Dim fav As ProductAttributeInfo = CType(obj, ProductAttributeInfo)
            Return Me.ItemOrder.CompareTo(fav.ItemOrder)

        End Function

    End Class



End Namespace
