
Namespace NetShopForge.Library.Product


    ''' <summary>
    ''' A class representing the selections for an attribute. Example: "Large", "Small", etc
    ''' </summary>
    <Serializable()> _
    Public Class ProductAttributeSelection
        Implements IComparable

        Private selectionValue As String
        Private _imageFile As String
        Private _priceAdjustment As Decimal
        Private _itemOrder As Integer

        Public Property FormattedValue() As String
            Get
                'if there is a price adjustment we want to show it
                'you can alter this however needed.
                Dim sOut As String = selectionValue
                If _priceAdjustment <> 0 Then
                    sOut &= " "
                    If _priceAdjustment > 0 Then
                        sOut &= "+"
                    End If

                    sOut &= _priceAdjustment.ToString("c")

                End If
                Return sOut

            End Get
            Set(ByVal value As String)
                selectionValue = value
            End Set
        End Property
        Public Property Value() As String
            Get
                Return selectionValue

            End Get
            Set(ByVal value As String)
                selectionValue = value
            End Set
        End Property
        Public Property ImageFile() As String
            Get
                Return _imageFile
            End Get
            Set(ByVal value As String)
                _imageFile = value
            End Set
        End Property

        Public Property PriceAdjustment() As Decimal
            Get
                Return _priceAdjustment
            End Get
            Set(ByVal value As Decimal)
                _priceAdjustment = value

            End Set
        End Property

        Public Property ItemOrder() As Integer
            Get
                Return _itemOrder
            End Get
            Set(ByVal value As Integer)
                _itemOrder = value
            End Set
        End Property

        Public Function CompareTo(ByVal obj As Object) As Integer Implements System.IComparable.CompareTo
            If Not (TypeOf obj Is ProductAttributeSelection) Then
                Throw New InvalidCastException("Not a valid ProductAttributeSelection")
            End If
            Dim fav As ProductAttributeSelection = CType(obj, ProductAttributeSelection)
            Return Me.ItemOrder.CompareTo(fav.ItemOrder)

        End Function

    End Class

    Public Enum ProductAttributeType
        SingleSelection
        MultipleSelection
        UserInput
        'ѡ = 0
        'ѡ = 1
        'û = 2
    End Enum


End Namespace
