Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports System.Data.SqlClient
Imports System.Data.Common
Imports System.Data
Imports System.Collections.Generic
Imports System.Text
Imports NetShopForge.Common

Namespace NetShopForge.Library.Product
    Public Class ProductAttributeTemplateController
        Public Sub UpdateProductAttributeTemplate(ByVal patInfo As ProductAttributeTemplateInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_UpdateProductAttributeTemplate")
            db.AddInParameter(dbCommand, "@ProductAttributeID", DbType.Int32, patInfo.ProductAttributeID)
            db.AddInParameter(dbCommand, "@AttributeName", DbType.String, patInfo.AttributeName)
            db.AddInParameter(dbCommand, "@SelectionList", DbType.String, patInfo.SelectionList)
            db.AddInParameter(dbCommand, "@Description", DbType.String, patInfo.Description)
            db.AddInParameter(dbCommand, "@AttributeType", DbType.String, CInt(patInfo.AttributeType))

            db.ExecuteNonQuery(dbCommand)

        End Sub

        Public Function AddProductAttributeTemplate(ByVal patInfo As ProductAttributeTemplateInfo) As Integer

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_AddProductAttributeTemplate")

            Dim ProductAttributeID As Integer = GetKeys("ProductAttributeID")

            db.AddInParameter(dbCommand, "@ProductAttributeID", DbType.Int32, ProductAttributeID)
            db.AddInParameter(dbCommand, "@AttributeName", DbType.String, patInfo.AttributeName)
            db.AddInParameter(dbCommand, "@SelectionList", DbType.String, patInfo.SelectionList)
            db.AddInParameter(dbCommand, "@Description", DbType.String, patInfo.Description)
            db.AddInParameter(dbCommand, "@AttributeType", DbType.String, CInt(patInfo.AttributeType))

            db.ExecuteNonQuery(dbCommand)
            Return ProductAttributeID

        End Function
        Public Sub DeleteProductAttributeTemplate(ByVal ProductAttributeID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_DeleteProductAttributeTemplate")

            db.AddInParameter(dbCommand, "@ProductAttributeID", DbType.Int32, ProductAttributeID)

            db.ExecuteNonQuery(dbCommand)

        End Sub

        Public Function GetProductAttributeTemplateList() As List(Of ProductAttributeTemplateInfo)
            Dim atList As New List(Of ProductAttributeTemplateInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetProductAttributeTemplateList")
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Dim atT As New ProductAttributeTemplateInfo
                    atT.AttributeName = reader.Item("AttributeName")
                    atT.AttributeType = CInt(reader("AttributeType"))
                    atT.Description = reader.Item("Description")
                    atT.ProductAttributeID = reader.Item("ProductAttributeID")
                    atT.SelectionList = reader.Item("SelectionList")
                    atList.Add(atT)
                End While
            End Using
            Return atList
        End Function

        Public Function GetProductAttributeTemplate(ByVal ProductAttributeID As Integer) As ProductAttributeTemplateInfo
            Dim atT As New ProductAttributeTemplateInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetProductAttributeTemplate")
            db.AddInParameter(dbCommand, "@ProductAttributeID", DbType.Int32, ProductAttributeID)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    atT.AttributeName = reader.Item("AttributeName")
                    atT.AttributeType = CInt(reader("AttributeType"))
                    atT.Description = reader.Item("Description")
                    atT.ProductAttributeID = ProductAttributeID
                    atT.SelectionList = reader.Item("SelectionList")

                End While
            End Using
            Return atT
        End Function

    End Class
End Namespace

