
Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports System.Data.SqlClient
Imports System.Data.Common
Imports System.Data
Imports System.Collections.Generic
Imports System.Text
Imports NetShopForge.Common
Imports NetShopForge.Library.Category

Namespace NetShopForge.Library.Product

    Public Class ProductController


        Public Enum ProductSortType
            ascProductID
            descSale
            descTime
            ascPrice
            descPrice
        End Enum
        Public Shared Sub UpdateProductAttributes(ByVal productID As Integer, ByVal attributeCollecion As ProductAttributeCollection)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_UpdateAttributeXML")

            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productID)
            db.AddInParameter(dbCommand, "@AttributeXML", DbType.String, attributeCollecion.ToXML)

            db.ExecuteNonQuery(dbCommand)

        End Sub
        Public Shared Sub UpdateProductDescriptor(ByVal productDescriptorInfo As ProductDescriptorInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_UpdateProductDescriptor")

            db.AddInParameter(dbCommand, "@DescriptorID", DbType.Int32, productDescriptorInfo.DescriptorID)
            '    db.AddInParameter(dbCommand, "@Title", DbType.String, productDescriptorInfo.Title)
            db.AddInParameter(dbCommand, "@Descriptor", DbType.String, productDescriptorInfo.Descriptor)
            db.AddInParameter(dbCommand, "@IsBulletedList", DbType.Boolean, productDescriptorInfo.IsBulletedList)
            db.AddInParameter(dbCommand, "@ItemOrder ", DbType.Int32, productDescriptorInfo.ItemOrder)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, productDescriptorInfo.IsValid)

            db.ExecuteNonQuery(dbCommand)
        End Sub
        Public Shared Sub UpdateProductLinks(ByVal ProductLinksID As Integer, ByVal linkType As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_UpdateProducLinks")
            db.AddInParameter(dbCommand, "@ProductLinksID ", DbType.Int32, ProductLinksID)
            db.AddInParameter(dbCommand, "@LinkType", DbType.Int32, linkType)
            db.ExecuteNonQuery(dbCommand)

        End Sub


        Public Shared Sub DeleteProductDescriptor(ByVal descriptorID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_DeleteProductDescriptor")

            db.AddInParameter(dbCommand, "@DescriptorID", DbType.Int32, descriptorID)
            db.ExecuteNonQuery(dbCommand)

        End Sub
        Public Shared Sub DeleteProductCategory(ByVal productID As String, ByVal categoryID As Integer)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_DeleteProductCategory")


            db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, categoryID)
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productID)

            db.ExecuteNonQuery(dbCommand)

        End Sub


        Public Shared Function GetProductIDStringByCategoryID(ByVal categoryID As Integer) As String
            Dim Products As New List(Of ProductInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetProductIDByCategoryID")
            Dim pIDs As New StringBuilder
            db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, categoryID)


            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    pIDs.Append(String.Format(",{0}", reader.Item(0).ToString))
                End While
                If pIDs.Length = 0 Then Return ""
                Return pIDs.ToString.Substring(1)
            End Using
        End Function

        Public Shared Function GetProductNormalImagePath(ByVal ProductID As Integer) As String
            Dim pList As New List(Of ProductImageInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetProductImageList")

            db.AddInParameter(dbCommand, "@productID", DbType.Int32, ProductID)
            db.AddInParameter(dbCommand, "Type", DbType.Int32, 0)

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return reader.Item("ImagePath").ToString
                End While
            End Using
            Return ""
        End Function

#Region "-------GetProductList--------"
        Public Shared Function GetProductList() As List(Of ProductInfo)
            Return GetProductList("")

        End Function
        Public Shared Function GetProductList(ByVal sqlWhere As String) As List(Of ProductInfo)
            Return GetProductList(9999999, 1, -2, sqlWhere)
        End Function
        Public Shared Function GetProductList(ByVal pageSize As Integer, ByVal pageIndex As Integer, ByRef totalRecords As Integer) As List(Of ProductInfo)
            Return GetProductList(pageSize, pageIndex, totalRecords, "")
        End Function
        Public Shared Function GetProductList(ByVal pageSize As Integer, ByVal pageIndex As Integer, ByRef totalRecords As Integer, ByVal sqlWhere As String) As List(Of ProductInfo)
            Return GetProductList(pageSize, pageIndex, totalRecords, sqlWhere, True, "ItemOrder")
        End Function
        Public Shared Function GetProductList(ByVal pageSize As Integer, ByVal pageIndex As Integer, ByRef totalRecords As Integer, ByVal CategoryID As Integer) As List(Of ProductInfo)
            Return GetProductList(pageSize, pageIndex, totalRecords, CategoryID, ProductSortType.ascProductID)
        End Function
        Public Shared Function GetProductList(ByVal pageSize As Integer, ByVal pageIndex As Integer, ByRef totalRecords As Integer, ByVal CategoryID As Integer, ByVal productSort As ProductSortType) As List(Of ProductInfo)

            'Dim pIDstring As String = GetProductIDStringByCategoryID(CategoryID)
            'If pIDstring.Length = 0 Then Return Nothing
            'Dim sqlWhereString As String = String.Format("productID IN({0})", pIDstring)

            Dim sqlWhereString As String = String.Format("productID IN(select ProductID from nsf_f_GetProductIDByCategoryID({0}))", CategoryID.ToString)

            Select Case productSort
                Case ProductController.ProductSortType.ascPrice
                    Return GetProductList(pageSize, pageIndex, totalRecords, sqlWhereString, False, "Price")
                Case ProductController.ProductSortType.descPrice
                    Return GetProductList(pageSize, pageIndex, totalRecords, sqlWhereString, True, "Price")
                Case ProductController.ProductSortType.descTime
                    Return GetProductList(pageSize, pageIndex, totalRecords, sqlWhereString, True, "ItemOrder")
                Case ProductController.ProductSortType.descSale
                    Return Nothing
                Case Else
                    Return GetProductList(pageSize, pageIndex, totalRecords, sqlWhereString, False, "ItemOrder")
            End Select

        End Function
        Public Shared Function GetProductList(ByVal pageSize As Integer, ByVal pageIndex As Integer, ByRef totalRecords As Integer, ByVal CategoryID As Integer, ByVal productSort As ProductSortType, ByVal sqlWhere As String) As List(Of ProductInfo)

            If sqlWhere.Trim.Length > 0 Then

                'Dim objCC As New CategoryController
                'Dim pIDstring As String = GetProductIDStringByCategoryID(CategoryID)

                Dim sqlWhereString As String = String.Format("productID IN(select ProductID from nsf_f_GetProductIDByCategoryID({0}))", CategoryID.ToString)

                '  Dim sqlCategoryWhereString As String = String.Format("productID IN({0})", pIDstring)
                Dim sql As String = String.Format("{0} AND {1}", sqlWhereString, sqlWhere)
                Select Case productSort
                    Case ProductController.ProductSortType.ascPrice
                        Return GetProductList(pageSize, pageIndex, totalRecords, sql, False, "Price")
                    Case ProductController.ProductSortType.descPrice
                        Return GetProductList(pageSize, pageIndex, totalRecords, sql, True, "Price")
                    Case ProductController.ProductSortType.descTime
                        Return GetProductList(pageSize, pageIndex, totalRecords, sql, True, "ItemOrder")
                    Case ProductController.ProductSortType.descSale
                        Return Nothing
                    Case Else
                        Return GetProductList(pageSize, pageIndex, totalRecords, sql, False, "ItemOrder")
                End Select
            Else
                Return GetProductList(pageSize, pageIndex, totalRecords, CategoryID, productSort)
            End If
        End Function
        Public Shared Function GetProductList(ByVal pageSize As Integer, ByVal pageIndex As Integer, ByRef totalRecords As Integer, ByVal CategoryID As Integer, ByVal sqlWhere As String) As List(Of ProductInfo)
            Return GetProductList(pageSize, pageIndex, totalRecords, CategoryID, ProductSortType.ascProductID, sqlWhere)
        End Function
        Public Shared Function GetProductList(ByVal pageSize As Integer, ByVal pageIndex As Integer, ByRef totalRecords As Integer, ByVal sqlWhere As String, ByVal isDesc As Boolean, ByVal sortFiled As String) As List(Of ProductInfo)
            Dim Products As New List(Of ProductInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            If totalRecords <> -2 Then
                Dim dbCommand1 As DbCommand = db.GetStoredProcCommand("nsf_Product_GetProductList")
                db.AddInParameter(dbCommand1, "@IsReCount", DbType.Boolean, True)
                db.AddInParameter(dbCommand1, "@fldName", DbType.String, sortFiled)
                db.AddInParameter(dbCommand1, "@OrderType", DbType.Boolean, isDesc)
                If sqlWhere.Trim.Length > 0 Then
                    db.AddInParameter(dbCommand1, "@strWhere", DbType.String, sqlWhere)
                End If
                totalRecords = CInt(db.ExecuteScalar(dbCommand1))
            End If

            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetProductList")
            db.AddInParameter(dbCommand, "@fldName", DbType.String, sortFiled)
            db.AddInParameter(dbCommand, "@PageSize", DbType.Int32, pageSize)
            db.AddInParameter(dbCommand, "@PageIndex", DbType.Int32, pageIndex)
            db.AddInParameter(dbCommand, "@OrderType", DbType.Boolean, isDesc)
            If sqlWhere.Trim.Length > 0 Then
                db.AddInParameter(dbCommand, "@strWhere", DbType.String, sqlWhere)
            End If

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Products.Add(FillProductInfo(reader))
                End While
                Return Products
            End Using

        End Function



#End Region

        Public Shared Function GetProduct(ByVal productID As Integer) As ProductInfo

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetProduct")
            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productID)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillProductInfo(reader)
                End While
                Return Nothing
            End Using

        End Function

        Public Shared Function HasProductOption(ByVal productID As Integer) As Boolean

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetAttributeXML")
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productID)
            Return (db.ExecuteScalar(dbCommand).ToString.Length > 0)
        End Function

        Public Shared Function GetProductFeatureList(ByVal productID As Integer) As List(Of ProductFeatureInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetProductFeature")
            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productID)
            Dim FeatureList As New List(Of ProductFeatureInfo)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    FeatureList.Add(New ProductFeatureInfo(reader.Item("FeatureName"), reader.Item("FeatureValue")))
                End While
                Return FeatureList
            End Using
        End Function

        Public Shared Function GetFeatureProductList(ByVal categoryID As Integer) As List(Of ProductInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetFeatureProducts")
            Dim Products As New List(Of ProductInfo)
            db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, categoryID)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Products.Add(FillProductInfo(reader))
                End While
                Return Products
            End Using
        End Function

        Public Shared Function GetSellWellProductList(ByVal categoryID As Integer) As List(Of ProductInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetSellWellProducts")
            Dim Products As New List(Of ProductInfo)
            db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, categoryID)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Products.Add(FillProductInfo(reader))
                End While
                Return Products
            End Using
        End Function
        Public Shared Function GetNewArrivalProductList(ByVal categoryID As Integer) As List(Of ProductInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetNewArrivalProducts")
            Dim Products As New List(Of ProductInfo)
            db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, categoryID)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Products.Add(FillProductInfo(reader))
                End While
                Return Products
            End Using
        End Function
        Public Shared Function GetSpecialOfferProductList(ByVal categoryID As Integer) As List(Of ProductInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetSpecialOfferProducts")
            Dim Products As New List(Of ProductInfo)
            db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, categoryID)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Products.Add(FillProductInfo(reader))
                End While
                Return Products
            End Using
        End Function
        Public Shared Function GetCommendProductList(ByVal categoryID As Integer) As List(Of ProductInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetCommendProducts")
            Dim Products As New List(Of ProductInfo)
            db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, categoryID)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Products.Add(FillProductInfo(reader))
                End While
                Return Products
            End Using
        End Function


        Public Shared Function GetCategoryIDByProductID(ByVal productID As Integer) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetCategoryID")
            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productID)
            Return db.ExecuteScalar(dbCommand)
        End Function
        'Public Function GetProdutOptionList(ByVal productID As Integer) As List(Of ProductOptionInfo)
        '    Dim db As Database = DatabaseFactory.CreateDatabase
        '    Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetProductOption")
        '    ' Add paramters
        '    ' Input parameters can specify the input value
        '    db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productID)
        '    Dim OptionList As New List(Of ProductOptionInfo)
        '    Using reader As IDataReader = db.ExecuteReader(dbCommand)
        '        While reader.Read
        '            Dim po As New ProductOptionInfo
        '            po.ProductID = productID
        '            po.OptionName = reader.Item("OptionName")
        '            po.SelectText = reader.Item("SelectText")
        '            po.OptionID = reader.Item("OptionID")
        '            po.OptionSelect = GetProductOptionSelect(po.OptionID)
        '            OptionList.Add(po)
        '        End While
        '        Return OptionList
        '    End Using
        'End Function

        Public Shared Function GetProductLinksList(ByVal productID As Integer) As List(Of ProductLiksInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetProductLinksList")

            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productID)
            Dim linksList As New List(Of ProductLiksInfo)

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    linksList.Add(FillProductLinksInfo(reader))
                End While
                Return linksList
            End Using
            Return Nothing

        End Function

  
        Public Shared Function GetProductCategoryList(ByVal productID As Integer) As Generic.List(Of Integer)
            Dim cList As New List(Of Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetProductCategoryList")
            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productID)
            'Dim FeatureList As New List(Of ProductFeatureInfo)

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Dim cID As Integer = reader.Item("CategoryID")
                    cList.Add(cID)
                End While
            End Using
            Return cList
        End Function


        Public Shared Function GetProductRating(ByVal productID As Integer) As ProductRatingInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetProductrating")

            db.AddInParameter(dbCommand, "@productID", DbType.Int32, productID)
            Dim pr As New ProductRatingInfo
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    pr.Rating = reader("Rating")
                    pr.RatingQty = reader("RatingQty")
                    pr.RecommendQty = reader("RecommendQty")

                End While
                Return pr
            End Using

        End Function
        Public Shared Function GetDescriptorList(ByVal productID As Integer) As List(Of ProductDescriptorInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetProductProductDescriptor")
            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productID)

            Dim DescriptorList As New List(Of ProductDescriptorInfo)

            Using reader As IDataReader = db.ExecuteReader(dbCommand)

                While reader.Read
                    DescriptorList.Add(FillProductDescriptorInfo(reader))
                End While
                Return DescriptorList
            End Using
        End Function




        Public Shared Function AddProductLinks(ByVal productLinks As ProductLiksInfo) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Product_AddProductLinks"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)
            Dim linksID As Integer = GetKeys("ProductLinksID")

            db.AddInParameter(dbCommand, "@ProductLinksID ", DbType.Int32, linksID)
            db.AddInParameter(dbCommand, "@ProductAID", DbType.Int32, productLinks.ProductAID)
            db.AddInParameter(dbCommand, "@ProductBID", DbType.Int32, productLinks.ProductBID)
            db.AddInParameter(dbCommand, "@LinkType", DbType.Int32, productLinks.LinkType)
            db.ExecuteNonQuery(dbCommand)
            Return linksID

        End Function

        Public Shared Function AddProductDescriptor(ByVal productDescriptorInfo As ProductDescriptorInfo) As Integer

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_AddProductDescriptor")

            Dim DescriptorID As Integer = GetKeys("DescriptorID")

            db.AddInParameter(dbCommand, "@DescriptorID", DbType.Int32, DescriptorID)
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productDescriptorInfo.ProductID)
            db.AddInParameter(dbCommand, "@Title", DbType.String, productDescriptorInfo.Title)
            db.AddInParameter(dbCommand, "@Descriptor", DbType.String, productDescriptorInfo.Descriptor)
            db.AddInParameter(dbCommand, "@IsBulletedList", DbType.Boolean, productDescriptorInfo.IsBulletedList)
            db.AddInParameter(dbCommand, "@ItemOrder ", DbType.Int32, productDescriptorInfo.ItemOrder)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, productDescriptorInfo.IsValid)

            db.ExecuteNonQuery(dbCommand)
            Return DescriptorID

        End Function
        Public Shared Sub AddProductCategory(ByVal productID As String, ByVal categoryID As Integer)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_AddProductCategory")


            db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, categoryID)
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productID)

            db.ExecuteNonQuery(dbCommand)

        End Sub

        Public Shared Function AddProduct(ByVal product As ProductInfo) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Product_AddProduct"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)
            Dim ProductID As Integer = GetKeys("ProductID")


            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, ProductID)
            db.AddInParameter(dbCommand, "@ProductCode", DbType.String, product.ProductCode)
            db.AddInParameter(dbCommand, "@ProductName", DbType.String, product.ProductName)
            db.AddInParameter(dbCommand, "@ProductType", DbType.Int32, product.ProductType)
            db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, product.CategoryID)
            db.AddInParameter(dbCommand, "@Description", DbType.String, product.Description)
            db.AddInParameter(dbCommand, "@Unit", DbType.String, product.Unit)
            db.AddInParameter(dbCommand, "@Price", DbType.Decimal, product.Price)
            db.AddInParameter(dbCommand, "@ListPrice", DbType.Decimal, product.ListPrice)
            db.AddInParameter(dbCommand, "@StorageQty", DbType.Int32, product.StorageQty)
            db.AddInParameter(dbCommand, "@StorageQtyLimit", DbType.Int32, product.StorageQtyLimit)
            db.AddInParameter(dbCommand, "@MinOrderAmount", DbType.Int32, product.MinOrderAmount)
            db.AddInParameter(dbCommand, "@Weight", DbType.Decimal, product.Weight)
            ' db.AddInParameter(dbCommand, "@AttributeXML", DbType.String, product.AttributeXML)
            db.AddInParameter(dbCommand, "@IsStorageAlert", DbType.Boolean, product.IsStorageAlert)
            db.AddInParameter(dbCommand, "@IsFreeshipping", DbType.Boolean, product.IsFreeshipping)
            db.AddInParameter(dbCommand, "@IsSpecialOffer", DbType.Boolean, product.IsSpecialOffer)
            db.AddInParameter(dbCommand, "@IsSellWell", DbType.Boolean, product.IsSellWell)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, product.IsValid)
            db.AddInParameter(dbCommand, "@IsNewArrival", DbType.Boolean, product.IsNewArrival)
            db.AddInParameter(dbCommand, "@IsGlobalDiscounts", DbType.Boolean, product.IsGlobalDiscounts)
            'db.AddInParameter(dbCommand, "@FeatureGroupID", DbType.Int32, product.FeatureGroupID)
            db.AddInParameter(dbCommand, "@ManufacturerID", DbType.Int32, product.ManufacturerID)
            '    db.AddInParameter(dbCommand, "@ImagePath", DbType.String, product.ImagePath)
            db.AddInParameter(dbCommand, "@IsCommend", DbType.Boolean, product.IsCommend)

            db.AddInParameter(dbCommand, "@ShopID", DbType.Int32, product.ShopID)
            db.AddInParameter(dbCommand, "@agencyFee", DbType.Decimal, product.AgencyFee)
            db.AddInParameter(dbCommand, "@InternalShippingFee", DbType.Decimal, product.InternalShippingFee)
            db.AddInParameter(dbCommand, "@InternationalShippingFee", DbType.Decimal, product.internationalShippingFee)

            db.AddInParameter(dbCommand, "@CurrencyID", DbType.Int32, product.CurrencyID)
            db.AddInParameter(dbCommand, "@ProductURL", DbType.String, product.ProductURL)
            db.ExecuteNonQuery(dbCommand)

            Return ProductID

        End Function


        Public Shared Function UpdateProduct(ByVal product As ProductInfo) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Product_UpdateProduct"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, product.ProductID)
            db.AddInParameter(dbCommand, "@ProductCode", DbType.String, product.ProductCode)
            db.AddInParameter(dbCommand, "@ProductName", DbType.String, product.ProductName)
            db.AddInParameter(dbCommand, "@ProductType", DbType.Int32, product.ProductType)
            db.AddInParameter(dbCommand, "@CategoryID", DbType.String, product.CategoryID)
            db.AddInParameter(dbCommand, "@Description", DbType.String, product.Description)
            db.AddInParameter(dbCommand, "@Unit", DbType.String, product.Unit)
            db.AddInParameter(dbCommand, "@Price", DbType.Decimal, product.Price)
            db.AddInParameter(dbCommand, "@ListPrice", DbType.Decimal, product.ListPrice)
            db.AddInParameter(dbCommand, "@StorageQty", DbType.Int32, product.StorageQty)
            db.AddInParameter(dbCommand, "@StorageQtyLimit", DbType.Int32, product.StorageQtyLimit)
            db.AddInParameter(dbCommand, "@MinOrderAmount", DbType.Int32, product.MinOrderAmount)
            db.AddInParameter(dbCommand, "@Weight", DbType.Decimal, product.Weight)
            ' db.AddInParameter(dbCommand, "@AttributeXML", DbType.String, product.AttributeXML)
            db.AddInParameter(dbCommand, "@IsStorageAlert", DbType.Boolean, product.IsStorageAlert)
            db.AddInParameter(dbCommand, "@IsFreeshipping", DbType.Boolean, product.IsFreeshipping)
            db.AddInParameter(dbCommand, "@IsSpecialOffer", DbType.Boolean, product.IsSpecialOffer)
            db.AddInParameter(dbCommand, "@IsSellWell", DbType.Boolean, product.IsSellWell)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, product.IsValid)
            db.AddInParameter(dbCommand, "@IsNewArrival", DbType.Boolean, product.IsNewArrival)
            db.AddInParameter(dbCommand, "@IsGlobalDiscounts", DbType.Boolean, product.IsGlobalDiscounts)
            db.AddInParameter(dbCommand, "@FeatureGroupID", DbType.Int32, product.FeatureGroupID)
            db.AddInParameter(dbCommand, "@ManufacturerID", DbType.Int32, product.ManufacturerID)
            ' db.AddInParameter(dbCommand, "@ImagePath", DbType.String, product.ImagePath)
            db.AddInParameter(dbCommand, "@IsCommend", DbType.Boolean, product.IsCommend)


            db.AddInParameter(dbCommand, "@ShopID", DbType.Int32, product.ShopID)
            db.AddInParameter(dbCommand, "@agencyFee", DbType.Decimal, product.AgencyFee)
            db.AddInParameter(dbCommand, "@InternalShippingFee", DbType.Decimal, product.InternalShippingFee)
            db.AddInParameter(dbCommand, "@InternationalShippingFee", DbType.Decimal, product.internationalShippingFee)
            db.AddInParameter(dbCommand, "@CurrencyID", DbType.Int32, product.CurrencyID)
            db.AddInParameter(dbCommand, "@ProductURL", DbType.String, product.ProductURL)
            db.ExecuteNonQuery(dbCommand)

        End Function
        Public Shared Sub DeleteProduct(ByVal productID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Product_DeleteProduct"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productID)
            db.ExecuteNonQuery(dbCommand)
            Dim pic As New ProductImageController
            pic.DeleteProductImage(productID, True)

        End Sub



        Public Shared Sub DeleteProductLinks(ByVal productLinksID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Product_DeleteProductLinks"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@productLinksID", DbType.Int32, productLinksID)
            db.ExecuteNonQuery(dbCommand)


        End Sub
        Public Shared Sub UpdataProductQuick(ByVal productID As Integer, ByVal isSpecialOffer As Boolean, ByVal isSellWell As Boolean, ByVal isValid As Boolean, ByVal isNewArrival As Boolean, ByVal isCommend As Boolean, ByVal ItemOrder As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Product_UpdateProductQuick"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productID)
            'db.AddInParameter(dbCommand, "@Price", DbType.Decimal, price)
            'db.AddInParameter(dbCommand, "@StorageQty", DbType.Int32, storageQty)
            db.AddInParameter(dbCommand, "@IsSpecialOffer", DbType.Boolean, isSpecialOffer)
            db.AddInParameter(dbCommand, "@IsSellWell", DbType.Boolean, isSellWell)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, isValid)
            db.AddInParameter(dbCommand, "@IsNewArrival", DbType.Boolean, isNewArrival)
            db.AddInParameter(dbCommand, "@IsCommend", DbType.Boolean, isCommend)
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, ItemOrder)
            ' Output parameters specify the size of the return data
            db.ExecuteNonQuery(dbCommand)

        End Sub







#Region "---Private Method---"

        Private Shared Function FillProductInfo(ByVal dr As IDataReader) As ProductInfo

            Dim objProduct As New ProductInfo

            objProduct.ProductID = dr.Item("ProductID")
            objProduct.ProductCode = dr.Item("ProductCode")
            objProduct.ProductName = dr.Item("ProductName")
            objProduct.CategoryID = dr.Item("CategoryID")
            objProduct.Description = dr.Item("Description")
            objProduct.Unit = dr.Item("Unit")
            objProduct.Price = dr.Item("Price")
            objProduct.ListPrice = dr.Item("ListPrice")
            objProduct.StorageQty = dr.Item("StorageQty")
            objProduct.StorageQtyLimit = dr.Item("StorageQtyLimit")
            objProduct.MinOrderAmount = dr.Item("MinOrderAmount")
            objProduct.IsFreeshipping = dr.Item("IsFreeshipping")
            objProduct.IsSpecialOffer = dr.Item("IsSpecialOffer")
            objProduct.IsStorageAlert = dr.Item("IsStorageAlert")
            objProduct.IsSellWell = dr.Item("IsSellWell")
            objProduct.IsValid = dr.Item("IsValid")
            objProduct.IsGlobalDiscounts = dr.Item("IsGlobalDiscounts")
            objProduct.ImagePath = dr.Item("ImagePath")
            objProduct.AttributeXML = dr.Item("AttributeXML")
            objProduct.IsNewArrival = dr.Item("IsNewArrival")
            objProduct.IsStorageAlert = dr.Item("IsStorageAlert")
            objProduct.ProductType = CInt(dr.Item("ProductType"))
            objProduct.ManufacturerID = dr.Item("ManufacturerID")
            objProduct.IsCommend = dr.Item("IsCommend")
            objProduct.ItemOrder = dr.Item("ItemOrder")
            objProduct.ShopID = dr.Item("ShopID")
            objProduct.AgencyFee = dr.Item("agencyFee")
            objProduct.InternalShippingFee = dr.Item("InternalShippingFee")
            objProduct.internationalShippingFee = dr.Item("InternationalShippingFee")
            objProduct.CurrencyID = dr.Item("CurrencyID")
            objProduct.ProductURL = dr.Item("ProductURL")

            Return objProduct

        End Function



        Private Shared Function FillProductDescriptorInfo(ByVal reader As IDataReader) As ProductDescriptorInfo
            Dim desprictor As New ProductDescriptorInfo

            desprictor.ProductID = CInt(reader("productID"))
            desprictor.DescriptorID = CInt(reader("DescriptorID"))
            desprictor.Descriptor = reader("Descriptor").ToString
            desprictor.IsBulletedList = CBool(reader("IsBulletedList"))
            desprictor.IsValid = CBool(reader("IsValid"))
            desprictor.ItemOrder = CInt(reader("ItemOrder"))
            desprictor.Title = reader("Title").ToString

            Return desprictor


        End Function


        Private Shared Function FillProductLinksInfo(ByVal reader As IDataReader) As ProductLiksInfo
            Dim links As New ProductLiksInfo

            links.ProductLinksID = CInt(reader("ProductLinksID").ToString)
            links.LinkType = CInt(reader("LinkType"))
            links.ProductID = CInt(reader("ProductID"))
            links.ProductName = reader("ProductName")
            links.ImagePath = reader("ImagePath")
            links.Price = reader("Price")
            Return links

        End Function

#End Region


    End Class
End Namespace