Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports System.Data.SqlClient
Imports System.Data.Common
Imports System.Data
Imports System.Collections.Generic
Imports System.Text
Imports NetShopForge.Common
Imports NetShopForge.Library.Category
Imports System.IO
Imports System.Web
Imports System.Net
Imports System.Web.UI


Namespace NetShopForge.Library.Product

    Public Class ProductImageController


        Public Function GetProductImageList(ByVal productID As Integer, ByVal type As ProductImageType) As List(Of ProductImageInfo)

            Dim pList As New List(Of ProductImageInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetProductImageList")

            db.AddInParameter(dbCommand, "@productID", DbType.Int32, productID)
            db.AddInParameter(dbCommand, "Type", DbType.Int32, CInt(type))

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    pList.Add(FillProductImageInfo(reader))
                End While
                Return pList
            End Using
        End Function
        Public Function GetProductImageList(ByVal productID As Integer)
            Return GetProductImageList(productID, -1)
        End Function

        Public Function AddProductImage(ByVal productImage As ProductImageInfo) As Integer

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_AddProductImage")

            Dim ProductImageID As Integer = GetKeys("ProductImageID")

            db.AddInParameter(dbCommand, "@ProductImageID", DbType.Int32, ProductImageID)
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productImage.ProductID)
            db.AddInParameter(dbCommand, "@Caption", DbType.String, productImage.Caption)
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, productImage.ItemOrder)
            db.AddInParameter(dbCommand, "@Type", DbType.Int32, CInt(productImage.Type))
            db.AddInParameter(dbCommand, "@ImagePath ", DbType.String, productImage.ImagePath)

            db.ExecuteNonQuery(dbCommand)
            Return ProductImageID
        End Function

        Public Sub UpdateImagepath(ByVal productID As Integer, ByVal imagePath As String)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_UpdateImagepath")



            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productID)
            db.AddInParameter(dbCommand, "@ImagePath ", DbType.String, imagePath)
            db.ExecuteNonQuery(dbCommand)

        End Sub

        Public Sub DeleteProductImage(ByVal productImageID As Integer)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_DeleteProductImage")

            db.AddInParameter(dbCommand, "@ProductImageID", DbType.Int32, productImageID)
            db.ExecuteNonQuery(dbCommand)
        End Sub


        Public Sub DeleteProductImage(ByVal productID As Integer, ByVal IncludePhysicalfile As Boolean)
            Dim piList As List(Of ProductImageInfo) = GetProductImageList(productID)

            Dim pi As ProductImageInfo
            For Each pi In piList
                DeleteProductImage(pi.ProductImageID)
                If IncludePhysicalfile Then
                    Dim savePath As String = HttpContext.Current.Request.PhysicalApplicationPath

                    Dim fileName As String = savePath & pi.ImagePath.Replace("/", "\")
                    If File.Exists(fileName) Then File.Delete(fileName)
                End If
            Next
        End Sub


        Private Function FillProductImageInfo(ByVal dr As IDataReader) As ProductImageInfo

            Dim objP As New ProductImageInfo

            objP.ProductID = dr.Item("ProductID")
            objP.ImagePath = dr.Item("ImagePath")
            objP.ProductImageID = dr.Item("ProductImageID")
            objP.Caption = dr.Item("Caption")
            objP.Type = CInt(dr.Item("Type"))
            Return objP

        End Function

    End Class

End Namespace

