Imports Microsoft.VisualBasic
Imports NetShopForge.Common
Namespace NetShopForge.Library.Product

    <Serializable()> _
    Public Class ProductInfo
        Public Sub New()

        End Sub

        Private _productid As Integer
        Private _productcode As String
        Private _productname As String
        Private _categoryid As Integer
        Private _description As String
        Private _unit As String
        Private _price As Decimal
        Private _listprice As Decimal
        Private _storageqty As Integer
        Private _storageqtylimit As Integer
        Private _minorderamount As Integer
        Private _weight As Decimal
        Private _isfreeshipping As Boolean
        Private _isspecialoffer As Boolean
        Private _issellwell As Boolean
        Private _isvalid As Boolean
        Private _isNewArrival As Boolean
        Private _IsStorageAlert As Boolean
        Private _isglobaldiscounts As Boolean
        Private _featuregroupid As Integer
        Private _optiongroupid As Integer
        Private _Brandid As Integer
        Private _imagepath As String
        Private _AttributeXML As String
        Private _ProductAttributeCollection As ProductAttributeCollection
        Private _productType As ProductType
        Private _ManufacturerID As Integer
        Private _IsCommend As Boolean
        Private _ItemOrder As Integer


        Private _shopID As Integer
        Private _agencyFee As Decimal
        Private _InternalShippingFee As Decimal
        Private _internationalShippingFee As Decimal
        Private _ProductURL As String
        Private _CurrencyID As Integer



        Public Property ProductID() As Integer
            Get
                Return _productid
            End Get
            Set(ByVal Value As Integer)
                _productid = Value
            End Set
        End Property

        Public Property ItemOrder() As Integer
            Get
                Return _ItemOrder
            End Get
            Set(ByVal Value As Integer)
                _ItemOrder = Value
            End Set
        End Property

        Public Property ProductCode() As String
            Get
                Return _productcode
            End Get
            Set(ByVal Value As String)
                _productcode = Value
            End Set
        End Property



        Public Property ProductName() As String
            Get
                Return _productname
            End Get
            Set(ByVal Value As String)
                _productname = Value
            End Set
        End Property



        Public Property CategoryID() As Integer
            Get
                Return _categoryid
            End Get
            Set(ByVal Value As Integer)
                _categoryid = Value
            End Set
        End Property



        Public Property Description() As String
            Get
                Return _description
            End Get
            Set(ByVal Value As String)
                _description = Value
            End Set
        End Property




        Public Property Unit() As String
            Get
                Return _unit
            End Get
            Set(ByVal Value As String)
                _unit = Value
            End Set
        End Property



        Public Property Price() As Decimal
            Get
                Return _price
            End Get
            Set(ByVal Value As Decimal)
                _price = Value
            End Set
        End Property



        Public Property ListPrice() As Decimal
            Get
                Return _listprice
            End Get
            Set(ByVal Value As Decimal)
                _listprice = Value
            End Set
        End Property



        Public Property StorageQty() As Integer
            Get
                Return _storageqty
            End Get
            Set(ByVal Value As Integer)
                _storageqty = Value
            End Set
        End Property



        Public Property StorageQtyLimit() As Integer
            Get
                Return _storageqtylimit
            End Get
            Set(ByVal Value As Integer)
                _storageqtylimit = Value
            End Set
        End Property



        Public Property MinOrderAmount() As Integer
            Get
                Return _minorderamount
            End Get
            Set(ByVal Value As Integer)
                _minorderamount = Value
            End Set
        End Property



        Public Property Weight() As Decimal
            Get
                Return _weight
            End Get
            Set(ByVal Value As Decimal)
                _weight = Value
            End Set
        End Property



        Public Property IsFreeshipping() As Boolean
            Get
                Return _isfreeshipping
            End Get
            Set(ByVal Value As Boolean)
                _isfreeshipping = Value
            End Set
        End Property



        Public Property IsSpecialOffer() As Boolean
            Get
                Return _isspecialoffer
            End Get
            Set(ByVal Value As Boolean)
                _isspecialoffer = Value
            End Set
        End Property



        Public Property IsSellWell() As Boolean
            Get
                Return _issellwell
            End Get
            Set(ByVal Value As Boolean)
                _issellwell = Value
            End Set
        End Property



        Public Property IsValid() As Boolean
            Get
                Return _isvalid
            End Get
            Set(ByVal Value As Boolean)
                _isvalid = Value
            End Set
        End Property



        Public Property IsGlobalDiscounts() As Boolean
            Get
                Return _isglobaldiscounts
            End Get
            Set(ByVal Value As Boolean)
                _isglobaldiscounts = Value
            End Set
        End Property



        Public Property IsNewArrival() As Boolean
            Get
                Return _isNewArrival
            End Get
            Set(ByVal Value As Boolean)
                _isNewArrival = Value
            End Set
        End Property


        Public Property IsCommend() As Boolean
            Get
                Return _IsCommend
            End Get
            Set(ByVal Value As Boolean)
                _IsCommend = Value
            End Set
        End Property

        Public Property IsStorageAlert() As Boolean
            Get
                Return _IsStorageAlert
            End Get
            Set(ByVal Value As Boolean)
                _IsStorageAlert = Value
            End Set
        End Property



        Public Property FeatureGroupID() As Integer
            Get
                Return _featuregroupid
            End Get
            Set(ByVal Value As Integer)
                _featuregroupid = Value
            End Set
        End Property



        Public Property OptionGroupID() As Integer
            Get
                Return _optiongroupid
            End Get
            Set(ByVal Value As Integer)
                _optiongroupid = Value
            End Set
        End Property



        Public Property BrandID() As Integer
            Get
                Return _Brandid
            End Get
            Set(ByVal Value As Integer)
                _Brandid = Value
            End Set
        End Property



        Public Property ImagePath() As String
            Get
                Return _imagepath
            End Get
            Set(ByVal Value As String)
                _imagepath = Value
            End Set
        End Property


        Public ReadOnly Property NormalImagePath() As String
            Get
                Return ProductController.GetProductNormalImagePath(_productid)
            End Get
        End Property


        Public Property AttributeXML() As String
            Get
                Return _AttributeXML
            End Get
            Set(ByVal value As String)
                _AttributeXML = value
            End Set
        End Property


        Public Property ProductAttributeCollection() As ProductAttributeCollection
            Get
                _ProductAttributeCollection = CType(Utility.XmlToObject(GetType(ProductAttributeCollection), Me.AttributeXML), ProductAttributeCollection)
                Return _ProductAttributeCollection
            End Get
            Set(ByVal value As ProductAttributeCollection)
                _ProductAttributeCollection = value
                Me.AttributeXML = Utility.ObjectToXML(GetType(ProductAttributeCollection), _ProductAttributeCollection)
            End Set
        End Property


        Public Property ProductType()
            Get
                Return _productType
            End Get
            Set(ByVal value)
                _productType = value
            End Set
        End Property


        Public Property ManufacturerID() As Integer
            Get
                Return _ManufacturerID
            End Get
            Set(ByVal value As Integer)
                _ManufacturerID = value
            End Set
        End Property

        Public Property ShopID() As Integer
            Get
                Return _shopID
            End Get
            Set(ByVal value As Integer)
                _shopID = value
            End Set
        End Property

        Public Property AgencyFee() As Decimal
            Get
                Return _agencyFee
            End Get
            Set(ByVal value As Decimal)
                _agencyFee = value
            End Set
        End Property

        Public Property InternalShippingFee() As Decimal
            Get
                Return _InternalShippingFee
            End Get
            Set(ByVal value As Decimal)
                _InternalShippingFee = value
            End Set
        End Property

        Public Property internationalShippingFee() As Decimal
            Get
                Return _internationalShippingFee
            End Get
            Set(ByVal value As Decimal)
                _internationalShippingFee = value
            End Set
        End Property


        Public Property CurrencyID() As Integer
            Get
                Return _CurrencyID
            End Get
            Set(ByVal value As Integer)
                _CurrencyID = value
            End Set
        End Property

        Public Property ProductURL() As String
            Get
                Return _ProductURL
            End Get
            Set(ByVal value As String)
                _ProductURL = value
            End Set
        End Property

    End Class


    Public Enum ProductType
        NormalProduct = 0
        VirtualProduct = 1
        DigitalFileProduct = 2
    End Enum
End Namespace