
Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports System.Data.SqlClient
Imports System.Data.Common
Imports System.Data
Imports System.Collections.Generic
Imports System.Text
Imports NetShopForge.Common
Imports NetShopForge.Library.Category

Namespace NetShopForge.Library.Product
    Public Class ProductReviewController
        Public Shared Function AddProductReview(ByVal productReview As ProductReviewInfo) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Product_AddProductReview"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)
            Dim ReviewID As Integer = GetKeys("ReviewID")

            db.AddInParameter(dbCommand, "@ReviewID", DbType.Int32, ReviewID)
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productReview.ProductID)
            db.AddInParameter(dbCommand, "@UserID", DbType.String, productReview.UserID)
            db.AddInParameter(dbCommand, "@ReviewerName", DbType.String, productReview.ReviewerName)
            db.AddInParameter(dbCommand, "@Location", DbType.String, productReview.Location)
            db.AddInParameter(dbCommand, "@Rating", DbType.String, productReview.Rating)
            db.AddInParameter(dbCommand, "@Title", DbType.String, productReview.Title)
            db.AddInParameter(dbCommand, "@Comments", DbType.String, productReview.Comments)
            db.AddInParameter(dbCommand, "@IsRecommend", DbType.Boolean, productReview.IsRecommend)
            db.AddInParameter(dbCommand, "@IsApproved", DbType.Boolean, productReview.IsApproved)
            db.ExecuteNonQuery(dbCommand)
            Return ReviewID

        End Function

        Public Shared Function GetProductReviewList(ByVal pageSize As Integer, ByVal pageIndex As Integer, ByRef totalRecords As Integer, ByVal sqlWhere As String) As List(Of ProductReviewInfo)
            Return GetProductReviewList(pageSize, pageIndex, totalRecords, sqlWhere, True, "ReviewID")
        End Function

        Public Shared Function GetProductReviewList(ByVal pageSize As Integer, ByVal pageIndex As Integer, ByRef totalRecords As Integer, ByVal sqlWhere As String, ByVal isDesc As Boolean, ByVal sortFiled As String) As List(Of ProductReviewInfo)

            Dim ReviewList As New List(Of ProductReviewInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            If totalRecords <> -2 Then
                Dim dbCommand1 As DbCommand = db.GetStoredProcCommand("nsf_Product_GetProductReviewList")
                db.AddInParameter(dbCommand1, "@IsReCount", DbType.Boolean, True)
                db.AddInParameter(dbCommand1, "@fldName", DbType.String, sortFiled)
                db.AddInParameter(dbCommand1, "@OrderType", DbType.Boolean, isDesc)
                If sqlWhere.Trim.Length > 0 Then
                    db.AddInParameter(dbCommand1, "@strWhere", DbType.String, sqlWhere)
                End If

                totalRecords = CInt(db.ExecuteScalar(dbCommand1))
            End If

            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetProductReviewList")
            db.AddInParameter(dbCommand, "@fldName", DbType.String, sortFiled)
            db.AddInParameter(dbCommand, "@PageSize", DbType.Int32, pageSize)
            db.AddInParameter(dbCommand, "@PageIndex", DbType.Int32, pageIndex)
            db.AddInParameter(dbCommand, "@OrderType", DbType.Boolean, isDesc)
            If sqlWhere.Trim.Length > 0 Then
                db.AddInParameter(dbCommand, "@strWhere", DbType.String, sqlWhere)
            End If

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    ReviewList.Add(FillProductReviewInfo(reader))
                End While
                Return ReviewList
            End Using


        End Function




        Public Shared Function GetProductReview(ByVal productID As Integer, ByVal UserID As String) As ProductReviewInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetProductReview")

            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productID)
            db.AddInParameter(dbCommand, "@UserID", DbType.String, UserID)
            Dim ReviewList As New List(Of ProductReviewInfo)

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillProductReviewInfo(reader)
                End While
            End Using
            Return Nothing
        End Function

        Public Shared Sub UpdateProductReview(ByVal reviewID As Integer, ByVal IsApproved As Boolean)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_UpdateProductReview")

            db.AddInParameter(dbCommand, "@ReviewID", DbType.Int32, reviewID)
            db.AddInParameter(dbCommand, "@IsApproved", DbType.Boolean, IsApproved)

            db.ExecuteNonQuery(dbCommand)

        End Sub


        Public Shared Sub UpdateProductReview(ByVal reviewID As Integer, ByVal IsApproved As Boolean, ByVal feedBack As String)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_UpdateProductReview")

            db.AddInParameter(dbCommand, "@ReviewID", DbType.Int32, reviewID)
            db.AddInParameter(dbCommand, "@FeedBack", DbType.String, feedBack.Replace("'", "''"))
            db.AddInParameter(dbCommand, "@IsApproved", DbType.Boolean, IsApproved)

            db.ExecuteNonQuery(dbCommand)

        End Sub


        Public Shared Sub DeleteProductReview(ByVal reviewID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_DeleteProductReview")

            db.AddInParameter(dbCommand, "@ReviewID", DbType.Int32, reviewID)

            db.ExecuteNonQuery(dbCommand)

        End Sub

        Public Shared Function GetProductReview(ByVal reviewID As Integer) As ProductReviewInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Product_GetProductReviewByID")

            db.AddInParameter(dbCommand, "@reviewID", DbType.Int32, reviewID)
            Dim ReviewList As New List(Of ProductReviewInfo)

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillProductReviewInfo(reader)
                End While
            End Using
            Return Nothing
        End Function

        Private Shared Function FillProductReviewInfo(ByVal reader As IDataReader) As ProductReviewInfo

            Dim review As New ProductReviewInfo
            review.ProductID = reader("productID")
            review.ReviewDate = CDate(reader("ReviewDate"))
            review.ReviewerName = reader("ReviewerName")
            review.ReviewID = reader("ReviewID")
            review.Title = reader("Title")
            ' review.UserID = reader("UserID")

            review.Location = reader("Location")
            review.Rating = CDbl(reader("rating"))
            review.Comments = reader("Comments")
            review.IsRecommend = CBool(reader("IsRecommend"))
            review.IsApproved = CBool(reader("IsApproved"))
            review.FeedBack = reader.Item("FeedBack")
            review.ProductName = reader.Item("ProductName")
            Return review

        End Function
    End Class

End Namespace

