Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports System.Data.SqlClient
Imports System.Data.Common
Imports System.Data
Imports System.Collections.Generic
Imports System.Text
Imports NetShopForge.Common.Globals

Namespace NetShopForge.Library.Role

    Public Class RoleController

        Public Function GetRoleList(ByVal roleType As RoleType) As List(Of RoleInfo)
            Dim objRIList As New List(Of RoleInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase

            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Role_GetRoleList")
            db.AddInParameter(dbCommand, "@RoleType", DbType.Int32, roleType)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    objRIList.Add(FillRoleInfo(reader))
                End While
                Return objRIList
            End Using

        End Function

        Public Function AddRole(ByVal roleName As String, ByVal roletype As RoleType) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Role_AddRole"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            Dim RoleID As Integer = GetKeys("RoleID")

            db.AddInParameter(dbCommand, "@RoleID", DbType.Int32, RoleID)
            db.AddInParameter(dbCommand, "@RoleName", DbType.String, RoleName)
            db.AddInParameter(dbCommand, "@RoleType", DbType.Int32, CInt(roletype))

            db.ExecuteNonQuery(dbCommand)
            Return RoleID

        End Function

        Public Sub DeleteRole(ByVal roleID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Role_DeleteRole"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@RoleID", DbType.Int32, RoleID)
            db.ExecuteNonQuery(dbCommand)

        End Sub

        Public Sub UpdateRole(ByVal roleID As Integer, ByVal roleName As String)

            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Role_UpdateRole"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@RoleID", DbType.Int32, RoleID)
            db.AddInParameter(dbCommand, "@RoleName", DbType.String, roleName)

            db.ExecuteNonQuery(dbCommand)

        End Sub


        Private Function FillRoleInfo(ByVal dr As IDataReader) As RoleInfo

            Dim objRI As New RoleInfo

            objRI.RoleID = CInt(dr.Item("RoleID"))
            objRI.RoleName = dr.Item("RoleName")
            objRI.RoleType = CType(dr.Item("RoleType"), RoleType)
            Return objRI

        End Function

    End Class

End Namespace

