
#Region "Imports "

Imports System
Imports System.Xml
Imports System.Configuration
Imports System.Reflection
Imports System.Web
Imports System.ComponentModel
#End Region

Namespace NetShopForge.Common

    Public Class ShopSetting

        Public Sub New()
            Load()
        End Sub


        Private Shared _Instance As ShopSetting
        Public Shared ReadOnly Property Instance() As ShopSetting
            Get
                If IsNothing(_Instance) Then _Instance = New ShopSetting
                Return _Instance
            End Get
        End Property

#Region "Property"
  
        Private _ShopName As String
        Public Property ShopName() As String
            Get
                Return _ShopName
            End Get
            Set(ByVal value As String)
                _ShopName = value
            End Set
        End Property

        Private _CompayName_ As String
        Public Property CompanyName() As String
            Get
                Return _CompayName_
            End Get
            Set(ByVal value As String)
                _CompayName_ = value
            End Set
        End Property
        Private _WebSiteURL As String
        Public Property WebSiteURL() As String
            Get
                Return _WebSiteURL
            End Get
            Set(ByVal value As String)
                _WebSiteURL = value
            End Set
        End Property

        Private _WebsiteTitle As String
        Public Property WebsiteTitle() As String
            Get
                Return _WebsiteTitle
            End Get
            Set(ByVal value As String)
                _WebsiteTitle = value
            End Set
        End Property
        Private _LinkPerson As String
        Public Property LinkPerson() As String
            Get
                Return _LinkPerson
            End Get
            Set(ByVal value As String)
                _LinkPerson = value
            End Set
        End Property
        Private _Telphone As Integer
        Public Property Telphone() As Integer
            Get
                Return _Telphone
            End Get
            Set(ByVal value As Integer)
                _Telphone = value
            End Set
        End Property

        Private _MobilePhone As String
        Public Property MobilePhone() As String
            Get
                Return _MobilePhone
            End Get
            Set(ByVal value As String)
                _MobilePhone = value
            End Set
        End Property

        Private _Email As String
        Public Property Email() As String
            Get
                Return _Email
            End Get
            Set(ByVal value As String)
                _Email = value
            End Set
        End Property

        Private _PostCode As String
        Public Property PostCode() As String
            Get
                Return _PostCode
            End Get
            Set(ByVal value As String)
                _PostCode = value
            End Set
        End Property

        Private _Address As String
        Public Property Address() As String
            Get
                Return _Address
            End Get
            Set(ByVal value As String)
                _Address = value
            End Set
        End Property

        Private _SpecialPrice_Display As Integer
        Public Property SpecialPrice_Display() As Integer
            Get
                Return _SpecialPrice_Display
            End Get
            Set(ByVal value As Integer)
                _SpecialPrice_Display = value
            End Set
        End Property

        Private _FeatureProduct_Display As Integer
        Public Property FeatureProduct_Display() As Integer
            Get
                Return _FeatureProduct_Display
            End Get
            Set(ByVal value As Integer)
                _FeatureProduct_Display = value
            End Set
        End Property

        Private _Product_Search_Results_Per_Page_Display As Integer
        Public Property Product_Search_Results_Per_Page_Display() As Integer
            Get
                Return _Product_Search_Results_Per_Page_Display
            End Get
            Set(ByVal value As Integer)
                _Product_Search_Results_Per_Page_Display = value
            End Set
        End Property
        Private _HotSale_Display As Integer
        Public Property HotSale_Display() As Integer
            Get
                Return _HotSale_Display
            End Get
            Set(ByVal value As Integer)
                _HotSale_Display = value
            End Set
        End Property
        Private _NewProduct_Display As Integer
        Public Property NewProduct_Display() As Integer
            Get
                Return _NewProduct_Display
            End Get
            Set(ByVal value As Integer)
                _NewProduct_Display = value
            End Set
        End Property
        Private _ThumbnailImage_Width As Integer
        Public Property ThumbnailImage_Width() As Integer
            Get
                Return _ThumbnailImage_Width
            End Get
            Set(ByVal value As Integer)
                _ThumbnailImage_Width = value
            End Set
        End Property

        Private _ThumbnailImage_Height As Integer
        Public Property ThumbnailImage_Height() As Integer
            Get
                Return _ThumbnailImage_Height
            End Get
            Set(ByVal value As Integer)
                _ThumbnailImage_Height = value
            End Set
        End Property

        Private _LargeImage_Width As Integer
        Public Property LargeImage_Width() As Integer
            Get
                Return _LargeImage_Width
            End Get
            Set(ByVal value As Integer)
                _LargeImage_Width = value
            End Set
        End Property

        Private _LargeImage_Height As Integer
        Public Property LargeImage_Height() As Integer
            Get
                Return _LargeImage_Height
            End Get
            Set(ByVal value As Integer)
                _LargeImage_Height = value
            End Set
        End Property
        Private _ThumbnailImage_Default As String
        Public Property ThumbnailImage_Default() As String
            Get
                Return _ThumbnailImage_Default
            End Get
            Set(ByVal value As String)
                _ThumbnailImage_Default = value
            End Set
        End Property

        Private _LargeImage_Default As String
        Public Property LargeImage_Default() As String
            Get
                Return _LargeImage_Default
            End Get
            Set(ByVal value As String)
                _LargeImage_Default = value
            End Set
        End Property

        Private _META_DESCRIPTION As String
        Public Property META_DESCRIPTION() As String
            Get
                Return _META_DESCRIPTION
            End Get
            Set(ByVal value As String)
                _META_DESCRIPTION = value
            End Set
        End Property

        Private _META_KEYWORDS As String
        Public Property META_KEYWORDS() As String
            Get
                Return _META_KEYWORDS
            End Get
            Set(ByVal value As String)
                _META_KEYWORDS = value
            End Set
        End Property
#End Region
#Region "Method"
        Private Sub Load()

            Dim fileName As String = HttpContext.Current.Server.MapPath(ConfigurationManager.AppSettings("SettingsFile"))
            Dim type As Type = Me.GetType()
            Dim doc As New XmlDocument()
            doc.Load(fileName)

            Dim node As XmlNode
            For Each node In doc.SelectSingleNode("settings").ChildNodes
                Dim name As String = node.Name
                Dim value As String = node.InnerText

                Dim info As PropertyInfo
                For Each info In type.GetProperties()



                    If info.Name.Equals(name, StringComparison.OrdinalIgnoreCase) Then

                        Select Case info.PropertyType.ToString()
                            Case "System.String"
                                info.SetValue(Me, value, Nothing)
                            Case "System.Int32"
                                info.SetValue(Me, Integer.Parse(value), Nothing)
                            Case "System.DateTime"
                                info.SetValue(Me, DateTime.Parse(value), Nothing)
                            Case "System.Double"
                                info.SetValue(Me, Double.Parse(value), Nothing)
                            Case "System.Int64"
                                info.SetValue(Me, Long.Parse(value), Nothing)
                            Case "System.Boolean"
                                info.SetValue(Me, Boolean.Parse(value), Nothing)
                            Case Else
                                Throw New InvalidCastException("The BlogSettings does not allow properties of type '" & info.PropertyType.ToString & "'")
                        End Select

                        Exit For
                    End If
                Next info
            Next node
        End Sub 'Load
        Public Sub Save()
            Dim fileName As String = HttpContext.Current.Server.MapPath(ConfigurationManager.AppSettings("SettingsFile"))
            Dim type As Type = Me.GetType()
            Dim settings As New XmlWriterSettings()
            settings.Indent = True

            Using writer As XmlWriter = XmlWriter.Create(fileName, settings)
                writer.WriteStartElement("settings")

                Dim info As PropertyInfo
                For Each info In type.GetProperties()
                    If info.Name <> "Instance" Then
                        writer.WriteElementString(info.Name, info.GetValue(Me, Nothing).ToString())
                    End If
                Next info
                writer.WriteEndElement()
            End Using

            'OnChanged()
        End Sub 'Save
#End Region

    End Class

End Namespace

