
Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports System.Data.SqlClient
Imports System.Data.Common
Imports System.Data
Imports System.Collections.Generic
Imports System.Text
Imports NetShopForge.Common.Globals
Imports NetShopForge.Common

Namespace NetShopForge.Library.Shipping

    Public Class ShippingController

#Region "---Public Method----"

#Region "---Shipping Region-----"

        Public Function GetShippingRegionList() As List(Of ShippingRegionInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_GetShippingRegionList")

            Dim ShippingRegionList As New List(Of ShippingRegionInfo)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    ShippingRegionList.Add(FillShippingRegionInfo(reader))
                End While
                Return ShippingRegionList
            End Using

        End Function
        Public Function GetShippingRegion(ByVal ShippingRegionID As Integer) As ShippingRegionInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_GetShippingRegion")

            db.AddInParameter(dbCommand, "@ShippingRegionID", DbType.Int32, ShippingRegionID)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillShippingRegionInfo(reader)
                End While
                Return Nothing
            End Using

        End Function
        Public Function AddShippingRegion(ByVal regioninfo As ShippingRegionInfo) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_AddShippingRegion")
            Dim regionID As Integer = GetKeys("ShippingRegionID")
            db.AddInParameter(dbCommand, "@ShippingRegionID", DbType.Int32, regionID)
            db.AddInParameter(dbCommand, "@Name", DbType.String, regioninfo.Name)
            db.AddInParameter(dbCommand, "@RegionDescription", DbType.String, regioninfo.RegionDescription)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, regioninfo.IsValid)
            db.ExecuteNonQuery(dbCommand)

            Return regionID

        End Function
        Public Sub DeleteShippingRegion(ByVal shippingRegionID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_DeleteShippingRegion")
            db.AddInParameter(dbCommand, "@ShippingRegionID", DbType.Int32, shippingRegionID)
            db.ExecuteNonQuery(dbCommand)
        End Sub
        Public Sub UpdateShippingRegionQuick(ByVal shippingRegionID As Integer, ByVal isValid As Boolean)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_UpdateShippingRegionQuick")

            db.AddInParameter(dbCommand, "@ShippingRegionID", DbType.Int32, shippingRegionID)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, isValid)
            db.ExecuteNonQuery(dbCommand)


        End Sub
        Public Sub UpdateShippingRegion(ByVal shippingRegion As ShippingRegionInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_UpdateShippingRegion")

            db.AddInParameter(dbCommand, "@ShippingRegionID", DbType.Int32, shippingRegion.ShippingRegionID)
            db.AddInParameter(dbCommand, "@Name", DbType.String, shippingRegion.Name)
            db.AddInParameter(dbCommand, "@RegionDescription", DbType.String, shippingRegion.RegionDescription)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, shippingRegion.IsValid)
            db.ExecuteNonQuery(dbCommand)

        End Sub

#End Region
#Region "---Shipping Method----"

        Public Function GetShippingMethodList(ByVal regionID As Integer) As List(Of ShippingMethodInfo)


            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_GetShippingMethodList")
            Dim sRegion As String = String.Format("%{0}%", regionID.ToString)
            db.AddInParameter(dbCommand, "@ShippingRegionID", DbType.String, sRegion)
            Dim ShippingMethodList As New List(Of ShippingMethodInfo)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    ShippingMethodList.Add(FillShippingMethodInfo(reader))
                End While
                Return ShippingMethodList
            End Using

        End Function
        Public Function GetShippingMethodList() As List(Of ShippingMethodInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_GetShippingMethodList")

            Dim ShippingMethodList As New List(Of ShippingMethodInfo)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    ShippingMethodList.Add(FillShippingMethodInfo(reader))
                End While
                Return ShippingMethodList
            End Using

        End Function


        Public Function GetShippingMethod(ByVal ShippingMethodID As Integer) As ShippingMethodInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_GetShippingMethod")

            db.AddInParameter(dbCommand, "@ShippingMethodID", DbType.Int32, ShippingMethodID)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillShippingMethodInfo(reader)
                End While
                Return Nothing
            End Using

        End Function
        Public Function AddShippingMethod(ByVal ShippingMethod As ShippingMethodInfo) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_AddShippingMethod")
            Dim ShippingMethodID As Integer = GetKeys("ShippingMethodID")
            db.AddInParameter(dbCommand, "@ShippingMethodID", DbType.Int32, ShippingMethodID)
            db.AddInParameter(dbCommand, "@ShippingMethodName", DbType.String, ShippingMethod.ShippingMethodName)
            db.AddInParameter(dbCommand, "@ShippingRegionIDs", DbType.String, ShippingMethod.ShippingRegionIDs)
            db.AddInParameter(dbCommand, "@PaymentMethodIDs", DbType.String, ShippingMethod.PaymentMethodIDs)
            db.AddInParameter(dbCommand, "@ShippingPrice", DbType.Decimal, ShippingMethod.ShippingPrice)
            db.AddInParameter(dbCommand, "@ShippingMethodDescription", DbType.String, ShippingMethod.ShippingMethodDescription)
            db.AddInParameter(dbCommand, "@ShippingMethodFeeType", DbType.Int32, ShippingMethod.ShippingMethodFeeType)
            db.AddInParameter(dbCommand, "@IsInsurance", DbType.Boolean, ShippingMethod.IsInsurance)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, ShippingMethod.IsValid)
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, ShippingMethod.ItemOrder)
            db.AddInParameter(dbCommand, "@InsuranceFeeRate", DbType.Decimal, ShippingMethod.InsuranceFeeRate)
            db.AddInParameter(dbCommand, "@MiniInsuranceFee", DbType.Decimal, ShippingMethod.MiniInsuranceFee)
            db.AddInParameter(dbCommand, "@ShippingType", DbType.Int32, CInt(ShippingMethod.ShippingType))
            db.ExecuteNonQuery(dbCommand)
            Return ShippingMethodID

        End Function
        Public Sub UpdateShippingMethod(ByVal ShippingMethod As ShippingMethodInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_UpdateShippingMethod")
            db.AddInParameter(dbCommand, "@ShippingMethodID", DbType.Int32, ShippingMethod.ShippingMethodID)
            db.AddInParameter(dbCommand, "@ShippingMethodName", DbType.String, ShippingMethod.ShippingMethodName)
            db.AddInParameter(dbCommand, "@ShippingRegionIDs", DbType.String, ShippingMethod.ShippingRegionIDs)
            db.AddInParameter(dbCommand, "@PaymentMethodIDs", DbType.String, ShippingMethod.PaymentMethodIDs)
            db.AddInParameter(dbCommand, "@ShippingPrice", DbType.Decimal, ShippingMethod.ShippingPrice)
            db.AddInParameter(dbCommand, "@ShippingMethodDescription", DbType.String, ShippingMethod.ShippingMethodDescription)
            db.AddInParameter(dbCommand, "@ShippingMethodFeeType", DbType.Int32, ShippingMethod.ShippingMethodFeeType)
            db.AddInParameter(dbCommand, "@IsInsurance", DbType.Boolean, ShippingMethod.IsInsurance)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, ShippingMethod.IsValid)
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, ShippingMethod.ItemOrder)
            db.AddInParameter(dbCommand, "@InsuranceFeeRate", DbType.Decimal, ShippingMethod.InsuranceFeeRate)
            db.AddInParameter(dbCommand, "@MiniInsuranceFee", DbType.Decimal, ShippingMethod.MiniInsuranceFee)
            db.AddInParameter(dbCommand, "@ShippingType", DbType.Int32, CInt(ShippingMethod.ShippingType))

            db.ExecuteNonQuery(dbCommand)

        End Sub
        Public Sub DeleteShippingMethod(ByVal ShippingMethodID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_DeleteShippingMethod")
            db.AddInParameter(dbCommand, "@ShippingMethodID", DbType.Int32, ShippingMethodID)
            db.ExecuteNonQuery(dbCommand)
        End Sub
        Public Sub UpdateShippingMethodQuick(ByVal ShippingMethodID As Integer, ByVal ItemOrder As Integer, ByVal isValid As Boolean)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_UpdateShippingMethodQuick")

            db.AddInParameter(dbCommand, "@ShippingMethodID'", DbType.Int32, ShippingMethodID)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, isValid)
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, ItemOrder)
            db.ExecuteNonQuery(dbCommand)


        End Sub

        Public Sub DeleteShippingRegionExpressions(ByVal shippingMethodID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_DeleteShippingRegionExpressions")
            db.AddInParameter(dbCommand, "@ShippingMethodID", DbType.Int32, shippingMethodID)

            db.ExecuteNonQuery(dbCommand)
        End Sub
        Public Sub AddShippingRegionExpressions(ByVal shippingMethodID As Integer, ByVal RegionID As Integer, ByVal paymentID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_AddShippingRegionExpressions")
            db.AddInParameter(dbCommand, "@ShippingMethodID", DbType.Int32, shippingMethodID)
            db.AddInParameter(dbCommand, "@ShippingRegionID", DbType.Int32, RegionID)
            db.AddInParameter(dbCommand, "@ShippingExpressionsID", DbType.Int32, paymentID)
            db.ExecuteNonQuery(dbCommand)
        End Sub

        '[nsf_Shipping_GetShippingRegionExpressionsList]

        Public Function GetShippingRegionExpressionsList(ByVal ShippingMethodID As Integer) As Dictionary(Of Integer, Integer)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_GetShippingRegionExpressionsList")

            db.AddInParameter(dbCommand, "@ShippingMethodID", DbType.Int32, ShippingMethodID)
            Dim RegionPaymentList As New Dictionary(Of Integer, Integer)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    RegionPaymentList.Add(Utility.GetInt32(reader, "ShippingRegionID"), Utility.GetInt32(reader, "ShippingExpressionsID"))
                End While
            End Using
            Return RegionPaymentList
        End Function



#End Region
#Region "---Shipping Expressions-----"

        Public Function GetShippingExpressionsList() As List(Of ShippingExpressionsInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_GetShippingExpressionsList")

            Dim ShippingExpressionsList As New List(Of ShippingExpressionsInfo)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    ShippingExpressionsList.Add(FillShippingExpressionsInfo(reader))
                End While
                Return ShippingExpressionsList
            End Using

        End Function
        Public Function GetShippingExpressions(ByVal ShippingExpressionsID As Integer) As ShippingExpressionsInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_GetShippingExpressions")

            db.AddInParameter(dbCommand, "@ShippingExpressionsID", DbType.Int32, ShippingExpressionsID)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillShippingExpressionsInfo(reader)
                End While
                Return Nothing
            End Using

        End Function
        Public Function AddShippingExpressions(ByVal expressionsInfo As ShippingExpressionsInfo) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_AddShippingExpressions")
            Dim shippingExpressionsID As Integer = GetKeys("ShippingExpressionsID")
            db.AddInParameter(dbCommand, "@ShippingExpressionsID", DbType.Int32, shippingExpressionsID)
            db.AddInParameter(dbCommand, "@ExpressionsDescription", DbType.String, expressionsInfo.ExpressionsDescription)
            db.AddInParameter(dbCommand, "@Expressions", DbType.String, expressionsInfo.Expressions)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, expressionsInfo.IsValid)
            db.ExecuteNonQuery(dbCommand)

            Return shippingExpressionsID

        End Function
        Public Sub DeleteShippingExpressions(ByVal shippingExpressionsID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_DeleteShippingExpressions")
            db.AddInParameter(dbCommand, "@ShippingExpressionsID", DbType.Int32, shippingExpressionsID)
            db.ExecuteNonQuery(dbCommand)
        End Sub
        Public Sub UpdateShippingExpressionsQuick(ByVal shippingRegionID As Integer, ByVal isValid As Boolean)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_UpdateShippingExpressionsQuick")

            db.AddInParameter(dbCommand, "@ShippingExpressionsID", DbType.Int32, shippingRegionID)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, isValid)
            db.ExecuteNonQuery(dbCommand)


        End Sub
        Public Sub UpdateShippingExpressions(ByVal shippingExpressions As ShippingExpressionsInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shipping_UpdateShippingExpressions")

            db.AddInParameter(dbCommand, "@ShippingExpressionsID", DbType.Int32, shippingExpressions.ShippingExpressionsID)
            db.AddInParameter(dbCommand, "@ExpressionsDescription", DbType.String, shippingExpressions.ExpressionsDescription)
            db.AddInParameter(dbCommand, "@Expressions", DbType.String, shippingExpressions.Expressions)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, shippingExpressions.IsValid)
            db.ExecuteNonQuery(dbCommand)

        End Sub

#End Region

#End Region

#Region "---Private Method---"

        Private Function FillShippingRegionInfo(ByVal dr As IDataReader) As ShippingRegionInfo

            Dim objSRI As New ShippingRegionInfo

            objSRI.IsValid = Utility.GetBoolean(dr, "IsValid")
            objSRI.Name = Utility.GetString(dr, "Name")
            objSRI.RegionDescription = Utility.GetString(dr, "RegionDescription")
            objSRI.ShippingRegionID = Utility.GetInt32(dr, "ShippingRegionID")

            Return objSRI

        End Function
        Private Function FillShippingMethodInfo(ByVal dr As IDataReader) As ShippingMethodInfo

            Dim objSMI As New ShippingMethodInfo
            objSMI.ShippingMethodID = dr.Item("ShippingMethodID")
            objSMI.InsuranceFeeRate = Utility.GetDecimal(dr, "InsuranceFeeRate")
            objSMI.IsInsurance = Utility.GetBoolean(dr, "IsInsurance")
            objSMI.IsValid = Utility.GetBoolean(dr, "IsValid")
            objSMI.ItemOrder = Utility.GetInt32(dr, "ItemOrder")
            objSMI.MiniInsuranceFee = Utility.GetDecimal(dr, "MiniInsuranceFee")
            objSMI.ShippingMethodDescription = Utility.GetString(dr, "ShippingMethodDescription")
            objSMI.ShippingMethodFeeType = Utility.GetInt32(dr, "ShippingMethodFeeType")
            objSMI.ShippingMethodName = Utility.GetString(dr, "ShippingMethodName")
            objSMI.ShippingPrice = Utility.GetDecimal(dr, "ShippingPrice")
            objSMI.ShippingRegionIDs = Utility.GetString(dr, "ShippingRegionIDs")
            objSMI.PaymentMethodIDs = Utility.GetString(dr, "PaymentMethodIDs")
            objSMI.ShippingType = Utility.GetInt32(dr, "ShippingType")
            Return objSMI

        End Function

        Private Function FillShippingExpressionsInfo(ByVal dr As IDataReader) As ShippingExpressionsInfo

            Dim objSEI As New ShippingExpressionsInfo

            objSEI.Expressions = Utility.GetString(dr, "Expressions")
            objSEI.ExpressionsDescription = Utility.GetString(dr, "ExpressionsDescription")
            objSEI.ShippingExpressionsID = Utility.GetInt32(dr, "ShippingExpressionsID")
            objSEI.IsValid = Utility.GetBoolean(dr, "IsValid")

            Return objSEI

        End Function
#End Region

    End Class

End Namespace

