
Namespace NetShopForge.Library.Shipping

    Public Class ShippingMethodInfo

        Private _shippingmethodid As Integer
        Private _shippingmethodname As String
        Private _shippingregionids As String
        Private _PaymentMethodIDs As String
        Private _shippingprice As Decimal
        Private _shippingmethoddesption As String
        Private _shippingexpressionsid As Integer
        Private _shippingmethodfeetype As Integer
        Private _isinsurance As Boolean
        Private _isvalid As Boolean
        Private _itemorder As Integer
        Private _insurancefeerate As Decimal
        Private _miniinsurancefee As Decimal
        Private _shippingType As ShippingType


        Public Sub New()
            _miniinsurancefee = 0.0
            _shippingprice = 0.0
            _miniinsurancefee = 0.0
            _isvalid = True
            _itemorder = 0
        End Sub

        Public Property ShippingMethodID() As Integer
            Get
                Return _shippingmethodid
            End Get
            Set(ByVal Value As Integer)
                _shippingmethodid = value
            End Set
        End Property
        ''' <summary>
        ''' 
        ''' </summary>
        Public Property ShippingMethodName() As String
            Get
                Return _shippingmethodname
            End Get
            Set(ByVal Value As String)
                _shippingmethodname = value
            End Set
        End Property
        ''' <summary>
        ''' 
        ''' </summary>
        Public Property ShippingRegionIDs() As String
            Get
                Return _shippingregionids
            End Get
            Set(ByVal Value As String)
                _shippingregionids = value
            End Set
        End Property

        Public Property PaymentMethodIDs() As String
            Get
                Return _PaymentMethodIDs
            End Get
            Set(ByVal Value As String)
                _PaymentMethodIDs = Value
            End Set
        End Property
        ''' <summary>
        ''' 
        ''' </summary>
        Public Property ShippingPrice() As Decimal
            Get
                Return _shippingprice
            End Get
            Set(ByVal Value As Decimal)
                _shippingprice = value
            End Set
        End Property
        ''' <summary>
        ''' 
        ''' </summary>
        Public Property ShippingMethodDescription() As String
            Get
                Return _shippingmethoddesption
            End Get
            Set(ByVal Value As String)
                _shippingmethoddesption = value
            End Set
        End Property
        ''' <summary>
        ''' 
        ''' </summary>
        Public Property ShippingExpressionsID() As Integer
            Get
                Return _shippingexpressionsid
            End Get
            Set(ByVal Value As Integer)
                _shippingexpressionsid = value
            End Set
        End Property
        ''' <summary>
        ''' 
        ''' </summary>
        Public Property ShippingMethodFeeType() As Integer
            Get
                Return _shippingmethodfeetype
            End Get
            Set(ByVal Value As Integer)
                _shippingmethodfeetype = value
            End Set
        End Property
        ''' <summary>
        ''' 
        ''' </summary>
        Public Property IsInsurance() As Boolean
            Get
                Return _isinsurance
            End Get
            Set(ByVal Value As Boolean)
                _isinsurance = value
            End Set
        End Property
        ''' <summary>
        ''' 
        ''' </summary>
        Public Property IsValid() As Boolean
            Get
                Return _isvalid
            End Get
            Set(ByVal Value As Boolean)
                _isvalid = value
            End Set
        End Property
        ''' <summary>
        ''' 
        ''' </summary>
        Public Property ItemOrder() As Integer
            Get
                Return _itemorder
            End Get
            Set(ByVal Value As Integer)
                _itemorder = value
            End Set
        End Property
        ''' <summary>
        ''' 
        ''' </summary>
        Public Property InsuranceFeeRate() As Decimal
            Get
                Return _insurancefeerate
            End Get
            Set(ByVal Value As Decimal)
                _insurancefeerate = value
            End Set
        End Property
        ''' <summary>
        ''' 
        ''' </summary>
        Public Property MiniInsuranceFee() As Decimal
            Get
                Return _miniinsurancefee
            End Get
            Set(ByVal Value As Decimal)
                _miniinsurancefee = value
            End Set
        End Property
        Public Property ShippingType() As ShippingType
            Get
                Return _shippingType
            End Get
            Set(ByVal Value As ShippingType)
                _shippingType = Value
            End Set
        End Property
   

        Public Property ShippingRegionCollection() As String()
            Get
                If _shippingregionids.Length = 0 Then Return Nothing
                Return _shippingregionids.Substring(1, _shippingregionids.Length - 1).Split(",")
            End Get
            Set(ByVal value As String())
                Dim sb As New System.Text.StringBuilder
                sb.Append(",")
                For Each s As String In value
                    sb.Append(String.Format("{0},", s))
                Next
                _shippingregionids = sb.ToString
            End Set
        End Property

        Public Property PaymentMethodCollection() As String()
            Get
                If _PaymentMethodIDs.Length = 0 Then Return Nothing
                Return _PaymentMethodIDs.Substring(1, _PaymentMethodIDs.Length - 2).Split(",")
            End Get
            Set(ByVal value As String())
                Dim sb As New System.Text.StringBuilder
                sb.Append(",")
                For Each s As String In value
                    sb.Append(String.Format("{0},", s))
                Next
                _PaymentMethodIDs = sb.ToString
            End Set

        End Property


    End Class

    Public Enum ShippingType
        VIRTUAL = 0
        POST = 1
        EMS = 2
        EXPRESS = 3
    End Enum


End Namespace
