Imports System
Imports System.Configuration
Imports System.Data
Imports System.Data.Common
Imports System.Threading
Imports System.Web
Imports System.Collections.Generic
Imports AspNetProfile = System.Web.Profile
Imports AspNetSecurity = System.Web.Security
Imports NetShopForge.Common.Utilities
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports Microsoft.Practices.EnterpriseLibrary.Data


Namespace NetShopForge.Library.Shop

    Public Class ShopController
        Private Shared _Instance As ShopController
        Public Shared ReadOnly Property Instance() As ShopController
            Get
                If IsNothing(_Instance) Then
                    _Instance = New ShopController
                End If
                Return _Instance
            End Get
        End Property


#Region "Public Methods"
        Public Sub DeleteShop(ByVal ShopId As Integer)


            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Shop_DeleteShop"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            ' Retrieve products from the specified category.
            db.AddInParameter(dbCommand, "ShopID", DbType.Int32, ShopId)
            db.ExecuteNonQuery(dbCommand)


        End Sub


        Public Function AddShop(ByVal shop As ShopInfo) As Integer
            Dim shopID As Integer
            Try
                Dim db As Database = DatabaseFactory.CreateDatabase()

                Dim sqlCommand As String = "nsf_Shop_AddShop"
                Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)


                db.AddInParameter(dbCommand, "@ShopName", DbType.String, shop.ShopName)
                db.AddInParameter(dbCommand, "@Logo", DbType.String, shop.Logo)
                db.AddInParameter(dbCommand, "@Address", DbType.String, shop.Address)
                db.AddInParameter(dbCommand, "@Email", DbType.String, shop.Email)
                db.AddInParameter(dbCommand, "@Phone", DbType.String, shop.Phone)
                db.AddInParameter(dbCommand, "@IsCommend", DbType.Boolean, shop.IsCommend)
                db.AddInParameter(dbCommand, "@URL", DbType.String, shop.URL)
                db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, shop.ItemOrder)
                db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, shop.IsValid)
                db.AddInParameter(dbCommand, "@Description", DbType.String, shop.Description)
                db.AddOutParameter(dbCommand, "@ShopID", DbType.Int32, 20)

                db.ExecuteNonQuery(dbCommand)

                shopID = db.GetParameterValue(dbCommand, "ShopID")
            Catch ex As Exception
                ShopID = -1
            End Try

            Return shopID
        End Function

        Public Sub UpdateShop(ByVal shop As ShopInfo)


            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shop_UpdateShop")

            db.AddInParameter(dbCommand, "@ShopID", DbType.String, shop.ShopID)
            db.AddInParameter(dbCommand, "@ShopName", DbType.String, shop.ShopName)
            db.AddInParameter(dbCommand, "@Logo", DbType.String, shop.Logo)
            db.AddInParameter(dbCommand, "@Address", DbType.String, shop.Address)
            db.AddInParameter(dbCommand, "@Email", DbType.String, shop.Email)
            db.AddInParameter(dbCommand, "@IsCommend", DbType.Boolean, shop.IsCommend)
            db.AddInParameter(dbCommand, "@URL", DbType.String, shop.URL)
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, shop.ItemOrder)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, shop.IsValid)
            db.AddInParameter(dbCommand, "@Description", DbType.String, shop.Description)
            db.AddInParameter(dbCommand, "@Phone", DbType.String, shop.Phone)
            db.ExecuteNonQuery(dbCommand)


        End Sub

        Public Sub UpdateShopQuick(ByVal shopID As Integer, ByVal ItemOrder As Integer, ByVal IsCommend As Boolean, ByVal IsValid As Boolean)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shop_UpdateShopQuick")

            db.AddInParameter(dbCommand, "@ShopID", DbType.String, shopID)
            db.AddInParameter(dbCommand, "@IsCommend", DbType.Boolean, IsCommend)
            db.AddInParameter(dbCommand, "@ItemOrder", DbType.Int32, ItemOrder)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, IsValid)

            db.ExecuteNonQuery(dbCommand)
        End Sub

        Public Function GetShopName(ByVal shopID As Integer) As String

            Dim sql As String = String.Format("select ShopName From nsf_shop Where ShopID={0}", shopID)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbcommand As DbCommand = db.GetSqlStringCommand(sql)
            Return db.ExecuteScalar(dbcommand)

        End Function

        Public Function Getshop(ByVal shopID As String) As ShopInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shop_GetShop")
            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@ShopID", DbType.Int32, shopID)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillShopInfo(reader)
                End While
                Return Nothing
            End Using
        End Function

        Public Function GetShops() As List(Of ShopInfo)
            Return GetShops("")
        End Function

        Public Function GetShops(ByVal sqlWhere As String) As List(Of ShopInfo)

            Dim Shops As New Generic.List(Of ShopInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Shop_GetShopList")
            If sqlWhere.Length > 0 Then db.AddInParameter(dbCommand, "@SqlWhere", DbType.String, sqlWhere)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Shops.Add(FillShopInfo(reader))
                End While
                Return Shops
            End Using

        End Function





#End Region
        Friend Function FillShopInfo(ByVal reader As IDataReader) As ShopInfo

            Dim objshopInfo As New ShopInfo
            objshopInfo.ShopID = Integer.Parse(reader("ShopID").ToString)
            objshopInfo.ShopName = reader("ShopName").ToString
            objshopInfo.Address = reader("Address").ToString
            objshopInfo.Email = reader("Email").ToString
            objshopInfo.IsCommend = CBool(CInt(reader("IsCommend")))
            objshopInfo.Logo = reader("Logo").ToString
            objshopInfo.Phone = reader("Phone").ToString
            objshopInfo.IsValid = CBool(CInt(reader("IsValid")))
            objshopInfo.ItemOrder = CInt(reader("itemOrder"))
            objshopInfo.Description = reader("description")
            objShopInfo.URL = reader("URL")

            Return objshopInfo
        End Function
    End Class


End Namespace
