Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports System.Data.SqlClient
Imports System.Data.Common
Imports System.Data
Imports System.Collections.Generic
Imports System.Text
Imports NetShopForge.Common.Globals
Namespace NetShopForge.Library.ShopHelp

    Public Class ShopHelpController


#Region "Private Member"
        Private Shared _Instance As ShopHelpController
#End Region
#Region "Shared Method"
        Public Shared ReadOnly Property Instance() As ShopHelpController
            Get
                If IsNothing(_Instance) Then
                    _Instance = New ShopHelpController
                End If
                Return _Instance
            End Get
        End Property
#End Region


#Region "Public Method"

        Public Function GetShopHelpNavigation() As List(Of ShopHelpCategoryInfo)
            Dim shCategoryList As New List(Of ShopHelpInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim sql As String = "SELECT *  FROM nsf_ShopHelpCategory  WHERE IsNavigation=1  Order By [ItemOrder] "
            Dim shcList As New List(Of ShopHelpCategoryInfo)
            Using reader As IDataReader = db.ExecuteReader(CommandType.Text, sql)
                While reader.Read
                    shcList.Add(FillShopHelpCategoryInfo(reader))
                End While
            End Using
            Return shcList
        End Function
        Public Function GetShopHelpCategoryList() As List(Of ShopHelpCategoryInfo)
            Dim shCategoryList As New List(Of ShopHelpInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim sql As String = "SELECT *  FROM nsf_ShopHelpCategory   Order By [ItemOrder] "
            Dim shcList As New List(Of ShopHelpCategoryInfo)
            Using reader As IDataReader = db.ExecuteReader(CommandType.Text, sql)
                While reader.Read
                    shcList.Add(FillShopHelpCategoryInfo(reader))
                End While
            End Using
            Return shcList
        End Function

        Public Function GetShopHelpCategory(ByVal ShopHelpCategoryID As Integer) As ShopHelpCategoryInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim sql As String = String.Format("SELECT * FROM nsf_ShopHelpCategory WHERE ShopHelpCategoryID={0} ", ShopHelpCategoryID)
            Using reader As IDataReader = db.ExecuteReader(CommandType.Text, sql)
                While reader.Read
                    Return FillShopHelpCategoryInfo(reader)
                End While
            End Using
            Return Nothing
        End Function

        Public Function GetShopHelp(ByVal shopHelpID As Integer) As ShopHelpInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim sql As String = String.Format("SELECT * FROM nsf_ShopHelp WHERE ShopHelpID={0}", shopHelpID)
            Using reader As IDataReader = db.ExecuteReader(CommandType.Text, sql)
                While reader.Read
                    Return FillShopHelpInfo(reader)
                End While
            End Using
            Return Nothing
        End Function

        Public Function GetShopHelpList(ByVal shopHelpCategoryID As Integer) As List(Of ShopHelpInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_ShopHelp_GetShopHelpList")
            db.AddInParameter(dbCommand, "@ShopHelpCategoryID", DbType.Int32, shopHelpCategoryID)
            Dim shList As New List(Of ShopHelpInfo)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    shList.Add(FillShopHelpInfo(reader))
                End While
            End Using
            Return shList
        End Function



        Public Function AddShopHelpCategory(ByVal name As String, ByVal itemOrder As Integer, ByVal IsNavigation As Boolean) As Integer

            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim shopHelpCategoryID As Integer = GetKeys("ShopHelpCategoryID")

            Dim sqlb As New StringBuilder
            sqlb.Append("INSERT INTO nsf_ShopHelpCategory(")
            sqlb.Append("[ShopHelpCategoryID],[Name],[ItemOrder],[IsNavigation]")
            sqlb.Append(")VALUES(")
            sqlb.Append(String.Format("{0},'{1}',{2},{3}", shopHelpCategoryID, name.Replace("'", "''"), itemOrder, CInt(IsNavigation)))
            sqlb.Append(")")
            db.ExecuteNonQuery(CommandType.Text, sqlb.ToString)
            Return shopHelpCategoryID
        End Function
        Public Function AddShopHelp(ByVal shopHelpCategoryID As Integer, ByVal name As String, ByVal Description As String) As Integer

            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_ShopHelp_AddShopHelp"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            Dim shopHelpID As Integer = GetKeys("ShopHelpID")

            db.AddInParameter(dbCommand, "@ShopHelpID", DbType.Int32, shopHelpID)
            db.AddInParameter(dbCommand, "@ShopHelpCategoryID", DbType.Int32, shopHelpCategoryID)
            db.AddInParameter(dbCommand, "@Name", DbType.String, name)
            db.AddInParameter(dbCommand, "@Description", DbType.String, Description)
            db.ExecuteNonQuery(dbCommand)

            Return shopHelpCategoryID
        End Function

        Public Sub DeleteShopHelpCategory(ByVal shopHelpCategoryID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_ShopHelp_DeleteShopHelpCategory"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@ShopHelpCategoryID", DbType.Int32, shopHelpCategoryID)
            db.ExecuteNonQuery(dbCommand)

        End Sub
        Public Sub DeleteShopHelp(ByVal shopHelpID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim sqlCommand As String = "nsf_ShopHelp_DeleteShopHelp"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "@shopHelpID", DbType.Int32, shopHelpID)
            db.ExecuteNonQuery(dbCommand)
        End Sub

        Public Sub UpdateShopHelp(ByVal shopHelpID As Integer, ByVal name As String, ByVal description As String)

            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_ShopHelp_UpdateShopHelp"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)
            db.AddInParameter(dbCommand, "@ShopHelpID", DbType.Int32, shopHelpID)
            db.AddInParameter(dbCommand, "@Name", DbType.String, name.Replace("'", "''"))
            db.AddInParameter(dbCommand, "@Description", DbType.String, description)

            db.ExecuteNonQuery(dbCommand)

        End Sub
        Public Sub UpdateShopHelpCategory(ByVal shopHelpCategoryID As Integer, ByVal name As String, ByVal itemOrder As Integer, ByVal IsNavigation As Boolean)

            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_ShopHelp_UpdateShopHelpCategory"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            Dim sqlb As New StringBuilder
            sqlb.Append("UPDATE nsf_ShopHelpCategory SET")
            sqlb.Append(String.Format(" [Name]='{0}',ItemOrder={1},IsNavigation={2}", name.Replace("'", "''"), itemOrder, CInt(IsNavigation)))
            sqlb.Append(" WHERE ShopHelpCategoryID=" & shopHelpCategoryID)
            db.ExecuteNonQuery(CommandType.Text, sqlb.ToString)

        End Sub

        Public Sub UpdateShopHelpCategoryQuick(ByVal shopHelpCategoryID As Integer, ByVal itemOrder As Integer, ByVal IsNavigation As Boolean)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim sql As String = String.Format("UPDATE nsf_ShopHelpCategory SET ItemOrder={1} ,IsNavigation={2} WHERE ShopHelpCategoryID={0}", shopHelpCategoryID.ToString, itemOrder.ToString, CInt(IsNavigation))
            db.ExecuteNonQuery(CommandType.Text, sql)
        End Sub
#End Region
#Region " Private Method"
        Private Function FillShopHelpInfo(ByVal dr As IDataReader) As ShopHelpInfo

            Dim sh As New ShopHelpInfo
            sh.Description = dr.Item("Description")
            sh.Name = dr.Item("Name")
            sh.ShopHelpCategoryID = CInt(dr.Item("ShopHelpCategoryID"))
            sh.ShopHelpID = CInt(dr.Item("ShopHelpID"))

            Return sh
        End Function
        Private Function FillShopHelpCategoryInfo(ByVal dr As IDataReader) As ShopHelpCategoryInfo
            Dim shcInfo As New ShopHelpCategoryInfo
            shcInfo.ShopHelpCategoryID = CInt(dr.Item("ShopHelpCategoryID"))
            shcInfo.Name = dr.Item("Name")
            shcInfo.ItemOrder = CInt(dr.Item("ItemOrder"))
            If IsDBNull(dr.Item("IsNavigation")) Then
                shcInfo.IsNavigation = 0
            Else
                shcInfo.IsNavigation = CBool(dr.Item("IsNavigation"))
            End If

            Return shcInfo
        End Function

#End Region
    End Class


End Namespace