
Imports Microsoft.VisualBasic
Imports System
Imports System.Collections
Imports NetShopForge.Library.Product

Namespace NetShopForge.Library.Cart

    <Serializable()> _
    Public Class Cart

        Private cartItems As Dictionary(Of String, CartInfo)

        Public Sub New()
            cartItems = New Dictionary(Of String, CartInfo)
        End Sub

        ''' <summary>
        ''' Calculate the total for all the cartItems in the Cart
        ''' </summary>
        Public ReadOnly Property Total() As Decimal
            Get
                Dim _total As Decimal = 0
                Dim item As CartInfo
                For Each item In cartItems.Values
                    Total += item.UnitPrice * item.Quantity
                Next item
                Return Total
            End Get
        End Property

        ''' <summary>
        ''' Update the quantity for product that exists in the cart
        ''' </summary>
        ''' <param name="ItemID">product Id</param>
        ''' <param name="qty">Quantity</param>
        Public Sub SetQuantity(ByVal ItemID As String, ByVal qty As Integer)
            cartItems(ItemID).Quantity = qty
        End Sub 'SetQuantity

        ''' <summary>
        ''' Return the number of unique products in cart
        ''' </summary>
        Public ReadOnly Property Count() As Integer
            Get
                Return cartItems.Count
            End Get
        End Property

        ''' <summary>
        ''' Add an product to the cart.
        ''' When ItemId to be added has already existed, this method will update the quantity instead.
        ''' </summary>
        Public Overloads Sub Add(ByVal ProductID As Integer)
            Dim cartItem As CartInfo = Nothing
            Dim ItemID As String = String.Format("{0}|", ProductID.ToString)
            If Not cartItems.TryGetValue(ItemID, cartItem) Then

                Dim objPI As ProductInfo = ProductController.GetProduct(ProductID)
                If Not (objPI Is Nothing) Then
                    Dim objCartInfo As New CartInfo(ProductID, objPI.ProductName, objPI.Price, 1, "", objPI.ImagePath)
                    cartItems.Add(ItemID, objCartInfo)
                End If
            Else
                cartItem.Quantity += 1
            End If
        End Sub 'Add

        ''' <summary>
        ''' Add an CartInfo to the cart.
        ''' When objCartInfo to be added has already existed, this method will update the quantity instead.
        ''' </summary>
        ''' <param name="objCartInfo">CartInfo to add</param>
        Public Overloads Sub Add(ByVal objCartInfo As CartInfo)
            Dim ItemID As String = String.Format("{0}|{1}", objCartInfo.ProductID, objCartInfo.Options)
            Dim cartItem As CartInfo = Nothing
            If Not cartItems.TryGetValue(ItemID, cartItem) Then
                cartItems.Add(ItemID, objCartInfo)
            Else
                cartItem.Quantity += objCartInfo.Quantity
            End If
        End Sub 'Add

        ''' <summary>
        ''' Remove item from the cart based on productID
        ''' </summary>
        ''' <param name="ItemID">ItemId of item to remove</param>
        Public Sub Remove(ByVal ItemID As String)
            cartItems.Remove(ItemID)
        End Sub 'Remove

        ''' <summary>
        ''' Returns all items in the cart. Useful for looping through the cart.
        ''' </summary>
        '''<returns>Collection of CartItemInfo</returns>
        Public ReadOnly Property CartCollection() As ICollection(Of CartInfo)
            Get
                Return cartItems.Values
            End Get
        End Property

        ''' <summary>
        ''' Clear the cart
        ''' </summary>
        Public Sub Clear()
            cartItems.Clear()
        End Sub 'Clear

    End Class
End Namespace