Imports Microsoft.VisualBasic
Imports System
Imports System.Web
Imports System.Collections


Namespace NetShopForge.Library.Cart

    Public Class CookieShoppingCartController
        Implements IShoppingCart

        'ToDo: Add Implements Clauses for implementation methods of these interface(s)
        Public Function Add(ByVal cartid As String, ByVal item As IShoppingCartInfo) As Integer Implements IShoppingCart.Add
            Dim c As HttpCookie = Nothing
            If HttpContext.Current.Request.Cookies("shoppingcart") Is Nothing Then
                c = New HttpCookie("shoppingcart")

            Else
                c = HttpContext.Current.Request.Cookies("shoppingcart")
            End If
            c.Expires = Today.AddDays(4)
            Dim itemdetails As String = ShopingCartInfoTOString(item)

            c.Values(item.ProductID.ToString()) = itemdetails
            HttpContext.Current.Response.Cookies.Add(c)

            Return 1
        End Function 'Add

        Public Function ShopingCartInfoToString(ByVal item As IShoppingCartInfo) As String

            'productID|productName|uniprice|options|ImagePath|Quantity
            ' Dim options As New System.Text.StringBuilder
            'Dim optionList As Generic.Dictionary(Of String, String) = item.Options

            'If Not IsNothing(optionList) Then
            '    Dim sOption As String
            '    For Each sOption In optionList.Keys
            '        options.Append(String.Format("{0}:{1}@", sOption, optionList(sOption)))
            '    Next

            'End If
            Return String.Format("{0}|{1}|{2}|{3}|{4}|{5}", item.ProductID.ToString, item.ProductName, item.UnitPrice.ToString, item.Options.ToString, item.ImagePath, item.Quantity.ToString)
        End Function
        Public Function StringToShoppingCartInfo(ByVal itemDetails As String) As ShoppingCartInfo
            Dim vals As String() = itemDetails.Split("|"c)
            Dim item As New ShoppingCartInfo()
            item.ProductID = Integer.Parse(vals(0))
            item.ProductName = vals(1)
            item.UnitPrice = Decimal.Parse(vals(2))
            item.Quantity = Integer.Parse(vals(5))
            item.Options = vals(3)
            'If vals(3).Length > 0 Then
            '    Dim optionList As New Generic.Dictionary(Of String, String)
            '    Dim options() As String = Split(vals(3), "@")
            '    For j As Integer = 0 To options.Length - 2
            '        Dim op As String() = options(j).Split(":")
            '        optionList.Add(op(0), op(1))
            '    Next
            '    item.Options = optionList
            'End If
            item.ImagePath = vals(4)
            Return item
        End Function

        Public Function Remove(ByVal cartid As String, ByVal item As IShoppingCartInfo) As Integer Implements IShoppingCart.Remove
            Dim c As HttpCookie = HttpContext.Current.Request.Cookies("shoppingcart")
            c.Values.Remove(item.ProductID.ToString())
            HttpContext.Current.Response.Cookies.Add(c)
            Return 1
        End Function 'Remove

        Public Function GetItems(ByVal cartid As String) As System.Collections.Generic.IList(Of IShoppingCartInfo) Implements IShoppingCart.GetItems
            Dim c As HttpCookie = HttpContext.Current.Request.Cookies("shoppingcart")
            If IsNothing(c) Then Return Nothing

            Dim items As New List(Of IShoppingCartInfo)

            Dim i As Integer

            For i = 0 To c.Values.Count - 1
                'productID|productName|uniprice|options|ImagePath|Quantity
                items.Add(StringToShoppingCartInfo(c.Values(i)))
            Next i
            Return items
        End Function


    End Class
End Namespace 'ShoppingCartGeneric