Imports Microsoft.VisualBasic
Imports System

Namespace NetShopForge.Library.Cart
    Public Enum ShoppingCartType
        Cookie
        Session
        Database
    End Enum 'CShoppingCartType

    Public Class ShoppingCartController
        Implements IShoppingCart

        'ToDo: Add Implements Clauses for implementation methods of these interface(s)
        Private cart As IShoppingCart = Nothing


        Public Sub New(ByVal type As ShoppingCartType)
            Select Case type
                Case ShoppingCartType.Cookie
                    cart = New CookieShoppingCartController()
                Case ShoppingCartType.Session
                    cart = New SessionShoppingCartController()
                Case ShoppingCartType.Database
                    cart = New DatabaseShoppingCartController()
            End Select
        End Sub 'New


        Public Function Add(ByVal cartid As String, ByVal item As IShoppingCartInfo) As Integer Implements IShoppingCart.Add
            Return cart.Add(cartid, item)
        End Function 'Add


        Public Function Remove(ByVal cartid As String, ByVal item As IShoppingCartInfo) As Integer Implements IShoppingCart.Remove
            Return cart.Remove(cartid, item)
        End Function 'Remove


        Public Function GetItems(ByVal cartid As String) As System.Collections.Generic.IList(Of IShoppingCartInfo) Implements IShoppingCart.GetItems
            Return cart.GetItems(cartid)
        End Function
    End Class
End Namespace 'ShoppingCartGeneric
