Imports Microsoft.VisualBasic
Imports System.Data
Imports System.Data.Common
Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports NetShopForge.Common.Globals
Imports NetShopForge.Common
Imports System.Text

Namespace NetShopForge.Library.SpecialOffer

    Public Class SpecialOfferController
#Region "--------Admin--------"
#Region "---Specail Offer----"

        Public Function GetGetNSpecialOffer() As Integer

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_GetNSpecialOffer")
            Return CInt(db.ExecuteScalar(dbCommand))

        End Function
        Public Function CreateSpecialOffer(ByVal title As String) As Integer
            Dim OfferID As Integer = GetKeys("OfferID")
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_AddSpecialOffer")
            db.AddInParameter(dbCommand, "@OfferID", DbType.Int32, OfferID)
            db.AddInParameter(dbCommand, "@Title", DbType.String, title.Replace("'", "'"))
            db.ExecuteReader(dbCommand)

            Return OfferID
        End Function
        Public Shared Function GetSpecialOffer(ByVal offerID As Integer) As SpecialOfferInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_GetSpecialOffer")

            db.AddInParameter(dbCommand, "@OfferID", DbType.Int32, offerID)

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillSpecialOfferInfo(reader)
                End While
                Return Nothing
            End Using
        End Function

        Public Shared Function GetSpecialOfferList() As List(Of SpecialOfferInfo)
            Return GetSpecialOfferList("", 0)
        End Function
        Public Shared Function GetSpecialOfferList(ByVal IsOnlyAvailable As Boolean) As List(Of SpecialOfferInfo)
            Dim whereString As String = String.Format("Status={0}", CInt(SpecialOfferStatus.Available).ToString)
            Return GetSpecialOfferList(whereString, 0)
        End Function
        Public Shared Function GetSpecialOfferList(ByVal IsOnlyAvailable As Boolean, ByVal top As Integer) As List(Of SpecialOfferInfo)
            Dim whereString As String = String.Format("Status={0}", CInt(SpecialOfferStatus.Available).ToString)
            Return GetSpecialOfferList(whereString, top)
        End Function

        ''' <summary>
        ''' get specialOfferList by offerid string
        ''' </summary>
        ''' <param name="offerIDStringArray">offerid string list,you can get it by "GetAvailableSpecialOfferString" function</param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Shared Function GetSpecialOfferList(ByVal offerIDStringArray() As String) As List(Of SpecialOfferInfo)

            Dim sOfferIDs, sOfferID As String
            Dim aList As New ArrayList
            For Each sOfferIDs In offerIDStringArray
                If sOfferIDs.Length > 0 Then
                    Dim sTemp() As String = sOfferIDs.Split(",")
                    For Each sOfferID In sTemp
                        If Not aList.Contains(sOfferID) Then aList.Add(sOfferID)
                    Next
                End If
            Next
            Dim sNewOfferIDs As New StringBuilder
            Dim sNewOfferID As String
            For Each sNewOfferID In aList
                sNewOfferIDs.Append(String.Format(",{0}", sNewOfferID))
            Next
            If sNewOfferIDs.Length = 0 Then Return Nothing
            Dim whereString As String = String.Format("OfferID IN ({0})", sNewOfferIDs.ToString.Substring(1))
            Return GetSpecialOfferList(whereString, 0)

        End Function
        ''' <summary>
        ''' Get All Special Offer List
        ''' </summary>
        ''' <param name="whereString">where string</param>
        ''' <param name="top">top =0 mean is no limited</param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Shared Function GetSpecialOfferList(ByVal whereString As String, ByVal top As Integer) As List(Of SpecialOfferInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_GetSpecialOfferList")
            If whereString.Length > 0 Then db.AddInParameter(dbCommand, "@WhereString", DbType.String, whereString)
            If top > 0 Then db.AddInParameter(dbCommand, "@Top", DbType.Int32, top)
            Dim objSOList As New List(Of SpecialOfferInfo)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    objSOList.Add(FillSpecialOfferInfo(reader))
                End While
            End Using

            Return objSOList

        End Function



        Public Sub UpdateSpecailOfferType(ByVal offerID As Integer, ByVal conditionType As Integer, ByVal BonusType As Integer)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_UpdateSpecialType")
            db.AddInParameter(dbCommand, "@OfferID", DbType.Int32, offerID)
            db.AddInParameter(dbCommand, "@ConditionType", DbType.Int32, conditionType)
            db.AddInParameter(dbCommand, "@BonusType", DbType.Int32, BonusType)

            db.ExecuteNonQuery(dbCommand)
        End Sub

        Public Sub UpdateSpecailOfferType(ByVal offerID As Integer, ByVal Type As String, ByVal TypeValue As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_UpdateSpecialType")
            db.AddInParameter(dbCommand, "@OfferID", DbType.Int32, offerID)
            If Type.ToUpper = "C" Then
                db.AddInParameter(dbCommand, "@ConditionType", DbType.Int32, TypeValue)
            Else
                db.AddInParameter(dbCommand, "@BonusType", DbType.Int32, TypeValue)
            End If
            db.ExecuteNonQuery(dbCommand)

        End Sub

        Public Sub UpdateSpecialStatus(ByVal offerID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_UpdateSpecialStatus")
            db.AddInParameter(dbCommand, "@OfferID", DbType.Int32, offerID)
            db.ExecuteNonQuery(dbCommand)

        End Sub
        Public Sub UpdateSpecialOfferPromo(ByVal offerID As Integer, ByVal ShortPromoImage As String, ByVal ShortPromoText As String, ByVal DetailedPromo As String)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_UpdateSpecialOfferPromo")
            db.AddInParameter(dbCommand, "@OfferID", DbType.Int32, offerID)
            db.AddInParameter(dbCommand, "@ShortPromoImage", DbType.String, ShortPromoImage.Replace("'", "''"))
            db.AddInParameter(dbCommand, "@ShortPromoText", DbType.String, ShortPromoText.Replace("'", "''"))
            db.AddInParameter(dbCommand, "@DetailedPromo", DbType.String, DetailedPromo.Replace("'", "''"))
            db.ExecuteNonQuery(dbCommand)
        End Sub
        Public Sub UpdateSpecialOffer(ByVal offerID As Integer, ByVal isValid As Boolean, ByVal title As String, ByVal isDisplayShortPromo As String, ByVal startDate As Date, ByVal endDate As Date)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_UpdateSpecialOffer")
            db.AddInParameter(dbCommand, "@OfferID", DbType.Int32, offerID)
            db.AddInParameter(dbCommand, "@IsValid", DbType.Boolean, isValid)
            db.AddInParameter(dbCommand, "@Title", DbType.String, title.Replace("'", "''"))
            db.AddInParameter(dbCommand, "@IsDisplayShortPromo", DbType.Boolean, isDisplayShortPromo)
            If startDate <> DateTime.MinValue Then db.AddInParameter(dbCommand, "@StartDate", DbType.Date, startDate)
            If endDate <> DateTime.MinValue Then db.AddInParameter(dbCommand, "@EndDate", DbType.Date, endDate)
            db.ExecuteNonQuery(dbCommand)

        End Sub

#End Region

#Region "---Proudct-----"
        ''' <summary>
        ''' Get Special offer product list info
        ''' </summary>
        ''' <param name="offerID">offerID</param>
        ''' <param name="type">Condition:"C",Bonus:"B"</param>
        ''' <param name="type2">BonusType OR ConditionType</param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Shared Function GetSpecialOfferProductsList(ByVal offerID As Integer, ByVal type As String, ByVal type2 As Integer) As List(Of SpecialOfferProductsInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_GetSpecialOfferProductsList")

            db.AddInParameter(dbCommand, "@OfferID", DbType.Int32, offerID)
            db.AddInParameter(dbCommand, "@Type", DbType.String, type)
            db.AddInParameter(dbCommand, "@Type2", DbType.Int32, type2)
            Dim objSOPList As New List(Of SpecialOfferProductsInfo)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    objSOPList.Add(FillSpecialOfferProductsInfo(reader))
                End While
                Return objSOPList
            End Using

        End Function
        Public Sub UpdateSpecailOfferProducts(ByVal product As SpecialOfferProductsInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_UpdateSpecialOfferProducts")
            db.AddInParameter(dbCommand, "@OfferID", DbType.Int32, product.OfferID)
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, product.ProductID)
            db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, product.CategoryID)
            db.AddInParameter(dbCommand, "@Type", DbType.String, product.Type)
            db.AddInParameter(dbCommand, "@Quantity", DbType.Int32, product.Quantity)
            db.AddInParameter(dbCommand, "@Type2", DbType.Int32, product.Type2)
            db.ExecuteNonQuery(dbCommand)
        End Sub
        Public Sub DeleteSpecialOfferProducts(ByVal offerID As Integer, ByVal productID As Integer, ByVal categoryID As Integer, ByVal type As String, ByVal type2 As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_DeleteSpecialOfferProducts")
            db.AddInParameter(dbCommand, "@OfferID", DbType.Int32, offerID)
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productID)
            db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, categoryID)
            db.AddInParameter(dbCommand, "@Type", DbType.String, type)
            db.AddInParameter(dbCommand, "@Type2", DbType.Int32, type2)
            db.ExecuteNonQuery(dbCommand)
        End Sub
        Public Sub AddSpecialOfferProducts(ByVal product As SpecialOfferProductsInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_AddSpecialOffersProducts")

            db.AddInParameter(dbCommand, "@OfferID", DbType.Int32, product.OfferID)
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, product.ProductID)
            db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, product.CategoryID)
            db.AddInParameter(dbCommand, "@Type", DbType.String, product.Type)
            db.AddInParameter(dbCommand, "@Quantity", DbType.Int32, product.Quantity)
            db.AddInParameter(dbCommand, "@Type2", DbType.Int32, product.Type2)
            db.ExecuteNonQuery(dbCommand)

        End Sub

#End Region

#Region "---BonusPrice-----"

        Public Function GetSpecialOfferBonusPriceList(ByVal offerID As Integer) As List(Of SpecialOfferBonusPriceInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_GetSpecailOffersBonusPriceList")

            db.AddInParameter(dbCommand, "@OfferID", DbType.Int32, offerID)
            Dim objSOPList As New List(Of SpecialOfferBonusPriceInfo)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    objSOPList.Add(FillSpecialOfferBonusPrice(reader))
                End While
                Return objSOPList
            End Using

        End Function
        Public Sub UpdateSpecailOffersBonusPrice(ByVal product As SpecialOfferBonusPriceInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_UpdateSpecailOffersBonusPrice")
            db.AddInParameter(dbCommand, "@OfferID", DbType.Int32, product.OfferID)
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, product.ProductID)
            db.AddInParameter(dbCommand, "@BounsType", DbType.Int32, product.BounsType)
            db.AddInParameter(dbCommand, "@AdjustPrice", DbType.Decimal, product.AdjustPrice)
            db.ExecuteNonQuery(dbCommand)
        End Sub
        Public Sub DeleteSpecailOffersBonusPrice(ByVal offerID As Integer, ByVal productID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_DeleteSpecailOffersBonusPrice")
            db.AddInParameter(dbCommand, "@OfferID", DbType.Int32, offerID)
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productID)
            db.ExecuteNonQuery(dbCommand)
        End Sub
        Public Sub DeleteSpecialOffer(ByVal offerID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_DeleteSpecialOffer")
            db.AddInParameter(dbCommand, "@OfferID", DbType.Int32, offerID)
            db.ExecuteNonQuery(dbCommand)
        End Sub

        Public Sub AddSpecailOffersBonusPrice(ByVal product As SpecialOfferBonusPriceInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_AddSpecailOffersBonusPrice")

            db.AddInParameter(dbCommand, "@OfferID", DbType.Int32, product.OfferID)
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, product.ProductID)
            db.AddInParameter(dbCommand, "@BounsType", DbType.Int32, product.BounsType)
            db.AddInParameter(dbCommand, "@AdjustPrice", DbType.Decimal, product.AdjustPrice)

            db.ExecuteNonQuery(dbCommand)

        End Sub

#End Region

#Region "---Amoumt------"

        Public Function GetSpecialOfferAmount(ByVal offerID As Integer, ByVal type As String, ByVal type2 As Integer) As SpecialOfferAmountInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_GetSpecialOffersAmount")

            db.AddInParameter(dbCommand, "@OfferID", DbType.Int32, offerID)
            db.AddInParameter(dbCommand, "@Type", DbType.String, type)
            db.AddInParameter(dbCommand, "@Type2", DbType.Int32, type2)

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillSpecialOfferAmount(reader)
                End While
                Return Nothing
            End Using

        End Function
        Public Sub SaveSpecailOffersAmount(ByVal Amount As SpecialOfferAmountInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_AddSpecialOffersAmount")

            db.AddInParameter(dbCommand, "@OfferID", DbType.Int32, Amount.OfferID)
            db.AddInParameter(dbCommand, "@MinAmount", DbType.Currency, Amount.MinAmount)
            db.AddInParameter(dbCommand, "@MaxAomount", DbType.Decimal, Amount.MaxAomount)
            db.AddInParameter(dbCommand, "@DisCountType", DbType.Int32, Amount.DisCountType)
            db.AddInParameter(dbCommand, "@DiscountExceed", DbType.Decimal, Amount.DiscountExceed)
            db.AddInParameter(dbCommand, "@Type", DbType.String, Amount.Type)
            db.AddInParameter(dbCommand, "@Type2", DbType.Int32, Amount.Type2)
            db.ExecuteNonQuery(dbCommand)
        End Sub


#End Region

#Region "---Private Method------"

        Private Shared Function FillSpecialOfferInfo(ByVal dr As IDataReader) As SpecialOfferInfo

            Dim objSO As New SpecialOfferInfo

            objSO.ConditionType = Utility.GetInt32(dr, "ConditionType")
            objSO.BonusType = Utility.GetInt32(dr, "BonusType")
            objSO.CouponID = Utility.GetInt32(dr, "CouponID")
            objSO.Detailedpromo = Utility.GetString(dr, "Detailedpromo")
            objSO.EndData = Utility.GetDateTime(dr, "EndDate")
            objSO.IsDispalyShortPromo = Utility.GetBoolean(dr, "IsDisplayShortPromo")
            objSO.IsValid = Utility.GetBoolean(dr, "IsValid")
            objSO.OfferID = Utility.GetInt32(dr, "OfferID")
            objSO.ShortPromoImage = Utility.GetString(dr, "ShortPromoImage")
            objSO.ShortPromoText = Utility.GetString(dr, "ShortPromoText")
            objSO.StartDate = Utility.GetDateTime(dr, "StartDate")
            objSO.Status = Utility.GetInt32(dr, "Status")
            objSO.Title = Utility.GetString(dr, "Title")

            Return objSO

        End Function

        Private Shared Function FillSpecialOfferProductsInfo(ByVal dr As IDataReader) As SpecialOfferProductsInfo

            Dim objSOP As New SpecialOfferProductsInfo
            objSOP.CategoryID = Utility.GetInt32(dr, "CategoryID")
            objSOP.CategoryName = Utility.GetString(dr, "CategoryName")
            objSOP.OfferID = Utility.GetInt32(dr, "OfferID")
            objSOP.ProductID = Utility.GetInt32(dr, "ProductID")
            objSOP.ProductName = Utility.GetString(dr, "ProductName")
            objSOP.Quantity = Utility.GetInt32(dr, "Quantity")
            objSOP.Type = Utility.GetString(dr, "Type")
            objSOP.Type2 = Utility.GetString(dr, "Type2")

            Return objSOP

        End Function

        Private Function FillSpecialOfferAmount(ByVal dr As IDataReader) As SpecialOfferAmountInfo
            Dim Amount As New SpecialOfferAmountInfo

            Amount.OfferID = Utility.GetInt32(dr, "OfferID")
            Amount.DiscountExceed = Utility.GetDecimal(dr, "DiscountExceed")
            Amount.DisCountType = Utility.GetInt32(dr, "DisCountType")
            Amount.MaxAomount = Utility.GetDecimal(dr, "MaxAomount")
            Amount.MinAmount = Utility.GetDecimal(dr, "MinAmount")
            Amount.Type = Utility.GetString(dr, "Type")
            Amount.Type2 = Utility.GetInt32(dr, "Type2")


            Return Amount
        End Function

        Private Function FillSpecialOfferBonusPrice(ByVal dr As IDataReader) As SpecialOfferBonusPriceInfo
            Dim product As New SpecialOfferBonusPriceInfo
            product.OfferID = Utility.GetInt32(dr, "OfferID")
            product.ProductID = Utility.GetInt32(dr, "ProductID")
            product.ProductName = Utility.GetString(dr, "ProductName")
            product.Price = Utility.GetDecimal(dr, "Price")
            product.AdjustPrice = Utility.GetDecimal(dr, "AdjustPrice")

            Return product
        End Function




#End Region


#End Region
#Region "-----Shop------"
        ''' <summary>
        ''' get available special offerid string by amount.
        ''' </summary>
        ''' <param name="miniAmount">amount in order </param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Shared Function GetAvailableSpecialOfferString(ByVal miniAmount As Decimal) As String
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_GetAvailableSpecialOfferAmountList")
            db.AddInParameter(dbCommand, "@MiniAmount", DbType.Decimal, miniAmount)

            Dim sOfferIDs As New StringBuilder
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    sOfferIDs.Append(String.Format(",{0}", reader.Item(0).ToString))
                End While
                If sOfferIDs.Length = 0 Then Return ""
                Return sOfferIDs.ToString.Substring(1)
            End Using
        End Function
        ''' <summary>
        '''  get available special offerid string by ProductID or CategoryID.
        ''' </summary>
        ''' <param name="value">productID or CategoryID</param>
        ''' <param name="type">category type:"C",product type:"P"</param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Shared Function GetAvailableSpecialOfferString(ByVal value As Integer, ByVal type As String) As String
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpecialOffer_GetAvailableSpecialOfferProdutsList")
            If type.ToLower = "c" Then
                db.AddInParameter(dbCommand, "@CategoryID", DbType.Int32, value)
            Else
                db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, value)
            End If

            Dim sOfferIDs As New StringBuilder
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    sOfferIDs.Append(String.Format(",{0}", reader.Item(0).ToString))
                End While
                If sOfferIDs.Length = 0 Then Return ""
                Return sOfferIDs.ToString.Substring(1)
            End Using
        End Function

#End Region




    End Class

End Namespace

