Imports System
Imports System.Configuration
Imports System.Data
Imports System.Data.Common
Imports System.Threading
Imports System.Web
Imports System.Collections.Generic
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports Microsoft.Practices.EnterpriseLibrary.Data


Namespace NetShopForge.Library.SpeedBar


    Public Class SpeedBarController
        Private Shared _Instance As SpeedBarController
        Public Shared ReadOnly Property Instance() As SpeedBarController
            Get
                If IsNothing(_Instance) Then
                    _Instance = New SpeedBarController
                End If
                Return _Instance
            End Get
        End Property

        Public Shared Function GetSpeedBarList() As List(Of SpeedBarInfo)
            Dim listSpeedBar As List(Of SpeedBarInfo)
            listSpeedBar = System.Web.HttpContext.Current.Cache("SpeedBar")
            If IsNothing(listSpeedBar) Then
                Dim db As Database = DatabaseFactory.CreateDatabase
                Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpeedBar_GetSpeedBarList")

                listSpeedBar = New List(Of SpeedBarInfo)
                Using reader As IDataReader = db.ExecuteReader(dbCommand)
                    While reader.Read
                        listSpeedBar.Add(FillSpeedBarInfo(reader))
                    End While
                    Return listSpeedBar
                End Using
            End If
            Return listSpeedBar


        End Function


        Public Sub ClearSpeedbarCache()
            If Not IsNothing(System.Web.HttpContext.Current.Cache("SpeedBar")) Then System.Web.HttpContext.Current.Cache("SpeedBar") = Nothing
        End Sub

        Public Function GetSpeedBar(ByVal speedBarID As Integer) As SpeedBarInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_SpeedBar_GetSpeedBar")
            db.AddInParameter(dbCommand, "BarID", DbType.Int32, speedBarID)

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillSpeedBarInfo(reader)
                End While
            End Using
            Return Nothing
        End Function

        Public Function AddSpeedBar(ByVal speedBar As SpeedBarInfo) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_SpeedBar_AddSpeedBar"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            Dim SpeedBarID As Integer = NetShopForge.Common.GetKeys("SpeedBarID")
            db.AddInParameter(dbCommand, "BarID", DbType.Int32, SpeedBarID)
            db.AddInParameter(dbCommand, "Title", DbType.String, speedBar.Title)
            db.AddInParameter(dbCommand, "URL", DbType.String, speedBar.URL)
            db.AddInParameter(dbCommand, "ToolTip", DbType.String, speedBar.ToolTip)
            db.AddInParameter(dbCommand, "ItemOrder", DbType.Int32, speedBar.ItemOrder)
            db.AddInParameter(dbCommand, "IsValid", DbType.Boolean, speedBar.IsValid)
            db.AddInParameter(dbCommand, "Css", DbType.String, speedBar.CSS)
            db.ExecuteNonQuery(dbCommand)
            Return SpeedBarID
        End Function

        Public Sub UpdateSpeedBar(ByVal SpeedBar As SpeedBarInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim sqlCommand As String = "nsf_SpeedBar_UpdateSpeedBar"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)
            db.AddInParameter(dbCommand, "BarID", DbType.Int32, SpeedBar.BarID)
            db.AddInParameter(dbCommand, "Title", DbType.String, SpeedBar.Title)
            db.AddInParameter(dbCommand, "URL", DbType.String, SpeedBar.URL)
            db.AddInParameter(dbCommand, "ToolTip", DbType.String, SpeedBar.ToolTip)
            db.AddInParameter(dbCommand, "ItemOrder", DbType.Int32, SpeedBar.ItemOrder)
            db.AddInParameter(dbCommand, "IsValid", DbType.Boolean, SpeedBar.IsValid)
            db.AddInParameter(dbCommand, "Css", DbType.String, SpeedBar.CSS)

            db.ExecuteNonQuery(dbCommand)

        End Sub

        Public Sub UpdateSpeedBarQuick(ByVal BarID As Integer, ByVal itemOrder As Integer, ByVal IsValid As Boolean)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim sqlCommand As String = "nsf_SpeedBar_UpdateSpeedBarQuick"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)
            db.AddInParameter(dbCommand, "BarID", DbType.Int32, BarID)
            db.AddInParameter(dbCommand, "ItemOrder", DbType.Int32, itemOrder)
            db.AddInParameter(dbCommand, "IsValid", DbType.Boolean, IsValid)
            db.ExecuteNonQuery(dbCommand)
        End Sub

        Public Sub DeleteSpeedBar(ByVal speedBarID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim sqlCommand As String = "nsf_SpeedBar_DeleteSpeedBar"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "BarID", DbType.Int32, speedBarID)
            db.ExecuteNonQuery(dbCommand)
        End Sub

        Private Shared Function FillSpeedBarInfo(ByVal reader As IDataReader) As SpeedBarInfo

            Dim SpeedBar As New SpeedBarInfo
            SpeedBar.BarID = reader("BarID")
            SpeedBar.IsValid = reader("IsValid")
            SpeedBar.ItemOrder = reader("ItemOrder")
            SpeedBar.Title = reader("Title")
            SpeedBar.ToolTip = reader("ToolTip")
            SpeedBar.URL = reader("URL")
            SpeedBar.CSS = reader("css")
            Return SpeedBar
        End Function

    End Class
End Namespace
