
Imports System.Data
Imports System.Data.Common
Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Common
Namespace NetShopForge.Library.Tracker


    Public Class TrackerController

        Public Shared Function GetByBehaviorID(ByVal behaviorID As Integer) As IDataReader

            Dim db As Database = DatabaseFactory.CreateDatabase()
            'retrieve data from database
            Dim cmd As DbCommand = db.GetStoredProcCommand("NSF_Tracker_GetByBehaviorID")
            db.AddInParameter(cmd, "@behaviorID", DbType.Int32, behaviorID)

            Return db.ExecuteReader(cmd)
        End Function

        Public Shared Sub SynchTrackingCookie(ByVal userName As String, ByVal trackerCookie As String)

            Dim db As Database = DatabaseFactory.CreateDatabase()
            'retrieve data from database
            Dim cmd As DbCommand = db.GetStoredProcCommand("NSF_Tracker_SynchTrackingCookie")
            db.AddInParameter(cmd, "@userName", DbType.String, userName)
            db.AddInParameter(cmd, "@trackerCookie", DbType.String, trackerCookie)
            db.ExecuteNonQuery(cmd)

        End Sub


        Public Shared Function GetRecentlyViewedProducts(ByVal username As String) As IDataReader

            Dim db As Database = DatabaseFactory.CreateDatabase()
            'retrieve data from database
            Dim cmd As DbCommand = db.GetStoredProcCommand("NSF_Tracker_GetRecentlyViewedProducts")
            db.AddInParameter(cmd, "@username", DbType.String, username)

            Return db.ExecuteReader(cmd)

        End Function

        Public Shared Function GetByProductAndBehavior(ByVal behaviorID As Integer, ByVal sku As String) As IDataReader

            Dim db As Database = DatabaseFactory.CreateDatabase()
            'retrieve data from database
            Dim cmd As DbCommand = db.GetStoredProcCommand("NSF_Tracker_GetByProductAndBehavior")
            db.AddInParameter(cmd, "@behaviorID", DbType.Int32, behaviorID)
            db.AddInParameter(cmd, "@sku", DbType.String, sku)

            Return db.ExecuteReader(cmd)
        End Function

        Public Shared Sub Add(ByVal behavior As BehaviorType, ByVal categoryID As Integer, ByVal productID As String, ByVal searchString As String)
            Add(behavior, categoryID, productID, searchString, 0, 0, "")
        End Sub

        Public Shared Sub Add(ByVal behavior As BehaviorType, ByVal productID As String)
            Add(behavior, 0, productID, "", 0, 0, "")
        End Sub
     
        Public Shared Sub Add(ByVal behavior As BehaviorType, ByVal categoryID As Integer)
            Add(behavior, categoryID, "", "", 0, 0, "")
        End Sub

        Public Shared Sub Add(ByVal behavior As BehaviorType)
            Add(behavior, 0, "", "", 0, 0, "")
        End Sub

        Public Shared Function Add(ByVal track As TrackerInfo) As Integer

            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Tracker_AddTracker"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            Dim TrackingID As Integer = NetShopForge.Common.GetKeys("TrackingID")

            db.AddInParameter(dbCommand, "TrackingID", DbType.Int32, TrackingID)
            db.AddInParameter(dbCommand, "UserName", DbType.String, track.UserName)
            db.AddInParameter(dbCommand, "AdID", DbType.Int32, track.AdID)
            db.AddInParameter(dbCommand, "PromoID", DbType.Int32, track.PromoID)
            db.AddInParameter(dbCommand, "ProductID", DbType.String, track.ProductID)
            db.AddInParameter(dbCommand, "CategoryID", DbType.Int32, track.CategoryID)
            db.AddInParameter(dbCommand, "PageURL", DbType.String, track.PageURL)
            db.AddInParameter(dbCommand, "BehaviorID", DbType.Int32, CInt(track.Behavior))
            db.AddInParameter(dbCommand, "SearchString", DbType.String, track.SearchString)
            db.AddInParameter(dbCommand, "SessionID", DbType.String, track.SessionID)
            db.ExecuteNonQuery(dbCommand)
            Return TrackingID
        End Function


     
        Public Shared Sub Add(ByVal behavior As BehaviorType, ByVal categoryID As Integer, ByVal productID As String, ByVal searchString As String, ByVal adID As Integer, ByVal promoID As Integer, ByVal pageUrl As String)

            'get the page from the server
            If pageUrl Is String.Empty Then
                pageUrl = System.Web.HttpContext.Current.Request.Url.PathAndQuery
            End If

            'INSTANT VB NOTE: The local variable sessionID was renamed since Visual Basic will not uniquely identify class members when local variables have the same name:
            Dim sessionID As String = System.Web.HttpContext.Current.Session.SessionID

            Dim track As TrackerInfo = New TrackerInfo()
            track.Behavior = behavior
            track.CategoryID = categoryID
            track.ProductID = productID
            track.SearchString = searchString
            track.AdID = adID
            track.PromoID = promoID
            track.PageURL = pageUrl
            track.SessionID = sessionID
            track.UserName = My.User.Name
            Add(track)

        End Sub


        Friend Shared Function FillTrackerInfo(ByVal reader As IDataReader) As TrackerInfo
            Dim track As New TrackerInfo
            track.TrackingID = reader("TrackingID")
            track.UserName = reader("UserName")
            track.AdID = reader("AdID")
            track.PromoID = reader("PromoID")
            track.ProductID = reader("ProductID")
            track.CategoryID = reader("CategoryID")
            track.PageURL = reader("PageURL")
            track.Behavior = CType(reader("BehaviorID"), BehaviorType)
            track.SearchString = reader("SearchString")
            track.SessionID = reader("SessionID")
            track.CreatedOn = CDate(reader("CreatedOn"))
            Return track

        End Function

    End Class

    Public Enum BehaviorType As Integer
        BrowsingCategory = 1
        BrowsingProduct = 2
        ClickingOnAd = 3
        ClickingOnPromo = 4
        ClickingOnUpsell = 5
        ClickingOnCrosssell = 6
        ClickingOnBundle = 7
        RunningSearch = 8
        AddingItemToBasket = 9
        CheckingOut = 10
        Paying = 11
        ViewingReceipt = 12
        RemovingItemFromBasket = 13
        AdjustingQuantity = 14
        LoggingIn = 15
        LoggingOut = 16
    End Enum

End Namespace