Imports Microsoft.VisualBasic
Imports System


Namespace NetShopForge.Library.Tracker


    Public Enum SortFilter
        ItemCount
        LastVisited
    End Enum

    Public Enum SortOrder
        Ascending
        Descending
    End Enum

    Public Class TrackedItem
        Implements IComparable

        Private _itemID As Integer

        Public Property ItemID() As Integer
            Get
                Return _itemID
            End Get
            Set(ByVal value As Integer)
                _itemID = value
            End Set
        End Property
        Private itemNumber_Renamed As String

        Public Property ItemNumber() As String
            Get
                Return itemNumber_Renamed
            End Get
            Set(ByVal value As String)
                itemNumber_Renamed = value
            End Set
        End Property

        Private _itemName As String

        Public Property ItemName() As String
            Get
                Return _itemName
            End Get
            Set(ByVal value As String)
                _itemName = value
            End Set
        End Property

        Private _itemCount As Integer

        Public Property ItemCount() As Integer
            Get
                Return _itemCount
            End Get
            Set(ByVal value As Integer)
                _itemCount = value
            End Set
        End Property
        Private _lastVisited As DateTime

        Public Property LastVisited() As DateTime
            Get
                Return _lastVisited
            End Get
            Set(ByVal value As DateTime)
                _lastVisited = value
            End Set
        End Property
        Private _imagePath As String

        Public Property ImagePath() As String
            Get
                Return _imagePath
            End Get
            Set(ByVal value As String)
                _imagePath = value
            End Set
        End Property

 


        Private sortingBy_Renamed As SortFilter = SortFilter.ItemCount
        Public Property SortingBy() As SortFilter
            Get
                Return sortingBy_Renamed
            End Get
            Set(ByVal value As SortFilter)
                sortingBy_Renamed = value
            End Set
        End Property

        Private sortingOrder_Renamed As SortOrder = SortOrder.Ascending
        Public Property SortingOrder() As SortOrder
            Get
                Return sortingOrder_Renamed
            End Get
            Set(ByVal value As SortOrder)
                sortingOrder_Renamed = value
            End Set
        End Property
#Region "IComparable "

        Public Function CompareTo(ByVal o As Object) As Integer Implements IComparable.CompareTo
            If Not (TypeOf o Is TrackedItem) Then
                Throw New InvalidCastException("Not a valid TrackedItem")
            End If
            Dim fav As TrackedItem = CType(o, TrackedItem)
            Select Case SortingBy
                Case SortFilter.ItemCount
CaseLabel1:
                    If sortingOrder_Renamed = SortOrder.Ascending Then
                        Return Me.ItemCount.CompareTo(fav.ItemCount)
                    Else
                        Return fav.ItemCount.CompareTo(Me.ItemCount)
                    End If
                Case SortFilter.LastVisited
                    If sortingOrder_Renamed = SortOrder.Ascending Then
                        Return Me.LastVisited.CompareTo(fav.LastVisited)
                    Else
                        Return fav.LastVisited.CompareTo(Me.LastVisited)
                    End If
                Case Else
                    GoTo CaseLabel1
            End Select
        End Function

#End Region
    End Class


End Namespace