Imports System
Imports System.Configuration
Imports System.Data
Imports System.Data.Common
Imports System.Threading
Imports System.Web
Imports System.Collections.Generic
Imports AspNetProfile = System.Web.Profile
Imports AspNetSecurity = System.Web.Security
Imports NetShopForge.Common.Utilities
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports Microsoft.Practices.EnterpriseLibrary.Data


Namespace NetShopForge.Library.User

    Public Class UserController

#Region "Private Methods"

        Private Function DeleteUser(ByVal UserId As Integer, ByVal notify As Boolean, ByVal deleteAdmin As Boolean) As Boolean

            Dim objUser As UserInfo = Me.GetUser(UserId)

            Dim CanDelete As Boolean = True
            If objUser.UserType = UserType.Administrator Then CanDelete = deleteAdmin
            If CanDelete Then
                If notify Then
                    'Todo:  send email notification to portal administrator that the user was removed
                    ' send email notification to portal administrator that the user was removed 
                    '''''''''''''  NetShopForge.Services.Mail.Mail.SendMail()
                End If

                ' Explicit call to delete user profile data.
                AspNetProfile.ProfileManager.DeleteProfile(objUser.UserName)
                AspNetSecurity.Membership.DeleteUser(objUser.UserName, True)

                'TODO:When delete a user, delete user's role
                'Process Role
                'Dim objRole As New RoleController
                Dim db As Database = DatabaseFactory.CreateDatabase()

                Dim sqlCommand As String = "nsf_User_DeleteUser"
                Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

                ' Retrieve products from the specified category.
                db.AddInParameter(dbCommand, "UserId", DbType.Int32, UserId)
                db.ExecuteNonQuery(dbCommand)

            End If

            'Todo: I don't know if a datacache process
            'Dim UserInfoCacheKey As String = GetCacheKey(objUser.UserName)
            'DataCache.RemoveCache(UserInfoCacheKey)

            Return CanDelete


        End Function

#End Region

#Region "Friends Methods"

        Friend Function FillUserInfo(ByVal reader As IDataReader) As UserInfo

            Dim objUserInfo As New UserInfo
            objUserInfo.UserID = Integer.Parse(reader("UserID").ToString)
            objUserInfo.UserName = reader("UserName").ToString
            objUserInfo.UserType = reader("UserType").ToString
            objUserInfo.Title = reader("Title").ToString
            objUserInfo.ShipName = reader("ShipName").ToString
            objUserInfo.ShipCounTry = reader("ShipCountry").ToString
            objUserInfo.ShipState = reader("ShipState").ToString
            objUserInfo.ShipCity = reader("ShipCity").ToString
            objUserInfo.ShipAddress = reader("ShipAddress").ToString
            objUserInfo.ShipPostalcode = reader("ShipPostalcode").ToString
            objUserInfo.ShipPhone = reader("ShipPhone").ToString
            objUserInfo.BillingName = reader("BillingName").ToString
            objUserInfo.BillingCounTry = reader("BillingCountry").ToString
            objUserInfo.BillingState = reader("BillingState").ToString
            objUserInfo.BillingCity = reader("BillingCity").ToString
            objUserInfo.BillingAddress = reader("BillingAddress").ToString
            objUserInfo.BillingPostalCode = reader("BillingPostalCode").ToString
            objUserInfo.BillingPhone = reader("BillingPhone").ToString
            objUserInfo.Email = reader("Email").ToString
            objUserInfo.QQ = reader("QQ").ToString
            objUserInfo.MSN = reader("MSN").ToString
            objUserInfo.MobilePhone = reader("MobilePhone").ToString
            '       objUserInfo.LastActivityDate = reader("LastActivityDate")
            Return objUserInfo
        End Function
        'Friend Function FillUserMembership(ByVal objUserInfo As UserInfo) As UserMembership


        '    Dim objMembershipUser As AspNetSecurity.MembershipUser
        '    objMembershipUser = AspNetSecurity.Membership.GetUser(objUserInfo.UserName)

        '    Dim u As New UserMembership
        '    Try
        '        u.Approved = objMembershipUser.IsApproved
        '    Catch
        '    End Try
        '    Try
        '        u.LockedOut = objMembershipUser.IsLockedOut
        '    Catch
        '    End Try
        '    Try
        '        u.Username = objMembershipUser.UserName
        '    Catch
        '    End Try
        '    Try
        '        u.Password = objMembershipUser.GetPassword()
        '    Catch
        '    End Try
        '    Try
        '        u.CreatedDate = objMembershipUser.CreationDate
        '    Catch
        '    End Try
        '    Try
        '        u.LastLoginDate = objMembershipUser.LastLoginDate
        '    Catch
        '    End Try
        '    Try
        '        u.Email = objMembershipUser.Email
        '    Catch
        '    End Try
        '    Try
        '        u.LastLockoutDate = objMembershipUser.LastLockoutDate
        '    Catch
        '    End Try
        '    Return u

        'End Function

#End Region

#Region "Public Methods"

        Public Function AddUser(ByVal objUser As UserInfo) As Integer
            Dim UserId As Integer = -1
            'Dim Status As UserRegistrationStatus

            '' check if username exists in database for any portal
            'Dim objVerifyUser As UserInfo = GetUserByUsername(objUser.Membership.Username)
            'If objVerifyUser Is Nothing Then
            '    Status = UserRegistrationStatus.AddUser
            'Else
            '    Status = UserRegistrationStatus.UsernameAlreadyExists
            'End If

            'If Status = UserRegistrationStatus.AddUser Then
            Dim objStatus As AspNetSecurity.MembershipCreateStatus = AspNetSecurity.MembershipCreateStatus.Success

            Try
                Dim db As Database = DatabaseFactory.CreateDatabase()

                Dim sqlCommand As String = "nsf_User_AddUser"
                Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

                ' Retrieve products from the specified category.
                db.AddInParameter(dbCommand, "usertype", DbType.Int32, CInt(objUser.UserType))
                db.AddInParameter(dbCommand, "username", DbType.String, objUser.UserName)
                db.AddInParameter(dbCommand, "title", DbType.String, objUser.Title)
                db.AddInParameter(dbCommand, "shipname", DbType.String, objUser.ShipName)
                db.AddInParameter(dbCommand, "shipcounTry", DbType.String, objUser.ShipCounTry)
                db.AddInParameter(dbCommand, "shipstate", DbType.String, objUser.ShipState)
                db.AddInParameter(dbCommand, "shipcity", DbType.String, objUser.ShipCity)
                db.AddInParameter(dbCommand, "shipaddress", DbType.String, objUser.ShipAddress)
                db.AddInParameter(dbCommand, "shippostalcode", DbType.String, objUser.ShipPostalcode)
                db.AddInParameter(dbCommand, "shipphone", DbType.String, objUser.ShipPhone)
                db.AddInParameter(dbCommand, "billingname", DbType.String, objUser.BillingName)
                db.AddInParameter(dbCommand, "billingcounTry", DbType.String, objUser.BillingCounTry)
                db.AddInParameter(dbCommand, "billingstate", DbType.String, objUser.BillingState)
                db.AddInParameter(dbCommand, "billingcity", DbType.String, objUser.BillingCity)
                db.AddInParameter(dbCommand, "billingaddress", DbType.String, objUser.BillingAddress)
                db.AddInParameter(dbCommand, "billingpostalcode", DbType.String, objUser.BillingPostalCode)
                db.AddInParameter(dbCommand, "billingphone", DbType.String, objUser.BillingPhone)
                db.AddInParameter(dbCommand, "email", DbType.String, objUser.Email)
                db.AddInParameter(dbCommand, "qq", DbType.String, objUser.QQ)
                db.AddInParameter(dbCommand, "msn", DbType.String, objUser.MSN)
                db.AddInParameter(dbCommand, "mobilephone", DbType.String, objUser.MobilePhone)
                db.AddOutParameter(dbCommand, "userid", DbType.Int32, 20)
                db.ExecuteNonQuery(dbCommand)

                UserId = db.GetParameterValue(dbCommand, "userID")
            Catch ex As Exception
                UserId = -1
                AspNetSecurity.Membership.DeleteUser(objUser.UserName)
            End Try

            ' End If

          '  Return UserId


        End Function

        Public Function DeleteUser(ByVal UserId As Integer) As Boolean
            'Call private method with notify=true, deleteAdmin=false
            Return DeleteUser(UserId, False, False)
        End Function

        Public Function GetCacheKey(ByVal Username As String) As String
            Return "UserInfo|" + Username
        End Function

        Public Function GetAdmins() As List(Of UserInfo)
            Dim Users As New List(Of UserInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_User_GetAdmin")
            ' Add paramters
            ' Input parameters can specify the input value

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Users.Add(FillUserInfo(reader))
                End While
                Return Users
            End Using
        End Function

        Public Function GetUser(ByVal userID As String) As UserInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_User_GetUser")
            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@UserID", DbType.Int32, userID)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillUserInfo(reader)
                End While
                Return Nothing
            End Using
        End Function

        Public Function GetUserName(ByVal userID As String) As String
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_User_GetUserName")
            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@UserID", DbType.Int32, userID)
          
            Return db.ExecuteScalar(dbCommand)
        End Function

        Public Function GetUserByUsername(ByVal Username As String) As UserInfo

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_User_GetUserByUserName")
            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@Username", DbType.String, Username)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillUserInfo(reader)
                End While
                Return Nothing
            End Using

        End Function

        Public Function GetUsers(ByVal pageSize As Integer, ByVal pageIndex As Integer, Optional ByVal sqlWhere As String = "", Optional ByVal isDesc As Boolean = False) As List(Of UserInfo)

            Dim Users As New Generic.List(Of UserInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_User_GetUserListByPage")

            db.AddInParameter(dbCommand, "@pagesize", DbType.Int32, pageSize)
            db.AddInParameter(dbCommand, "@pageindex", DbType.Int32, pageIndex)
            db.AddInParameter(dbCommand, "@OrderType", DbType.Boolean, isDesc)
            If sqlWhere.Length > 0 Then db.AddInParameter(dbCommand, "@SqlWhere", DbType.String, sqlWhere)


            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Users.Add(FillUserInfo(reader))
                End While
                Return Users
            End Using

        End Function


        Public Sub UpdateUser(ByVal objUser As UserInfo)


            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_User_UpdateUser")
            ' Add paramters
            ' Input parameters can specify the input value

            db.AddInParameter(dbCommand, "UserName", DbType.String, objUser.UserName)
            db.AddInParameter(dbCommand, "UserType", DbType.String, CInt(objUser.UserType).ToString)
            db.AddInParameter(dbCommand, "Title", DbType.String, objUser.Title)
            db.AddInParameter(dbCommand, "ShipName", DbType.String, objUser.ShipName)
            db.AddInParameter(dbCommand, "ShipCountry", DbType.String, objUser.ShipCounTry)
            db.AddInParameter(dbCommand, "ShipState", DbType.String, objUser.ShipState)
            db.AddInParameter(dbCommand, "ShipCity", DbType.String, objUser.ShipCity)
            db.AddInParameter(dbCommand, "ShipAddress", DbType.String, objUser.ShipAddress)
            db.AddInParameter(dbCommand, "ShipPostalcode", DbType.String, objUser.ShipPostalcode)
            db.AddInParameter(dbCommand, "ShipPhone", DbType.String, objUser.ShipPhone)
            db.AddInParameter(dbCommand, "BillingName", DbType.String, objUser.BillingName)
            db.AddInParameter(dbCommand, "BillingCountry", DbType.String, objUser.BillingCounTry)
            db.AddInParameter(dbCommand, "BillingState ", DbType.String, objUser.BillingState)
            db.AddInParameter(dbCommand, "BillingCity ", DbType.String, objUser.BillingCity)
            db.AddInParameter(dbCommand, "BillingAddress ", DbType.String, objUser.BillingAddress)
            db.AddInParameter(dbCommand, "BillingPostalCode ", DbType.String, objUser.BillingPostalCode)
            db.AddInParameter(dbCommand, "BillingPhone ", DbType.String, objUser.BillingPhone)
            db.AddInParameter(dbCommand, "Email", DbType.String, objUser.Email)
            db.AddInParameter(dbCommand, "QQ", DbType.String, objUser.QQ)
            db.AddInParameter(dbCommand, "MSN", DbType.String, objUser.MSN)
            db.AddInParameter(dbCommand, "MobilePhone", DbType.String, objUser.MobilePhone)

            Dim objMembershipUser As AspNetSecurity.MembershipUser
            objMembershipUser = AspNetSecurity.Membership.GetUser(objUser.UserName)
            objMembershipUser.Email = objUser.Email
            objMembershipUser.LastActivityDate = Now
            AspNetSecurity.Membership.UpdateUser(objMembershipUser)

            db.ExecuteNonQuery(dbCommand)


        End Sub


#End Region

    End Class


End Namespace
