
Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports System.Data.SqlClient
Imports System.Data.Common
Imports System.Data
Imports System.Collections.Generic
Imports System.Text
Imports NetShopForge.Common
Imports NetShopForge.Library.Category
Imports NetShopForge.Library.Order

Namespace NetShopForge.Library.WantBuy

    Public Class WantBuyController

        Private Shared _Instance As WantBuyController
        Public Shared ReadOnly Property Instance() As WantBuyController
            Get
                If IsNothing(_Instance) Then
                    _Instance = New WantBuyController
                End If
                Return _Instance
            End Get
        End Property
        Public Function GetChineseWantBuyType(ByVal status As WantBuy.WantBuyType) As String
            Dim s As String = ""
            Select Case status
                Case WantBuyType.auction
                    s = "Ĺ"
                Case WantBuyType.buy
                    s = ""
            End Select
            Return s
        End Function
        Public Function AddWantBuy(ByVal userName As String, ByVal productName As String, ByVal url As String, ByVal type As WantBuyType, ByVal feature As String, ByVal comment As String, ByVal addressID As Integer) As Integer

            Try

        
                Dim db As Database = DatabaseFactory.CreateDatabase()

                Dim sqlCommand As String = "nsf_WantBuy_AddWantBuy"
                Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)
                Dim WantBuyID As Integer = GetKeys("WantBuyID")


                db.AddInParameter(dbCommand, "@WantBuyID", DbType.Int32, WantBuyID)
                db.AddInParameter(dbCommand, "@ProductName", DbType.String, productName)
                db.AddInParameter(dbCommand, "@URL", DbType.String, url)
                db.AddInParameter(dbCommand, "@Feature", DbType.String, feature)
                db.AddInParameter(dbCommand, "@Comment", DbType.String, comment)
                db.AddInParameter(dbCommand, "@Type", DbType.Int32, CInt(type))
                db.AddInParameter(dbCommand, "@UserName", DbType.String, userName)
                db.AddInParameter(dbCommand, "@WantBuyNumber", DbType.String, GetWantBuyNumber)
                db.AddInParameter(dbCommand, "@OrderStatus", DbType.Int32, CInt(Order.OrderStatus.NotProcessed))
                db.AddInParameter(dbCommand, "@AddressID", DbType.Int32, addressID)


                db.ExecuteNonQuery(dbCommand)
                Return WantBuyID
            Catch ex As Exception
                Return -1
            End Try
        End Function

        Public Function UpdateWantBuyOrderStatus(ByVal wantBuyID As Integer, ByVal OrderStatus As OrderStatus) As String

            Try
                Dim db As Database = DatabaseFactory.CreateDatabase()

                Dim sqlCommand As String = "nsf_WantBuy_UpdateOrderStatus"
                Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

                db.AddInParameter(dbCommand, "@WantBuyID", SqlDbType.Int, WantBuyID)
                db.AddInParameter(dbCommand, "@OrderStatus", SqlDbType.Int, CInt(OrderStatus))
                db.ExecuteNonQuery(dbCommand)

                Return ""
            Catch ex As Exception
                Return ex.Message
            End Try
        
        End Function




        Public Function UpdateWantBuy(ByVal wantbuyid As Integer, ByVal productName As String, ByVal url As String, ByVal type As WantBuyType, ByVal feature As String, ByVal comment As String, ByVal addressID As Integer) As String
            Try
                Dim db As Database = DatabaseFactory.CreateDatabase()

                Dim sqlCommand As String = "nsf_WantBuy_UpdateWantBuy"
                Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

                db.AddInParameter(dbCommand, "@WantBuyID", DbType.Int32, wantbuyid)
                db.AddInParameter(dbCommand, "@ProductName", DbType.String, productName)
                db.AddInParameter(dbCommand, "@URL", DbType.String, url)
                db.AddInParameter(dbCommand, "@Feature", DbType.String, feature)
                db.AddInParameter(dbCommand, "@Comment", DbType.String, comment)
                db.AddInParameter(dbCommand, "@Type", DbType.Int32, CInt(type))
                db.AddInParameter(dbCommand, "@AddressID", DbType.Int32, addressID)


                db.ExecuteNonQuery(dbCommand)
                Return ""
            Catch ex As Exception
                Return ex.Message
            End Try

        End Function

        Public Sub DeleteWantBuy(ByVal wantBuyID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_WantBuy_DeleteWantBuy"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)
            db.AddInParameter(dbCommand, "@wantBuyID", DbType.Int32, wantBuyID)

            db.ExecuteNonQuery(dbCommand)

        End Sub

        Public Function GetWantBuyListNumber(ByVal sqlWhere As String) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_WantBuy_GetWantBuyList")

            db.AddInParameter(dbCommand, "@IsCount", DbType.Boolean, True)
            If sqlWhere.Length > 0 Then db.AddInParameter(dbCommand, "@SqlWhere", DbType.String, sqlWhere)

            Return CInt(db.ExecuteScalar(dbCommand))
        End Function
        Public Function GetWantBuyList(ByVal pageSize As Integer, ByVal pageIndex As Integer, Optional ByVal sqlWhere As String = "", Optional ByVal isDesc As Boolean = True) As List(Of WantBuyInfo)

            Dim objWantBuyList As New List(Of WantBuyInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_WantBuy_GetWantBuyList")
         
            db.AddInParameter(dbCommand, "@pagesize", DbType.Int32, pageSize)
            db.AddInParameter(dbCommand, "@pageindex", DbType.Int32, pageIndex)
            db.AddInParameter(dbCommand, "@OrderType", DbType.Boolean, isDesc)
            If sqlWhere.Length > 0 Then db.AddInParameter(dbCommand, "@SqlWhere", DbType.String, sqlWhere)

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    objWantBuyList.Add(FillWantBuyInfo(reader))
                End While
                Return objWantBuyList
            End Using



        End Function


        Public Function GetWantBuy(ByVal wantBuyID As Integer) As WantBuyInfo

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_WantBuy_GetWantBuy")
            db.AddInParameter(dbCommand, "@wantBuyID", DbType.Int32, wantBuyID)

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    Return FillWantBuyInfo(reader)
                End While
            End Using
            Return Nothing
        End Function


        Private Function GetWantBuyNumber() As String
            Dim random As Random = New Random()
            Return Now.ToString("yyyyMMddHHmmss") & random.Next(0, 9999).ToString("####0000")
        End Function

#Region "---Private Method---"
        Private Function FillWantBuyInfo(ByVal dr As IDataReader) As WantBuyInfo
            Dim WBI As New WantBuyInfo
            WBI.WantBuyNumber = dr.Item("wantBuyNumber")
            WBI.UserName = dr.Item("UserName")
            WBI.Comment = dr.Item("Comment")
            WBI.Feature = dr.Item("Feature")
            WBI.ProductName = dr.Item("ProductName")
            WBI.Type = Integer.Parse(dr.Item("Type"))
            WBI.URL = dr.Item("URL")
            WBI.WantBuyID = dr.Item("WantBuyID")
            WBI.OrderStatus = CInt(dr.Item("OrderStatus"))
            WBI.UpdateDate = dr.Item("UpdateDate")
            WBI.AddressID = dr.Item("AddressID")
            Return WBI

        End Function

#End Region


    End Class

End Namespace
