
Imports Microsoft.Practices.EnterpriseLibrary.Data
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports System.Data.SqlClient
Imports System.Data.Common
Imports System.Data
Imports System.Collections.Generic
Imports System.Text
Imports NetShopForge.Common
Imports NetShopForge.Library.Category

Namespace NetShopForge.Library.WishList

    Public Class WishController

        Public Shared Function AddProductReview(ByVal productID As Integer, ByVal userName As String) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_WishList_AddWishList"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)
            Dim WishID As Integer = GetKeys("WishID")

            db.AddInParameter(dbCommand, "@WishID", DbType.Int32, WishID)
            db.AddInParameter(dbCommand, "@ProductID", DbType.Int32, productID)
            db.AddInParameter(dbCommand, "@UserName", DbType.String, userName)

            db.ExecuteNonQuery(dbCommand)
            Return WishID

        End Function

        Public Shared Sub DeleteProductReview(ByVal wishID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_WishList_DeleteWishList"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)
            db.AddInParameter(dbCommand, "@WishID", DbType.Int32, wishID)

            db.ExecuteNonQuery(dbCommand)

        End Sub


        Public Shared Function GetWhishListUser() As List(Of WishListUserInfo)


            Dim objWLUList As New List(Of WishListUserInfo)

            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_WishList_GetWishListByUser")
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    objWLUList.Add(FillWishListUserInfo(reader))
                End While
                Return objWLUList
            End Using


        End Function


        Public Shared Function GetWishList(ByVal UserName As String) As List(Of WishListInfo)
            Dim objWLList As New List(Of WishListInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_WishList_GetWishList")
            db.AddInParameter(dbCommand, "@UserName", DbType.String, UserName.Replace("'", "''"))

            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    objWLList.Add(FillWishListInfo(reader))
                End While
                Return objWLList
            End Using

        End Function

#Region "---Private Method---"

        Private Shared Function FillWishListUserInfo(ByVal dr As IDataReader) As WishListUserInfo

            Dim objWLU As New WishListUserInfo
            objWLU.UserName = dr.Item("UserName")
            objWLU.ItemCount = CInt(dr.Item("ItemCount"))

            Return objWLU

        End Function


        Private Shared Function FillWishListInfo(ByVal dr As IDataReader) As WishListInfo
            Dim WLI As New WishListInfo

            WLI.UserName = dr.Item("UserName")
            WLI.WishID = dr.Item("WishID")
            WLI.ProductID = dr.Item("ProductID")
            WLI.ProductName = dr.Item("ProductName")
            WLI.ProductCode = dr.Item("ProductCode")
            WLI.ImagePath = dr.Item("ImagePath")
            Return WLI

        End Function

#End Region


    End Class

End Namespace
