Imports System
Imports System.Drawing
Imports System.Drawing.Imaging
Imports System.IO
Imports System.Drawing.Drawing2D
Imports System.Web
Imports System.Net
Imports System.Web.UI



Namespace NetShopForge.Common.nsfImage

    Public Class ImageController


#Region "---Private Member---"

        Private Const NoFileMessage As String = "ûѡļ"
        Private Const UploadSuccessMessage As String = ""
        Private Const UploadFailureMessage As String = "ϴʧܡ"
        Private Const NoImagesMessage As String = "ļвڻǿյ"
        Private Const NoFileToDeleteMessage As String = "ûѡҪɾļ"
        Private Const InvalidFileTypeMessage As String = "޷ϴ͵ļ"
        Private Const InvalidFileSizeMessage As String = "Image size exceeding limits"
        Private AcceptedImageFileTypes() As String = {".jpg", ".jpeg", ".jpe", ".gif", ".png"}
        Private Const MinSize As Integer = 1 * 1024
        Private Const MaxSize As Integer = 300 * 1024
#End Region

        Public Function UploadImage(ByVal File As HttpPostedFile, ByVal savePath As String, ByVal saveName As String) As String

            If File.FileName.Trim().Length = 0 Then Return NoFileMessage
            If Not IsValidFileType(Path.GetExtension(File.FileName).ToLower) Then Return InvalidFileTypeMessage
            If Not IsValidContentLength(MinSize, MaxSize, File.ContentLength) Then Return InvalidFileSizeMessage & ":" & File.ContentLength / 1024

            Try
                savePath = HttpContext.Current.Request.PhysicalApplicationPath & savePath
                If Not System.IO.Directory.Exists(savePath) Then System.IO.Directory.CreateDirectory(savePath)

                Dim fileName As String = savePath & "\" & saveName & Path.GetExtension(File.FileName).ToLower

                If (File.FileName.Substring(0, 4).ToLower = "http") Then
                    Return DownloadFile(File, fileName)
                Else
                    File.SaveAs(fileName)
                End If

                Return UploadSuccessMessage
            Catch ex As Exception
                Return UploadFailureMessage
            End Try

        End Function
        Public Function UploadImage(ByVal File As HttpPostedFile, ByVal savePath As String, ByVal saveName As String, ByVal ThumbWidth As Integer, ByVal ThumbHeight As Integer) As String
            If File.FileName.Trim().Length = 0 Then Return NoFileMessage
            If Not IsValidFileType(Path.GetExtension(File.FileName).ToLower) Then Return InvalidFileTypeMessage
            If Not IsValidContentLength(MinSize, MaxSize, File.ContentLength) Then Return InvalidFileSizeMessage & ":" & File.ContentLength / 1024

            Try
                savePath = HttpContext.Current.Request.PhysicalApplicationPath & savePath
                If Not System.IO.Directory.Exists(savePath) Then System.IO.Directory.CreateDirectory(savePath)

                Dim fileName As String = savePath & "\" & saveName & Path.GetExtension(File.FileName).ToLower

                If (File.FileName.Substring(0, 4).ToLower = "http") Then
                    Return DownloadFile(File, fileName, ThumbWidth, ThumbHeight)
                Else
                    SaveThumbnailImage(File, ThumbWidth, ThumbHeight, fileName)
                End If

                Return UploadSuccessMessage
            Catch ex As Exception
                Return UploadFailureMessage
            End Try
        End Function

#Region "---Private Method---"

        Private Function IsValidFileType(ByVal fileExtension As String) As Boolean

            For i As Integer = 0 To AcceptedImageFileTypes.Length - 1
                If fileExtension = AcceptedImageFileTypes(i) Then
                    Return True
                    Exit For
                End If
            Next i
            Return False

        End Function
        Private Function IsValidContentLength(ByVal minSize As Integer, ByVal maxSize As Integer, ByVal ContentLength As Integer) As Boolean

            '     Return Not (ContentLength < minSize Or ContentLength > maxSize)
            Return True
        End Function


        Private Function DownloadFile(ByVal File As HttpPostedFile, ByVal fileName As String) As String
            Try
                Dim client1 As New WebClient
                client1.DownloadFile(File.FileName, fileName)
                Return UploadSuccessMessage
            Catch exception1 As Exception
                Return (exception1.Message)
            End Try
        End Function

        Private Function DownloadFile(ByVal File As HttpPostedFile, ByVal fileName As String, ByVal thumbWidth As Integer, ByVal thumbHeight As Integer) As String
            Try
                Dim client1 As New WebClient
                Dim tempFileName As String = fileName.Insert(fileName.Length - 4, "download") & Path.GetExtension(File.FileName).ToLower
                client1.DownloadFile(File.FileName, tempFileName)

                SaveThumbnailImage(thumbWidth, thumbHeight, tempFileName, fileName)
                System.IO.File.Delete(tempFileName)
                Return UploadSuccessMessage
            Catch exception1 As Exception
                Return (exception1.Message)
            End Try
        End Function

        Private Sub SaveThumbnailImage(ByVal File As HttpPostedFile, ByVal thumbWidth As Integer, ByVal thumbHeight As Integer, ByVal fileName As String)

            Using myImage As System.Drawing.Image = System.Drawing.Image.FromStream(File.InputStream)
                Dim newThumbWidth, newThumbHeight As Integer
                If myImage.Width > myImage.Height Then
                    If myImage.Width > thumbWidth Then
                        newThumbWidth = thumbWidth
                        newThumbHeight = Convert.ToInt32((myImage.Height * thumbWidth / myImage.Width))
                    Else
                        newThumbWidth = myImage.Width
                        newThumbHeight = myImage.Height
                    End If
                    ' portrait image
                Else
                    If myImage.Height > thumbHeight Then
                        newThumbHeight = thumbHeight
                        newThumbWidth = Convert.ToInt32((myImage.Width * thumbHeight / myImage.Height))
                    Else
                        newThumbWidth = myImage.Width
                        newThumbHeight = myImage.Height
                    End If
                End If
                Using bitmap As New System.Drawing.Bitmap(myImage, newThumbWidth, newThumbHeight)
                    bitmap.Save(fileName, myImage.RawFormat)

                End Using
            End Using

        End Sub

        Private Sub SaveThumbnailImage(ByVal thumbHeight As Integer, ByVal thumbWidth As Integer, ByVal sFileName As String, ByVal dFileName As String)

            Using myImage As System.Drawing.Image = System.Drawing.Image.FromFile(sFileName)
                Dim newThumbWidth, newThumbHeight As Integer
                If myImage.Width > myImage.Height Then
                    If myImage.Width > thumbWidth Then
                        newThumbWidth = thumbWidth
                        newThumbHeight = Convert.ToInt32((myImage.Height * thumbWidth / myImage.Width))
                    Else
                        newThumbWidth = myImage.Width
                        newThumbHeight = myImage.Height
                    End If
                    ' portrait image
                Else
                    If myImage.Height > thumbHeight Then
                        newThumbHeight = thumbHeight
                        newThumbWidth = Convert.ToInt32((myImage.Width * thumbHeight / myImage.Height))
                    Else
                        newThumbWidth = myImage.Width
                        newThumbHeight = myImage.Height
                    End If
                End If
                Using bitmap As New System.Drawing.Bitmap(myImage, newThumbWidth, newThumbHeight)
                    bitmap.Save(dFileName, myImage.RawFormat)
                End Using
            End Using

        End Sub
#End Region

    End Class

End Namespace
