Imports System
Imports System.Drawing
Imports System.Drawing.Imaging
Imports System.IO
Imports System.Drawing.Drawing2D
Imports System.Web
Imports System.Net

Namespace NetShopForge.Common.nsfImage

    Public Class WaterMarkController

        Public Enum MarkType
            [Text]
            Image
        End Enum 'MarkType

#Region "---Ա---"
        Private _text As String = ""
        Private _imgPath As String = ""
        Private _markX As Integer = 0
        Private _markY As Integer = 0
        Private _transparency As Single = 1
        Private _fontFamily As String = ""
        Private _textColor As Color = Color.Black
        Private _textbold As Boolean = False
        Private sizes() As Integer = {48, 32, 16, 8, 6, 4}
        Private _image As Image = Nothing
        Private _markedIamge As Image = Nothing
        Private _markType As MarkType = MarkType.Text
#End Region

#Region "---캯---"
        '''<summary>ʵһˮӡ
        ''' </summary>
        Public Sub New()
        End Sub 'New


        '
        ''' <summary>
        '''ʼһֻˮӡʵ
        ''' </summary>
        ''' <param name="text">ˮӡ</param>
        ''' <param name="fontFamily"></param>
        ''' <param name="bold">Ƿ</param>
        ''' <param name="color">ɫ</param>
        ''' <param name="markX">λú</param>
        ''' <param name="markY">λ</param>
        Public Sub New(ByVal SourceImage As Image, ByVal [text] As String, ByVal fontFamily As String, ByVal bold As Boolean, ByVal color As Color, ByVal markX As Integer, ByVal markY As Integer)
            Me._markType = MarkType.Text
            Me._text = [text]
            Me._fontFamily = fontFamily
            Me._textbold = bold
            Me._textColor = color
            Me._markX = markX
            Me._markY = markY
            Me._image = SourceImage
            Me.Mark()
        End Sub 'New

        '
        ''' <summary>
        ''' ʵһֻͼƬˮӡʵ
        ''' </summary>
        ''' <param name="imagePath">ˮӡͼƬ·</param>
        ''' <param name="tranparence">͸</param>
        ''' <param name="markX">λú</param>
        ''' <param name="markY">λ</param>
        Public Sub New(ByVal SourceImage As Image, ByVal imagePath As String, ByVal tranparence As Single, ByVal markX As Integer, ByVal markY As Integer)
            Me._markType = MarkType.Image
            Me._imgPath = imagePath
            Me._markX = markX
            Me._markY = markY
            Me._transparency = tranparence
            Me._image = SourceImage
            Me.Mark()
        End Sub 'New
        '
#End Region

#Region "--------"

        ''' <summary>ˮӡ
        ''' </summary>
        Public Property WaterMarkType() As MarkType
            Get
                Return _markType
            End Get
            Set(ByVal Value As MarkType)
                _markType = Value
            End Set
        End Property
        '
        ''' <summary>
        ''' ˮӡ
        ''' </summary>
        Public Property [Text]() As String
            Get
                Return _text
            End Get
            Set(ByVal Value As String)
                _text = Value
            End Set
        End Property '
        ''' <summary>
        ''' ˮӡͼƬ·
        ''' </summary>
        Public Property WaterImagePath() As String
            Get
                Return _imgPath
            End Get
            Set(ByVal Value As String)
                Me._imgPath = Value
            End Set
        End Property
        '
        ''' <summary>
        ''' ˮӡͼƬ
        ''' </summary>
        Public ReadOnly Property WaterImage() As Image
            Get
                Try
                    Return Image.FromFile(Me.WaterImagePath)
                Catch
                End Try
                Return Nothing
            End Get
        End Property
        '
        ''' <summary>
        ''' ˮӡλõú
        ''' </summary>
        Public Property MarkX() As Integer
            Get
                Return _markX
            End Get
            Set(ByVal Value As Integer)
                _markX = Value
            End Set
        End Property '

        ''' <summary>
        ''' ˮӡλõ
        ''' </summary>
        Public Property MarkY() As Integer
            Get
                Return _markY
            End Get
            Set(ByVal Value As Integer)
                _markY = Value
            End Set
        End Property '

        ''' <summary>
        ''' ˮӡ͸
        ''' </summary>
        Public Property Transparency() As Single
            Get
                If _transparency > 1.0F Then
                    _transparency = 1.0F
                End If
                Return _transparency
            End Get
            Set(ByVal Value As Single)
                _transparency = Value
            End Set
        End Property '

        ''' <summary>
        ''' ˮӡֵɫ
        ''' </summary>
        Public Property TextColor() As Color
            Get
                Return _textColor
            End Get
            Set(ByVal Value As Color)
                _textColor = Value
            End Set
        End Property '

        ''' <summary>
        ''' ˮӡֵ
        ''' </summary>
        Public Property TextFontFamilyStr() As String
            Get
                Return _fontFamily
            End Get
            Set(ByVal Value As String)
                _fontFamily = Value
            End Set
        End Property

        Public ReadOnly Property TextFontFamily() As FontFamily
            Get
                Return New FontFamily(Me.TextFontFamilyStr)
            End Get
        End Property '

        ''' <summary>
        ''' ˮӡǷӴ
        ''' </summary>
        Public Property Bold() As Boolean
            Get
                Return _textbold
            End Get
            Set(ByVal Value As Boolean)
                _textbold = Value
            End Set
        End Property '

        ''' <summary>
        ''' ԭͼ
        ''' </summary>
        Public Property SourceImage() As Image
            Get
                Return _image
            End Get
            Set(ByVal Value As Image)
                _image = Value
            End Set
        End Property

        ''' <summary>
        ''' ӹˮӡ֮ͼ
        ''' </summary>
        Public ReadOnly Property MarkedImage() As Image
            Get
                Return Me._markedIamge
            End Get
        End Property
#End Region

#Region "----¼---"
        Public Overloads Function Mark(ByVal img As Image, ByVal markType As MarkType, ByVal [text] As String, ByVal waterImg As Image, ByVal markx As Integer, ByVal marky As Integer, ByVal bold As Boolean, ByVal textColor As Color, ByVal transparence As Single, ByVal fontFamily As FontFamily) As Image

            'жϸͼƬǷ gifΪgifͼƬиĶ
            Dim guid As Guid
            For Each guid In img.FrameDimensionsList
                Dim dimension As New FrameDimension(guid)
                If img.GetFrameCount(dimension) > 1 Then
                    Return img
                End If
            Next guid
            Try
                'ˮӡ
                If markType = markType.Text Then
                    'ԴͼƬµBitmapΪͼΪ˸gifͼƬˮӡд
                    Dim newBitmap As New Bitmap(img.Width, img.Height, PixelFormat.Format24bppRgb)
                    '½λͼ÷ֱ
                    newBitmap.SetResolution(img.HorizontalResolution, img.VerticalResolution)
                    'GraphicsԶԸλͼв
                    Dim g As Graphics = Graphics.FromImage(newBitmap)
                    '
                    g.SmoothingMode = SmoothingMode.AntiAlias
                    'ԭͼͼ
                    g.DrawImage(img, New Rectangle(0, 0, img.Width, img.Height), 0, 0, img.Width, img.Height, GraphicsUnit.Pixel)
                    '
                    Dim cFont As Font = Nothing
                    'ˮӡıȵó
                    Dim size As New SizeF
                    '̽һʺͼƬССӦˮӡִСӦ
                    Dim i As Integer
                    For i = 0 To 5
                        'һ
                        cFont = New Font(fontFamily, sizes(i))
                        'ǷӴ
                        If Not bold Then
                            cFont = New Font(fontFamily, sizes(i), FontStyle.Regular)
                        Else
                            cFont = New Font(fontFamily, sizes(i), FontStyle.Bold)
                        End If
                        'ıС
                        size = g.MeasureString(Me.Text, cFont)
                        'ƥһҪС
                        If CType(size.Width, Integer) < CType(img.Width, Integer) Then
                            'ToDo: Unsigned Integers not supported
                            'ToDo: Unsigned Integers not supported
                            Exit For
                        End If
                    Next i
                    'ˢӶ׼ͼƬд
                    Dim brush = New SolidBrush(textColor)
                    'ָλд
                    g.DrawString([text], cFont, brush, markx, marky)
                    'ͷGraphics
                    g.Dispose()
                    'ɵͼƬMemoryStream
                    Dim ms As New System.IO.MemoryStream
                    newBitmap.Save(ms, ImageFormat.Jpeg)
                    'Image
                    img = System.Drawing.Image.FromStream(ms)
                    'µImage
                    Return img

                    'ͼˮӡ
                Else
                    If markType = markType.Image Then
                        'ˮӡͼ
                        Dim markImg As Image = waterImg
                        'ɫ
                        Dim ptsArray As Single()() = {New Single() {1, 0, 0, 0, 0}, New Single() {0, 1, 0, 0, 0}, New Single() {0, 0, 1, 0, 0}, New Single() {0, 0, 0, transparence, 0}, New Single() {0, 0, 0, 0, 1}}
                        'ע⣺˴Ϊ0.0fΪȫ͸1.0fΪȫ͸
                        Dim colorMatrix As New ColorMatrix(ptsArray)
                        '½һImage
                        Dim imageAttributes As New ImageAttributes
                        'ɫӵ
                        imageAttributes.SetColorMatrix(colorMatrix, ColorMatrixFlag.Default, ColorAdjustType.Default)
                        'λͼͼ
                        Dim newBitmap As New Bitmap(img.Width, img.Height, PixelFormat.Format24bppRgb)
                        '÷ֱ
                        newBitmap.SetResolution(img.HorizontalResolution, img.VerticalResolution)
                        'Graphics
                        Dim g As Graphics = Graphics.FromImage(newBitmap)
                        '
                        g.SmoothingMode = SmoothingMode.AntiAlias
                        'ԭͼͼ
                        g.DrawImage(img, New Rectangle(0, 0, img.Width, img.Height), 0, 0, img.Width, img.Height, GraphicsUnit.Pixel)
                        'ԭͼС
                        If markImg.Width > img.Width Or markImg.Height > img.Height Then
                            Dim callb As System.Drawing.Image.GetThumbnailImageAbort = Nothing
                            'ˮӡͼƬͼ,Сԭͼ1/4
                            Dim new_img As System.Drawing.Image = markImg.GetThumbnailImage(img.Width / 4, markImg.Height * img.Width / markImg.Width, callb, New System.IntPtr)
                            'ˮӡ
                            g.DrawImage(new_img, New Rectangle(markx, marky, new_img.Width, new_img.Height), 0, 0, new_img.Width, new_img.Height, GraphicsUnit.Pixel, imageAttributes)
                            'ͷͼ
                            new_img.Dispose()
                            'ͷGraphics
                            g.Dispose()
                            'ɵͼƬMemoryStream
                            Dim ms As New System.IO.MemoryStream
                            newBitmap.Save(ms, ImageFormat.Jpeg)
                            'µImage
                            img = Image.FromStream(ms)
                            Return img
                            'ԭͼ㹻
                        Else
                            'ˮӡ
                            g.DrawImage(markImg, New Rectangle(markx, marky, markImg.Width, markImg.Height), 0, 0, markImg.Width, markImg.Height, GraphicsUnit.Pixel, imageAttributes)
                            'ͷGraphics
                            g.Dispose()
                            'ɵͼƬMemoryStream
                            Dim ms As New System.IO.MemoryStream
                            newBitmap.Save(ms, ImageFormat.Jpeg)
                            'µImage
                            img = Image.FromStream(ms)
                            Return img
                        End If
                    End If
                End If
                Return img
            Catch
            End Try
            Return Nothing
        End Function 'Mark

        '''<summary>
        '''ˮӡ˷gifʽͼƬ
        '''</summary>
        Private Overloads Sub Mark()
            Me._markedIamge = Mark(Me.SourceImage, Me.WaterMarkType, Me._text, Me.WaterImage, Me._markX, Me._markY, Me._textbold, Me._textColor, Me._transparency, Me.TextFontFamily)
        End Sub 'Mark
#End Region

    End Class

End Namespace