Imports NetShopForge.Library.Payment
Partial Class Admin_Administration_Controls_EditPaymentMethodControl
    Inherits System.Web.UI.UserControl

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Dim Gateway As Integer = Request("gateway")
            hfgateway.Value = Gateway
            Dim PayMethodID As Integer = Request("PaymentMethodID")
            hfPaymentMethodID.Value = PayMethodID
            hfAction.Value = Request("Action")

            BindData()
        End If

    End Sub


#Region "---Privte Method---"

    Private Sub BindData()
        Dim t As Type = GetType(PaymentGateway)
        Dim PaymentMethodID As Integer = hfPaymentMethodID.Value

        If PaymentMethodID > 0 Then
            Dim objPC As New PaymentController
            Dim objPay As PaymentMethodInfo
            objPay = objPC.GetPaymentMethodInfo(PaymentMethodID)
            hfgateway.Value = CInt(objPay.PaymentGateway)
            txtDescription.Text = objPay.Description
            txtExpressions.Text = objPay.Expressions
            txtMerchantKey.Text = objPay.MerchantKey
            txtMerchantID.Text = objPay.MerchantID
            txtPaymentMethoedName.Text = objPay.PaymentMethodName

        End If

        Dim p() As String = Resources.Enum.Payment.Split(",")
        hlGateway.ToolTip = p(CInt(hfgateway.Value))
        hlGateway.Text = String.Format("<b>{0}</b>", p(CInt(hfgateway.Value)))

        Select Case CInt(hfgateway.Value)
            Case PaymentGateway.gw99Bill
                hlGateway.ImageUrl = "~/Image_Shop/Payment/99bill.gif"
                hlGateway.NavigateUrl = "http://www.99bill.com"
            Case PaymentGateway.gwOffline
                pGateway.Visible = False
            Case PaymentGateway.gwAdvance
                pGateway.Visible = False
            Case PaymentGateway.gwAliPay
                hlGateway.ImageUrl = "~/Image_Shop/Payment/ALIPAY.gif"
                hlGateway.NavigateUrl = "http://www.alipay.com"
            Case PaymentGateway.gwChinaBank
                hlGateway.ImageUrl = "~/Image_Shop/Payment/ChinaBank.gif"
                hlGateway.NavigateUrl = "http://www.chinabank.com.cn"
            Case PaymentGateway.gwPaypalCN
                hlGateway.ImageUrl = "~/Image_Shop/Payment/paypalcn.gif"
                hlGateway.NavigateUrl = "http://www.paypal.com/cn"
            Case Else
        End Select

    End Sub

#End Region
  

    Protected Sub btn_Payment_Save_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_Payment_Save.Click
        Dim p As New PaymentMethodInfo
        p.Button = 0
        p.Currency = ""
        p.Description = txtDescription.Text
        p.Expressions = txtExpressions.Text
        p.IsValid = True
        p.ItemOrder = 0
        p.MerchantID = txtMerchantID.Text
        p.MerchantKey = txtMerchantKey.Text
        p.PaymentMethodName = txtPaymentMethoedName.Text
        p.IsValid = CBool(ddlIsValid.SelectedValue)
        Try
            If hfAction.Value.ToLower = "addnew" Then
                hfPaymentMethodID.Value = PaymentController.Instance.AddPaymentMethod(p)
                hfAction.Value = ""
                ResultMessageControl1.ShowSuccess("֧ʽɹ ")
            Else
                p.PaymentMethodID = hfPaymentMethodID.Value
                PaymentController.Instance.UpdatePaymentMethod(p)
                ResultMessageControl1.ShowSuccess("֧ʽɹ ")
            End If
        Catch ex As Exception
            ResultMessageControl1.ShowFail("ûгɹ ʧԭ" & ex.Message)
        End Try
   
    End Sub
End Class
