Imports NetShopForge.Library.Payment
Imports NetShopForge.Library.Shipping 

Partial Class Admin_Administration_Controls_EditShippingControl
    Inherits System.Web.UI.UserControl

#Region "---EventArg Method---"

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Dim ShippingMethodID As String = Request("shippingmethodid")
            If IsNothing(ShippingMethodID) Then hfShippingMethodID.Value = -1 Else hfShippingMethodID.Value = ShippingMethodID
            BindShippingType()
            BindData()

        End If
       
    End Sub
    Protected Sub rbShippingMethodFeeType_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles rbShippingMethodFeeType.SelectedIndexChanged
        Dim i As Integer = CInt(rbShippingMethodFeeType.SelectedValue)
        mvMethodFeeType.ActiveViewIndex = i
        If i = 1 Then BindShippingExpressions()

    End Sub
    Protected Sub rpExpressions_ItemDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.RepeaterItemEventArgs) Handles rpExpressions.ItemDataBound
        If e.Item.ItemType = ListItemType.Item Or e.Item.ItemType = ListItemType.AlternatingItem Then
            Dim ddlShippingExpressions As DropDownList = CType(e.Item.FindControl("ddlShippingExpressions"), DropDownList)
            ddlShippingExpressions.DataTextField = "ExpressionsDescription"
            ddlShippingExpressions.DataValueField = "ShippingExpressionsID"
            ddlShippingExpressions.DataSource = GetShippingExpressions()
            ddlShippingExpressions.DataBind()
            ddlShippingExpressions.Items.Insert(0, "<ѡ͹ʽ>")
        End If
    End Sub
    Protected Sub rbInsurance_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles rbInsurance.SelectedIndexChanged
        pInsurance.Visible = (rbInsurance.SelectedIndex = 1)
    End Sub

    Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click
        Dim iShippingMethodID As Integer = CInt(hfShippingMethodID.Value)
        Dim objSC As New ShippingController
        Dim RegionPaymentList As New Generic.Dictionary(Of Integer, Integer)
        Dim objShipping As ShippingMethodInfo = GetShippingInfo(RegionPaymentList)
        If RegionPaymentList.Count > 0 Then
            Dim rID As Integer
            objSC.DeleteShippingRegionExpressions(CInt(hfShippingMethodID.Value))
            For Each rID In RegionPaymentList.Keys
                objSC.AddShippingRegionExpressions(CInt(hfShippingMethodID.Value), rID, RegionPaymentList.Item(rID))
            Next
        End If

        If iShippingMethodID <= 0 Then
            hfShippingMethodID.Value = objSC.AddShippingMethod(objShipping)
            lblDialogTitle.Text = "༭ͷ"
            ResultMessageControl1.ShowSuccess("ͷʽӳɹ!")
        Else
            objSC.UpdateShippingMethod(objShipping)
            ResultMessageControl1.ShowSuccess("ͷʽ޸ĳɹ!")
        End If
    End Sub
#End Region


#Region "---Private Method---"

    Private Sub BindData()
        Dim iShippingMethodID As Integer = CInt(hfShippingMethodID.Value)
        If iShippingMethodID <= 0 Then
            lblDialogTitle.Text = "µͷ"
            BindRegionAndPaymentList(Nothing)
            rbShippingMethodFeeType.SelectedIndex = 0
            rbInsurance.SelectedIndex = 0
        Else
            lblDialogTitle.Text = "༭ͷ"
            Dim objShipping As ShippingMethodInfo
            Dim objSC As New ShippingController
            objShipping = objSC.GetShippingMethod(iShippingMethodID)
            BindRegionAndPaymentList(objShipping)
            txtInsuranceFeeRate.Text = objShipping.InsuranceFeeRate
            txtMiniInsuranceFee.Text = objShipping.MiniInsuranceFee
            txtShippingMethodDescription.Text = objShipping.ShippingMethodDescription
            txtShippingMethodName.Text = objShipping.ShippingMethodName
            txtShippingPrice.Text = objShipping.ShippingPrice
            ddlShippingType.SelectedValue = objShipping.ShippingType

            'bind ShippingFeeType 
            ''begin
            rbShippingMethodFeeType.Items.FindByValue(objShipping.ShippingMethodFeeType.ToString).Selected = True
            mvMethodFeeType.ActiveViewIndex = objShipping.ShippingMethodFeeType
            'if (By Expressions)
            If objShipping.ShippingMethodFeeType = 1 Then BindShippingExpressions()
            ''end
            If objShipping.IsInsurance Then
                rbInsurance.Items(1).Selected = True
            Else
                rbInsurance.Items(0).Selected = True
            End If
            pInsurance.Visible = objShipping.IsInsurance
        End If

    End Sub

    Private Sub BindRegionAndPaymentList(ByVal objshipping As ShippingMethodInfo)
        Dim objSC As New ShippingController
        Dim RegionList As Generic.List(Of ShippingRegionInfo) = objSC.GetShippingRegionList
        cbRegionList.DataTextField = "Name"
        cbRegionList.DataValueField = "ShippingRegionID"
        cbRegionList.DataSource = RegionList
        cbRegionList.DataBind()
        Dim objPC As New PaymentController
        Dim PayList As Generic.List(Of PaymentMethodInfo) = objPC.GetPaymentMethodList
        cbPaymentList.DataTextField = "PaymentmethodName"
        cbPaymentList.DataValueField = "PaymentmethodID"
        cbPaymentList.DataSource = PayList
        cbPaymentList.DataBind()

        If IsNothing(objshipping) Then Exit Sub

        Dim r As String() = objshipping.ShippingRegionCollection
        Dim p As String() = objshipping.PaymentMethodCollection

        Dim sr, sp As String
        If Not IsNothing(r) Then
            For Each sr In r
                If Not IsNothing(cbRegionList.Items.FindByValue(sr)) Then
                    cbRegionList.Items.FindByValue(sr).Selected = True
                End If
            Next
        End If

        If Not IsNothing(p) Then
            For Each sp In p
                If Not IsNothing(cbPaymentList.Items.FindByValue(sp)) Then
                    cbPaymentList.Items.FindByValue(sp).Selected = True
                End If
            Next
        End If

    End Sub
    Private Sub BindShippingType()
        Dim stype As String() = Resources.Enum.ShippingType.Split(",")
        For Each value As ShippingType In [Enum].GetValues(GetType(ShippingType))
            ddlShippingType.Items.Add(New ListItem(stype(CInt(value)), CInt(value)))
        Next
    End Sub


    Private Function GetShippingExpressions() As Generic.List(Of ShippingExpressionsInfo)

        If IsNothing(ViewState("ShippingExpressionsList")) Then
            Dim objSC As New ShippingController

            Dim objExpressionsList As Generic.List(Of ShippingExpressionsInfo)
            objExpressionsList = objSC.GetShippingExpressionsList

            ViewState("ShippingExpressionsList") = objExpressionsList
            Return objExpressionsList
        Else
            Return CType(ViewState("ShippingExpressionsList"), Generic.List(Of ShippingExpressionsInfo))
        End If

    End Function


    Private Sub BindShippingExpressions()
        Dim objSC As New ShippingController
        Dim srList As New Generic.List(Of ShippingRegionInfo)
        srList = objSC.GetShippingRegionList()

        rpExpressions.DataSource = srList
        rpExpressions.DataBind()
    End Sub

    Private Function GetShippingInfo(ByRef regionExpressionsList As Generic.Dictionary(Of Integer, Integer)) As ShippingMethodInfo

        Dim objShipping As New ShippingMethodInfo

        objShipping.ShippingMethodFeeType = rbShippingMethodFeeType.SelectedValue
        objShipping.ShippingMethodID = CInt(hfShippingMethodID.Value)
        objShipping.ShippingType = ddlShippingType.SelectedValue
        If objShipping.ShippingMethodFeeType = 1 Then
            'By expressions
            Dim I As Integer = 0
            For I = 0 To rpExpressions.Items.Count - 1
                Dim ddlShippingExpressions As DropDownList = CType(rpExpressions.Items(I).FindControl("ddlShippingExpressions"), DropDownList)
                Dim hfShippingRegionId As HiddenField = CType(rpExpressions.Items(I).FindControl("hfShippingRegionId"), HiddenField)
                If ddlShippingExpressions.SelectedIndex = 0 Then Continue For
                regionExpressionsList.Add(CInt(hfShippingRegionId.Value), CInt(ddlShippingExpressions.SelectedValue))
            Next
        Else
            objShipping.ShippingPrice = txtShippingPrice.Text
        End If

        objShipping.IsInsurance = CBool(rbInsurance.SelectedValue)
        If objShipping.IsInsurance Then
            objShipping.MiniInsuranceFee = txtMiniInsuranceFee.Text
            objShipping.InsuranceFeeRate = txtInsuranceFeeRate.Text
        End If

        objShipping.ShippingMethodDescription = txtShippingMethodDescription.Text
        objShipping.ShippingMethodName = txtShippingMethodName.Text

        Dim srb, spb As New StringBuilder
        Dim K, J As Integer
        For K = 0 To cbPaymentList.Items.Count - 1
            If cbPaymentList.Items(K).Selected Then
                spb.Append(String.Format(",{0}", cbPaymentList.Items(K).Value))
            End If
        Next

        objShipping.PaymentMethodIDs = spb.ToString & ","

        For J = 0 To cbRegionList.Items.Count - 1
            If cbRegionList.Items(J).Selected Then
                srb.Append(String.Format(",{0}", cbRegionList.Items(J).Value))
            End If
        Next
        objShipping.ShippingRegionIDs = srb.ToString & ","


        Return objShipping

    End Function



#End Region


End Class
