Imports NetShopForge.Library.Shipping
Partial Class Admin_Administration_Controls_EditShippingExpressionsControl
    Inherits System.Web.UI.UserControl

#Region "---EventArg Method---"

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        Dim action As String = Request("action")
        Dim expressionsID As Integer = Request("shippingexpressionsid")
        If expressionsID = 0 Then expressionsID = -1

        If IsNothing(action) Then action = "addnew"
        If Not IsPostBack Then
            hfAction.Value = action
            hfExpressionsID.Value = expressionsID
            BindData(expressionsID, action)
        End If

    End Sub

    Protected Sub btn_Shipping_SaveShippingExpressions_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_Shipping_SaveShippingExpressions.Click

        Dim objSC As New ShippingController
        Dim objSEI As New ShippingExpressionsInfo
        objSEI.ShippingExpressionsID = CInt(hfExpressionsID.Value)
        objSEI.ExpressionsDescription = txtExpressionsDescription.Text
        objSEI.Expressions = txtExpressions.Text
        objSEI.IsValid = CBool(ddlIsVaild.SelectedValue)

        If hfAction.Value.ToString.ToLower = "edit" Then
            objSC.UpdateShippingExpressions(objSEI)
            ResultMessageControl1.ShowSuccess("͹ʽ޸ĳɹ")

        Else
            Dim ExpressionsID As Integer = objSC.AddShippingExpressions(objSEI)
            hfExpressionsID.Value = ExpressionsID
            ResultMessageControl1.ShowSuccess("͹ʽӳɹ")
            hfAction.Value = "edit"
            lblDialogTitle.Text = "༭͹ʽ"
        End If



    End Sub

#End Region


#Region "---Private Method---"

    Private Sub BindData(ByVal expressionsID As Integer, ByVal action As String)

        If action = "addnew" Then
            lblDialogTitle.Text = "µ͹ʽ"
            Exit Sub
        Else
            lblDialogTitle.Text = "༭͹ʽ"
        End If

        Dim objSC As New ShippingController
        Dim objSEI As New ShippingExpressionsInfo
        objSEI = objSC.GetShippingExpressions(expressionsID)
        txtExpressions.Text = objSEI.Expressions
        txtExpressionsDescription.Text = objSEI.ExpressionsDescription
        ddlIsVaild.SelectedValue = CInt(objSEI.IsValid)

    End Sub


#End Region
End Class
