Imports NetShopForge.Library.Shipping
Partial Class Admin_Administration_Controls_EditShippingRegionControl
    Inherits System.Web.UI.UserControl

#Region "---EventArg Method---"

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        Dim action As String = Request("action")
        Dim regionID As Integer = Request("shippingregionid")
        If regionID = 0 Then regionID = -1

        If IsNothing(action) Then action = "addnew"
        If Not IsPostBack Then
            hfAction.Value = action
            hfRegionID.Value = regionID
            BindData(regionID, action)
        End If
     
    End Sub

    Protected Sub btn_Shipping_SaveShippingRegion_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_Shipping_SaveShippingRegion.Click

        Dim objSC As New ShippingController
        Dim objSRI As New ShippingRegionInfo
        objSRI.ShippingRegionID = CInt(hfRegionID.Value)
        objSRI.Name = txtRegionName.Text
        objSRI.RegionDescription = txtRegionDescription.Text
        objSRI.IsValid = CBool(ddlIsVaild.SelectedValue)

        If hfAction.Value.ToString.ToLower = "edit" Then
            objSC.UpdateShippingRegion(objSRI)
            ResultMessageControl1.ShowSuccess("޸ĳɹ")
        Else
            Dim RegionID As Integer = objSC.AddShippingRegion(objSRI)
            hfRegionID.Value = RegionID
            hfAction.Value = "edit"
            lblDialogTitle.Text = "༭"
            ResultMessageControl1.ShowSuccess("ӳɹ")
        End If

   

    End Sub

#End Region


#Region "---Private Method---"

    Private Sub BindData(ByVal regionID As Integer, ByVal action As String)

        If action = "addnew" Then
            lblDialogTitle.Text = "µ"
            Exit Sub
        Else
            lblDialogTitle.Text = "༭"
        End If


        Dim objSC As New ShippingController
        Dim objSRI As New ShippingRegionInfo
        objSRI = objSC.GetShippingRegion(regionID)
        txtRegionDescription.Text = objSRI.RegionDescription
        txtRegionName.Text = objSRI.Name
        ddlIsVaild.SelectedValue = CInt(objSRI.IsValid)

    End Sub


#End Region



End Class
