Imports NetShopForge.Library.Payment
Partial Class Admin_Administration_Controls_PaymentMethodControl
    Inherits System.Web.UI.UserControl

    Protected Sub btn_Payment_Addnew_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_Payment_Addnew.Click

        If ddlGateway.SelectedValue <> "-1" Then
            Dim redirectURL As String = String.Format("~/Admin/Administration/Payment.aspx?mode=editpaymentmethod&gateway={0}&action=addnew", ddlGateway.SelectedValue)
            My.Response.Redirect(redirectURL)
        Else
            ResultMessageControl1.ShowFail("ѡ֧ʽ ")
        End If

    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            BindGateway()
            BindData()
        End If
     
    End Sub


    Private Sub BindData()
        Dim objPC As New PaymentController
        gvPaymentMethod.DataSource = objPC.GetPaymentMethodList
        gvPaymentMethod.DataBind()
    End Sub


    Private Sub BindGateway()
        ddlGateway.Items.Clear()
        ddlGateway.Items.Add(New ListItem("ѡ֧ʽ", -1))
        Dim p() As String = Resources.Enum.Payment.Split(",")
        For Each value As PaymentGateway In [Enum].GetValues(GetType(PaymentGateway))
            ddlGateway.Items.Add(New ListItem(p(CInt(value)), CInt(value)))
        Next

    End Sub

    Protected Sub gvPaymentMethod_RowDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles gvPaymentMethod.RowDataBound
        If e.Row.RowType = DataControlRowType.DataRow Then
            Dim lbPaymentGateway As Label = CType(e.Row.FindControl("lbPaymentGateway"), Label)

            Dim p() As String = Resources.Enum.Payment.Split(",")
            Dim i As Integer = Integer.Parse(lbPaymentGateway.Text)
            If i > 0 Then
                ddlGateway.Items.Remove(ddlGateway.Items.FindByValue(i.ToString))
            End If

            lbPaymentGateway.Text = p(i)
        End If
    End Sub

    Protected Sub btnUpdate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpdate.Click
        Try
            For i As Integer = 0 To gvPaymentMethod.Rows.Count - 1
                If gvPaymentMethod.Rows(i).RowType = DataControlRowType.DataRow Then

                    Dim ddlIsValid As DropDownList = CType(gvPaymentMethod.Rows(i).FindControl("ddlIsValid"), DropDownList)
                    Dim txtItemOrder As TextBox = CType(gvPaymentMethod.Rows(i).FindControl("txtItemOrder"), TextBox)

                    Dim PaymentMethodID As String = gvPaymentMethod.DataKeys(i).Value
                    Dim itemOrder As Integer
                    If txtItemOrder.Text.Length = 0 OrElse (Not IsNumeric(txtItemOrder.Text)) Then
                        itemOrder = 0
                    Else
                        itemOrder = txtItemOrder.Text
                    End If
                    PaymentController.Instance.UpdatePaymentMethodQuick(PaymentMethodID, CBool(ddlIsValid.SelectedValue), itemOrder)

                End If
            Next i
            BindData()
            ResultMessageControl1.ShowSuccess("³ɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("ʧܣ" & ex.Message)
        End Try
    End Sub

    Protected Sub btnDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDelete.Click
        Try
            For i As Integer = 0 To gvPaymentMethod.Rows.Count - 1
                If gvPaymentMethod.Rows(i).RowType = DataControlRowType.DataRow Then
                    Dim cbSelect As CheckBox = CType(gvPaymentMethod.Rows(i).FindControl("cbSelect"), CheckBox)
                    Dim paymentMethodID As String = gvPaymentMethod.DataKeys(i).Value
                    If cbSelect.Checked Then PaymentController.Instance.DeletePaymentMethod(paymentMethodID)
                End If
            Next i
            BindData()
            ResultMessageControl1.ShowSuccess("֧ɾɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("֧ɾʧܣ" & ex.Message)
        End Try
    End Sub
End Class
