Imports NetShopForge.Library.Role

Partial Class Admin_Administration_Controls_RoleControl
    Inherits System.Web.UI.UserControl



    Protected Sub btn_Role_Customer_AddNew_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_Role_Customer_AddNew.Click

        Dim objRC As New RoleController
        objRC.AddRole(txt_Role_Customer_RoleName.Text, RoleType.Customer)
        BindData(RoleType.Customer)

    End Sub

    Protected Sub btn_Role_Admin_AddNew_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_Role_Admin_AddNew.Click
        Dim objRC As New RoleController
        objRC.AddRole(txt_Role_Admin_RoleName.Text, RoleType.Admin)
        BindData(RoleType.Admin)
        txt_Role_Admin_RoleName.Text = ""
    End Sub

    Private Sub BindData(ByVal roleType As RoleType)

        Dim objRC As New RoleController
        Dim objRoleList As Generic.List(Of RoleInfo)
        objRoleList = objRC.GetRoleList(roleType)
        Select Case roleType
            Case NetShopForge.Library.Role.RoleType.Admin
                gvAdminRole.DataSource = objRoleList
                gvAdminRole.DataBind()
            Case NetShopForge.Library.Role.RoleType.Customer
                gvCustomerRole.DataSource = objRoleList
                gvCustomerRole.DataBind()

        End Select

    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not IsPostBack Then
            BindData(RoleType.Admin)
            BindData(RoleType.Customer)
        End If

    End Sub

    Protected Sub btn_Role_Customer_Delete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_Role_Customer_Delete.Click
        Dim objRC As New RoleController
        For i As Integer = 0 To gvCustomerRole.Rows.Count - 1
            If gvCustomerRole.Rows(i).RowType = DataControlRowType.DataRow Then
                Dim cbSelect As CheckBox = CType(gvCustomerRole.Rows(i).FindControl("cbSelect"), CheckBox)
                If cbSelect.Checked Then objRC.DeleteRole((CInt(gvCustomerRole.DataKeys(i).Value)))
            End If
        Next i
        BindData(RoleType.Customer)
    End Sub

    Protected Sub btn_Role_Customer_Update_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_Role_Customer_Update.Click


        Dim objRC As New RoleController
        For i As Integer = 0 To gvCustomerRole.Rows.Count - 1
            If gvCustomerRole.Rows(i).RowType = DataControlRowType.DataRow Then
                Dim txtRoleName As TextBox = CType(gvCustomerRole.Rows(i).FindControl("txtRoleName"), TextBox)
                objRC.UpdateRole(CInt(gvCustomerRole.DataKeys(i).Value), txtRoleName.Text)
            End If
        Next i
        BindData(RoleType.Customer)
        txt_Role_Customer_RoleName.Text = ""
    End Sub

    Protected Sub btn_Role_Admin_Delete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_Role_Admin_Delete.Click

        Dim objRC As New RoleController
        For i As Integer = 0 To gvAdminRole.Rows.Count - 1
            If gvAdminRole.Rows(i).RowType = DataControlRowType.DataRow Then
                Dim cbSelect As CheckBox = CType(gvAdminRole.Rows(i).FindControl("cbSelect"), CheckBox)
                If cbSelect.Checked Then objRC.DeleteRole((CInt(gvAdminRole.DataKeys(i).Value)))
            End If
        Next i
        BindData(RoleType.Admin)
    End Sub

    Protected Sub btn_Role_Admin_Update_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_Role_Admin_Update.Click


        Dim objRC As New RoleController
        For i As Integer = 0 To gvAdminRole.Rows.Count - 1
            If gvAdminRole.Rows(i).RowType = DataControlRowType.DataRow Then
                Dim txtRoleName As TextBox = CType(gvAdminRole.Rows(i).FindControl("txtRoleName"), TextBox)
                objRC.UpdateRole(CInt(gvAdminRole.DataKeys(i).Value), txtRoleName.Text)
            End If
        Next i
        BindData(RoleType.Admin)

    End Sub
End Class
