Imports NetShopForge.Library.Shipping

Partial Class Admin_Administration_Controls_ShippingControl
    Inherits System.Web.UI.UserControl



    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            BindData()
        End If
    End Sub


    Protected Sub btn_Shipping_AddNew_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_Shipping_AddNew.Click
        Dim redirectURL As String = "~/Admin/Administration/Shipping.aspx?mode=editshipping&shippingmethodid=-1"
        My.Response.Redirect(redirectURL)
    End Sub




#Region "---Private Method----"

    Private Sub BindData()

        Dim objSC As New ShippingController
        Dim sMList As Generic.List(Of ShippingMethodInfo)
        sMList = objSC.GetShippingMethodList()
        gvShipping.DataSource = sMList
        gvShipping.DataBind()

        Dim b As Boolean = (sMList.Count > 0)
        btn_Shipping_DeleteShippingMethod.Visible = b
        btn_Shipping_UpdateShippingMethod.Visible = b

    End Sub
    Private Function GetPostionShipping(ByVal pos As String) As Integer
        If Not IsNumeric(pos) Then
            Dim i As Integer = gvShipping.Rows.Count
            If i = 0 Then
                Return 0
            Else
                Dim txtItemOrder As TextBox = CType(gvShipping.Rows(i - 1).FindControl("txtItemOrder"), TextBox)
                If Not IsNumeric(txtItemOrder.Text) Then Return 0
                Return CInt(txtItemOrder.Text) + 10
            End If
        Else
            Return CInt(pos)
        End If
    End Function
#End Region

    Protected Sub btn_Shipping_UpdateShippingMethod_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_Shipping_UpdateShippingMethod.Click
        Dim objSC As New ShippingController
        For i As Integer = 0 To gvShipping.Rows.Count - 1

            If gvShipping.Rows(i).RowType = DataControlRowType.DataRow Then
                Dim txtItemOrder As TextBox = CType(gvShipping.Rows(i).FindControl("txtItemOrder"), TextBox)
                Dim ddlIsValid As DropDownList = CType(gvShipping.Rows(i).FindControl("ddlIsValid"), DropDownList)

                Dim ShippingMethodID As Integer = CInt(gvShipping.DataKeys(i).Value)
                objSC.UpdateShippingMethodQuick(ShippingMethodID, GetPostionShipping(txtItemOrder.Text), CBool(ddlIsValid.SelectedValue))
            End If
        Next i
        BindData()
    End Sub

    Protected Sub btn_Shipping_DeleteShippingMethod_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_Shipping_DeleteShippingMethod.Click
        Dim objSC As New ShippingController
        For i As Integer = 0 To gvShipping.Rows.Count - 1
            If gvShipping.Rows(i).RowType = DataControlRowType.DataRow Then
                Dim cbSelect As CheckBox = CType(gvShipping.Rows(i).FindControl("cbSelect"), CheckBox)
                If cbSelect.Checked Then objSC.DeleteShippingMethod(CInt(gvShipping.DataKeys(i).Value))
            End If

        Next i
        BindData()
    End Sub
End Class
