Imports NetShopForge.Library.SpeedBar
Imports NetShopForge.Library.Category
Imports System.Data
Partial Class Admin_Administration_Controls_SpeedBarControl
    Inherits System.Web.UI.UserControl



    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            BindData()
        End If
    End Sub

    Private Sub BindData()


        gvSpeedBar.DataSource = SpeedBarController.GetSpeedBarList()
        gvSpeedBar.DataBind()

        Dim b As Boolean = (gvSpeedBar.Rows.Count > 0)
        btnSpeedbarDelete.Visible = b
        btnSpeedbarUpdate.Visible = b

    End Sub

    Protected Sub btnSpeedbarDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSpeedbarDelete.Click
        Try
            For i As Integer = 0 To gvSpeedBar.Rows.Count - 1
                If gvSpeedBar.Rows(i).RowType = DataControlRowType.DataRow Then
                    Dim cbSelect As CheckBox = CType(gvSpeedBar.Rows(i).FindControl("cbSelect"), CheckBox)
                    Dim barID As String = gvSpeedBar.DataKeys(i).Value

                    If cbSelect.Checked Then SpeedBarController.Instance.DeleteSpeedBar(barID)
                End If
            Next i
            SpeedBarController.Instance.ClearSpeedbarCache()
            BindData()
            ResultMessageControl1.ShowSuccess("ɾɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("ɾʧܣ" & ex.Message)
        End Try
    End Sub

    Protected Sub btnSpeedbarUpdate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSpeedbarUpdate.Click
        Try
            For i As Integer = 0 To gvSpeedBar.Rows.Count - 1
                If gvSpeedBar.Rows(i).RowType = DataControlRowType.DataRow Then
                    Dim txtItemOrder As TextBox = CType(gvSpeedBar.Rows(i).FindControl("txtItemOrder"), TextBox)
                    Dim ddlIsValid As DropDownList = CType(gvSpeedBar.Rows(i).FindControl("ddlIsValid"), DropDownList)
                    Dim barID As Integer = CInt(gvSpeedBar.DataKeys(i).Value)
                    SpeedBarController.Instance.UpdateSpeedBarQuick(barID, txtItemOrder.Text, CInt(ddlIsValid.SelectedValue))
                End If
            Next i
            SpeedBarController.Instance.ClearSpeedbarCache()
            BindData()
            ResultMessageControl1.ShowSuccess("³ɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("ʧܣ" & ex.Message)
        End Try
    End Sub

    Protected Sub btnSpeedbarAddNew_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSpeedbarAddNew.Click
        Response.Redirect("~/Admin/Administration/SpeedBar.aspx?mode=editspeedbar")
    End Sub

    Protected Sub btnAddCategoryToMenu_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAddCategoryToMenu.Click
        Dim dt As Data.DataTable = CategoryController.GetCategoryList(-1).Tables(0)
        For Each row As DataRow In dt.Rows
            Dim sbInfo As New SpeedBarInfo
            sbInfo.ItemOrder = 0
            sbInfo.Title = row.Item("CategoryName").ToString
            sbInfo.ToolTip = row.Item("CategoryName").ToString
            sbInfo.URL = String.Format("~/Cateogry.aspx?catID={0}", row.Item("CategoryID"))
            sbInfo.IsValid = False
            sbInfo.CSS = ""
            SpeedBarController.Instance.AddSpeedBar(sbInfo)
        Next
        SpeedBarController.Instance.ClearSpeedbarCache()
        BindData()
    End Sub


End Class
