Imports NetShopForge.Library.Ad

Partial Class Admin_Controls_AdControl
    Inherits System.Web.UI.UserControl

    Public CanEdit As Boolean = False
    Public PageName As String
    Private _boxPlacement As AdBoxPlacement
    Private _IsValid As Boolean

    Public Property BoxPlacement() As AdBoxPlacement
        Get
            Return _boxPlacement
        End Get
        Set(ByVal value As AdBoxPlacement)
            _boxPlacement = value
        End Set
    End Property

    Public Property IsValid() As Boolean
        Get
            Return _IsValid
        End Get
        Set(ByVal value As Boolean)
            _IsValid = True
        End Set
    End Property



    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        CanEdit = My.User.IsInRole("Administrator")

        If Not IsPostBack Then
            If Not IsValid Then Exit Sub
            BindData()
            LiteralAddContentText.Visible = CanEdit
            If CanEdit Then
                LiteralAddContentText.Text = SetAddContentText()
            End If

        End If
    End Sub


    Protected Sub BindData()

        'Dim thisPath As String = Request.Url.LocalPath
        Dim thisPath As String = Request.Url.PathAndQuery
        PageName = System.IO.Path.GetFileName(thisPath)
        Dim ads As Generic.List(Of AdInfo)
        ads = AdController.GetAdList(PageName, BoxPlacement)
        rpAd.DataSource = ads
        rpAd.DataBind()
        If ads.Count = 0 Then rpAd.Visible = False

    End Sub


    Private Function SetContentText(ByVal ContentID As Integer, ByVal addText As String) As String
        Dim divString As New StringBuilder
        Dim pageURL As String = String.Format(Page.ResolveUrl("~/admin/contenteditor.aspx?adid={0}&pn={1}&pl={2}"), ContentID.ToString, PageName, CInt(BoxPlacement).ToString)
        divString.Append(" <div class=""contentbox"" id=""divHolder"" ")
        divString.Append(" Style = ""border:1px dashed white""")
        divString.Append(" ondblclick=""showPopWin('" & pageURL & "', 650,610, null);""")
        divString.Append(" onmouseover = ""this.style.cursor='hand'; this.style.backgroundColor='AliceBlue'; this.style.border='1px dashed gainsboro';""")
        divString.Append(" onmouseout = ""this.style.backgroundColor='White'; this.style.border='1px dashed white';""")
        divString.Append(" title=""˫༭"">")
        divString.Append(addText)
        divString.Append("</div>")
        Return divString.ToString
    End Function

    Private Function SetAddContentText() As String
        Dim divString As New StringBuilder
        Dim pageURL As String = String.Format(Page.ResolveUrl("~/admin/contenteditor.aspx?adid=-1&pn={0}&pl={1}"), PageName, CInt(BoxPlacement).ToString)
        divString.Append(" <div class=""contentbox"" id=""divHolder"" ")
        divString.Append(" Style = ""border:1px dashed white""")
        divString.Append(" ondblclick=""showPopWin('" & pageURL & "', 650, 610, null);""")
        divString.Append(" onmouseover = ""this.style.cursor='hand'; this.style.backgroundColor='AliceBlue'; this.style.border='1px dashed gainsboro';""")
        divString.Append(" onmouseout = ""this.style.backgroundColor='White'; this.style.border='1px dashed white';""")
        divString.Append(" >")
        divString.Append("˫...")
        divString.Append("</div>")
        Return divString.ToString

    End Function

    Protected Sub rpAd_ItemDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.RepeaterItemEventArgs) Handles rpAd.ItemDataBound
        If CanEdit Then
            Dim LiteralContentText As Literal = CType(e.Item.FindControl("LiteralContentText"), Literal)
            Dim btnDelete As ImageButton = CType(e.Item.FindControl("btnDelete"), ImageButton)
            LiteralContentText.Text = SetContentText(CInt(btnDelete.CommandArgument), LiteralContentText.Text)
            btnDelete.Visible = True

        End If

    End Sub

    Protected Sub DeleteAd(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs)
        Dim adID As String = CType(sender, ImageButton).CommandArgument
        Dim adc As New AdController
        adc.DeleteAD(adID)
        BindData()
    End Sub
End Class
