
Imports NetShopForge.Library.Category
Imports System.Data


Partial Class Admin_Controls_CategoryListControl
    Inherits System.Web.UI.UserControl


    Private _FirstText As String = "------"
    Private _separatorLine As String = "/"

    Public Property CategoryName() As String
        Get
            Return ddlCategory.SelectedItem.Text
        End Get
        Set(ByVal value As String)
            ddlCategory.SelectedValue = ddlCategory.Items.FindByText(value).Value
        End Set
    End Property


    Public Property CategoryID() As Integer
        Get
            If IsNothing(ddlCategory.SelectedItem) Then
                Return -1
            Else
                Return ddlCategory.SelectedValue
            End If
        End Get
        Set(ByVal value As Integer)
            ddlCategory.SelectedValue = value
        End Set
    End Property


    Public Property FirstText() As String
        Get
            Return _FirstText
        End Get
        Set(ByVal value As String)
            _FirstText = value
        End Set
    End Property

    Public Property SeparatorLine() As String
        Get
            Return _separatorLine
        End Get
        Set(ByVal value As String)
            _separatorLine = value
        End Set
    End Property


    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not Page.IsPostBack Then
            Dim t As DataTable = CategoryController.GetTreeTable()
            BindData(t, -1, "")
            ddlCategory.Items.Insert(0, New ListItem(_FirstText, -1))
        End If

    End Sub


    Private Sub BindData(ByVal dt As DataTable, ByVal categoryFatherID As Integer, ByVal categoryFatherName As String)
        Dim dv As DataView = New DataView(dt)
        dv.RowFilter = "CategoryFatherID = " & categoryFatherID.ToString()

        For Each drv As DataRowView In dv
            Dim li As ListItem = New ListItem()

            Dim categoryName As String = categoryFatherName
            Dim categoryID As String = drv("CategoryID").ToString()
            If categoryFatherID <> -1 Then
                categoryName = categoryName + _separatorLine & drv.Item("CategoryName")
            Else
                categoryName = drv.Item("CategoryName")
            End If
            li.Text = categoryName
            li.Value = CInt(categoryID)
            ddlCategory.Items.Add(li)
            BindData(dt, Convert.ToInt32(categoryID), categoryName)
        Next


    End Sub






End Class
